/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.remote.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.remote.ui.wizards.repositorystep.RepositoryStep;
import org.netbeans.modules.subversion.remote.ui.wizards.urlpatternstep.URLPatternStep;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public final class URLPatternWizard
implements ChangeListener {
    private WizardDescriptor.Panel[] panels;
    private RepositoryStep repositoryStep;
    private URLPatternStep urlPatternStep;
    private AbstractStep.WizardMessage errorMessage;
    private WizardDescriptor wizardDescriptor;
    private PanelsIterator wizardIterator;
    private final FileSystem fileSystem;

    public URLPatternWizard(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public boolean show() {
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(URLPatternWizard.class, (String)"CTL_URLPattern"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(URLPatternWizard.class, (String)"CTL_URLPattern"));
        dialog.setVisible(true);
        dialog.toFront();
        return this.wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
    }

    private void setErrorMessage(AbstractStep.WizardMessage msg) {
        this.errorMessage = msg;
        if (this.wizardDescriptor != null) {
            if (this.errorMessage != null) {
                if (this.errorMessage.isInfo()) {
                    this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)this.errorMessage.getMessage());
                } else {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.errorMessage.getMessage());
                }
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.wizardIterator == null) {
            return;
        }
        AbstractStep step = (AbstractStep)this.wizardIterator.current();
        if (step == null) {
            return;
        }
        this.setErrorMessage(step.getErrorMessage());
    }

    public String getPattern() {
        return this.urlPatternStep.getPattern();
    }

    public String getRepositoryFolder() {
        return this.urlPatternStep.getRepositoryFolder();
    }

    public boolean useName() {
        return this.urlPatternStep.useName();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            URLPatternWizard.this.repositoryStep = new RepositoryStep(URLPatternWizard.this.fileSystem, 8, "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.urlPattern");
            URLPatternWizard.this.repositoryStep.addChangeListener(URLPatternWizard.this);
            URLPatternWizard.this.urlPatternStep = new URLPatternStep(URLPatternWizard.this.fileSystem);
            URLPatternWizard.this.urlPatternStep.addChangeListener(URLPatternWizard.this);
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{URLPatternWizard.this.repositoryStep, URLPatternWizard.this.urlPatternStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public void nextPanel() {
            super.nextPanel();
            if (this.current() == URLPatternWizard.this.urlPatternStep) {
                URLPatternWizard.this.urlPatternStep.setup(URLPatternWizard.this.repositoryStep.getRepositoryFile());
            }
        }
    }
}

