/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.EventQueue;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.commands.CodingStandardsFixer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CodingStandardsFixerCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = -575231773758741767L;
    public static final String LEVEL = "codingStandardsFixer.level";
    public static final String CONFIG = "codingStandardsFixer.config";
    public static final String OPTIONS = "codingStandardsFixer.options";
    final Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context;
    final Preferences settings;
    private JComboBox configComboBox;
    private JLabel configLabel;
    private JComboBox levelComboBox;
    private JLabel levelLabel;
    private JLabel optionsLabel;
    private JTextField optionsTextField;

    public CodingStandardsFixerCustomizerPanel(Analyzer.CustomizerContext<Void, CodingStandardsFixerCustomizerPanel> context) {
        assert (EventQueue.isDispatchThread());
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setLevelComboBox();
        this.setConfigComboBox();
        this.setOptionsTextField();
    }

    private void setLevelComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel<String> levelComboBoxModel = new DefaultComboBoxModel<String>();
        for (String level : CodingStandardsFixer.ALL_LEVEL) {
            levelComboBoxModel.addElement(level);
        }
        levelComboBoxModel.setSelectedItem(this.settings.get(LEVEL, AnalysisOptions.getInstance().getCodingStandardsFixerLevel()));
        this.levelComboBox.setModel(levelComboBoxModel);
    }

    private void setConfigComboBox() {
        assert (EventQueue.isDispatchThread());
        DefaultComboBoxModel<String> configComboBoxModel = new DefaultComboBoxModel<String>();
        for (String config : CodingStandardsFixer.ALL_CONFIG) {
            configComboBoxModel.addElement(config);
        }
        configComboBoxModel.setSelectedItem(this.settings.get(CONFIG, AnalysisOptions.getInstance().getCodingStandardsFixerConfig()));
        this.configComboBox.setModel(configComboBoxModel);
    }

    private void setOptionsTextField() {
        assert (EventQueue.isDispatchThread());
        this.optionsTextField.setText(this.settings.get(OPTIONS, AnalysisOptions.getInstance().getCodingStandardsFixerOptions()));
    }

    private void initComponents() {
        this.levelLabel = new JLabel();
        this.levelComboBox = new JComboBox();
        this.configLabel = new JLabel();
        this.configComboBox = new JComboBox();
        this.optionsLabel = new JLabel();
        this.optionsTextField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.levelLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.levelLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.configLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(CodingStandardsFixerCustomizerPanel.class, (String)"CodingStandardsFixerCustomizerPanel.optionsLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.levelLabel).addComponent(this.configLabel).addComponent(this.optionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configComboBox, -2, -1, -2).addComponent(this.levelComboBox, -2, -1, -2).addComponent(this.optionsTextField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.levelLabel).addComponent(this.levelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configComboBox, -2, -1, -2).addComponent(this.configLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel).addComponent(this.optionsTextField, -2, -1, -2))));
    }
}

