/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base.att;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.asm.base.syntax.IdentResolver;
import org.netbeans.modules.cnd.asm.model.AbstractAsmModel;
import org.netbeans.modules.cnd.asm.model.lang.BitWidth;
import org.netbeans.modules.cnd.asm.model.lang.Register;
import org.netbeans.modules.cnd.asm.model.lang.instruction.Instruction;

public class ATTIdentResolver
implements IdentResolver {
    private final AbstractAsmModel model;
    private final Map<Character, BitWidth> suffixes;
    private static final Set<String> directives;

    public ATTIdentResolver(AbstractAsmModel model) {
        this.model = model;
        this.suffixes = new HashMap<Character, BitWidth>(4, 1.0f);
        this.suffixes.put(Character.valueOf('b'), BitWidth.BYTE);
        this.suffixes.put(Character.valueOf('w'), BitWidth.WORD);
        this.suffixes.put(Character.valueOf('l'), BitWidth.DWORD);
        this.suffixes.put(Character.valueOf('q'), BitWidth.QWORD);
    }

    protected boolean isDirective(String name) {
        return directives.contains(name);
    }

    @Override
    public Instruction getInstruction(String name) {
        int len = name.length();
        Instruction res = this.model.getInstructionByName(name);
        if (res == null && len > 1 && this.suffixes.get(Character.valueOf(name.charAt(len - 1))) != null) {
            name = name.substring(0, len - 1);
            res = this.model.getInstructionByName(name);
        }
        return res;
    }

    @Override
    public Register getRegister(String name) {
        if (name.startsWith("%")) {
            name = name.substring(1);
        }
        return this.model.getRegisterByName(name);
    }

    @Override
    public IdentResolver.IdentType getIdentType(String name) {
        if (this.isDirective(name)) {
            return IdentResolver.IdentType.DIRECTIVE;
        }
        if (this.getInstruction(name) != null) {
            return IdentResolver.IdentType.INSTRUCTION;
        }
        return IdentResolver.IdentType.UNKN_IDENT;
    }

    static {
        String[] dnames = new String[]{".align", ".ascii", ".bcd", ".bss", ".byte", ".2byte", ".4byte", ".8byte", ".comm", ".data", ".double", ".even", ".file", ".float", ".globl", ".global", ".group", ".hidden", ".ident", ".lcomm", ".local", ".long", ".popsection", ".previous", ".pushsection", ".quad", ".rel", ".section", ".set", ".skip", ".sleb128", ".string", ".symbolic", ".size", ".tbss", ".tcomm", ".tdata", ".text", ".type", ".uleb128", ".value", ".word", ".weak", ".zero", ".register"};
        directives = new HashSet<String>();
        Collections.addAll(directives, dnames);
    }
}

