/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.ByteBufferInputStream;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.TaskBase;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import com.sun.enterprise.web.connector.grizzly.WorkerThread;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class DefaultReadTask
extends TaskBase
implements ReadTask {
    private long idleTime = 30000L;
    protected TaskContext taskContext;
    protected TaskEvent taskEvent;
    protected ByteBuffer byteBuffer;
    protected ProcessorTask processorTask;
    protected int maxPostSize = 0x1900000;
    protected ByteBufferInputStream inputStream;
    protected StreamAlgorithm algorithm;
    protected boolean bytesAvailable = false;
    protected boolean useDirectByteBuffer = true;
    protected boolean useByteBufferView = false;

    public void initialize(StreamAlgorithm algorithm, boolean useDirectByteBuffer, boolean useByteBufferView) {
        this.type = 1;
        this.algorithm = algorithm;
        this.inputStream = new ByteBufferInputStream();
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.useByteBufferView = useByteBufferView;
    }

    public void attachProcessor(ProcessorTask processorTask) {
        this.processorTask = processorTask;
        this.configureProcessorTask();
    }

    protected void configureProcessorTask() {
        this.processorTask.setSelectionKey(this.key);
        this.processorTask.setSocket(((SocketChannel)this.key.channel()).socket());
        this.processorTask.setHandler(this.algorithm.getHandler());
        this.processorTask.setDropConnection(this.selectorThread.getKeepAlivePipeline().dropConnection());
    }

    public void detachProcessor() {
        if (this.processorTask != null) {
            this.processorTask.recycle();
        }
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i > -1; --i) {
                if (this.taskEvent == null) {
                    this.taskEvent = new TaskEvent();
                }
                this.taskEvent.attach(this);
                this.taskEvent.setStatus(2);
                ((TaskListener)this.listeners.get(i)).taskEvent(this.taskEvent);
            }
            this.clearTaskListeners();
        }
        if (this.recycle && this.processorTask != null) {
            this.selectorThread.returnTask(this.processorTask);
            this.processorTask = null;
        }
    }

    public void doTask() throws IOException {
        if (this.byteBuffer == null) {
            WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
            this.byteBuffer = workerThread.getByteBuffer();
            if (workerThread.getByteBuffer() == null) {
                this.byteBuffer = this.algorithm.allocate(this.useDirectByteBuffer, this.useByteBufferView, this.selectorThread.getBufferSize());
                workerThread.setByteBuffer(this.byteBuffer);
            }
        }
        this.doTask(this.byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTask(ByteBuffer byteBuffer) {
        int count = 0;
        Socket socket = null;
        SocketChannel socketChannel = null;
        boolean keepAlive = false;
        Exception exception = null;
        this.key.attach(null);
        try {
            socketChannel = (SocketChannel)this.key.channel();
            socket = socketChannel.socket();
            this.algorithm.setSocketChannel(socketChannel);
            int loop = 0;
            boolean bufferSize = false;
            while (socketChannel.isOpen() && (this.bytesAvailable || (count = socketChannel.read(byteBuffer)) > -1)) {
                if (count == 0 && !this.bytesAvailable) {
                    if (++loop <= 2) continue;
                    break;
                }
                if (this.bytesAvailable) {
                    count = byteBuffer.position();
                }
                this.bytesAvailable = false;
                byteBuffer = this.algorithm.preParse(byteBuffer);
                this.inputStream.setByteBuffer(byteBuffer);
                this.inputStream.setSelectionKey(this.key);
                if (this.algorithm.parse(byteBuffer)) {
                    keepAlive = this.executeProcessorTask();
                    if (keepAlive) continue;
                    break;
                }
                keepAlive = true;
            }
        }
        catch (IOException ex) {
            exception = ex;
        }
        catch (RuntimeException ex) {
            exception = ex;
        }
        finally {
            this.manageKeepAlive(keepAlive, count, exception);
        }
    }

    protected void manageKeepAlive(boolean keepAlive, int count, Exception exception) {
        if (count == -1 || !this.key.isValid() || exception != null) {
            keepAlive = false;
            if (exception != null) {
                this.detachProcessor();
                if (SelectorThread.logger().isLoggable(Level.FINE)) {
                    SelectorThread.logger().log(Level.FINE, "SocketChannel Read Exception:", exception);
                }
            }
        }
        if (keepAlive) {
            this.registerKey();
        }
        this.terminate(keepAlive);
    }

    public boolean executeProcessorTask() throws IOException {
        boolean registerKey = false;
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "executeProcessorTask");
        }
        if (this.algorithm.getHandler() != null && this.algorithm.getHandler().handle(null, 2) == 1) {
            return true;
        }
        if (this.processorTask == null) {
            this.attachProcessor(this.selectorThread.getProcessorTask());
        }
        try {
            registerKey = this.processorTask.process(this.inputStream, null);
        }
        catch (Exception e) {
            SelectorThread.logger().log(Level.SEVERE, "readTask.processException", e);
        }
        this.detachProcessor();
        return registerKey;
    }

    protected void returnTask() {
        if (this.recycle) {
            this.recycle();
            this.selectorThread.returnTask(this);
        }
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2 || event.getStatus() == 1) {
            this.terminate(this.processorTask.isKeepAlive());
        }
    }

    public void terminate(boolean keepAlive) {
        if (!keepAlive) {
            this.finishConnection();
        }
        this.returnTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.byteBuffer != null) {
            try {
                WorkerThread workerThread = (WorkerThread)((Object)Thread.currentThread());
                if (workerThread.getByteBuffer() == null) {
                    workerThread.setByteBuffer(this.byteBuffer);
                }
            }
            catch (ClassCastException ex) {
                if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                    SelectorThread.logger().log(Level.FINEST, "recycle", ex);
                }
            }
            finally {
                this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
                this.byteBuffer.clear();
            }
        }
        this.inputStream.recycle();
        this.algorithm.recycle();
        this.key = null;
        this.inputStream.setSelectionKey(null);
        this.byteBuffer = null;
    }

    protected void finishConnection() {
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "finishConnection");
        }
        try {
            if (this.taskContext != null) {
                this.taskContext.recycle();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selectorThread.cancelKey(this.key);
    }

    public void registerKey() {
        if (this.key.isValid()) {
            if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                SelectorThread.logger().log(Level.FINEST, "registerKey");
            }
            this.selectorThread.registerKey(this.key);
        }
    }

    public ProcessorTask getProcessorTask() {
        return this.processorTask;
    }

    public ByteBuffer getByteBuffer() {
        if (this.byteBuffer == null) {
            this.byteBuffer = this.algorithm.allocate(this.useDirectByteBuffer, this.useByteBufferView, this.selectorThread.getBufferSize());
        }
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setBytesAvailable(boolean bytesAvailable) {
        this.bytesAvailable = bytesAvailable;
    }

    public void setIdleTime(long idleTime) {
        this.idleTime = idleTime;
    }

    public long getIdleTime() {
        return this.idleTime;
    }
}

