/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2me.project.wizard.J2MEProjectWizardIterator;
import org.netbeans.modules.j2me.project.wizard.J2MESampleProjectGenerator;
import org.netbeans.modules.j2me.project.wizard.PanelConfigureProject;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class J2MESampleProjectIterator
implements TemplateWizard.Iterator {
    private static final Logger LOG = Logger.getLogger(J2MESampleProjectIterator.class.getName());
    private static final long serialVersionUID = 4L;
    static final String PROJECT_DIR = "projdir";
    static final String NAME = "name";
    static final String SOURCE_ROOT = "sourceRoot";
    static final String JDK_PLATFORM = "jdk";
    static final String PLATFORM = "platform";
    static final String DEVICE = "device";
    static final String CONFIGURATION = "config";
    static final String PROFILE = "profile";
    static final String OPTIONAL_API = "optionalApi";
    static final String PLATFORM_BOOTCLASSPATH = "bootclasspath";
    int currentIndex;
    WizardDescriptor.Panel<WizardDescriptor> basicPanel;
    private transient WizardDescriptor wiz;

    static Object create() {
        return new J2MESampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.basicPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        String name = templateWizard.getTemplate().getNodeDelegate().getDisplayName();
        if (name != null) {
            name = name.replaceAll(" ", "");
        }
        templateWizard.putProperty(NAME, (Object)name);
        templateWizard.putProperty("NewProjectWizard_Title", (Object)templateWizard.getTemplate().getNodeDelegate().getDisplayName());
        this.basicPanel = new PanelConfigureProject(J2MEProjectWizardIterator.WizardType.SAMPLE);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.basicPanel = null;
        this.currentIndex = -1;
        this.wiz.putProperty(PROJECT_DIR, null);
        this.wiz.putProperty(NAME, null);
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        File projectLocation = (File)this.wiz.getProperty(PROJECT_DIR);
        String name = (String)this.wiz.getProperty(NAME);
        String j2mePlatform = (String)((JavaPlatform)this.wiz.getProperty(PLATFORM)).getProperties().get("platform.ant.name");
        String configuration = (String)this.wiz.getProperty(CONFIGURATION);
        String profile = (String)this.wiz.getProperty(PROFILE);
        String device = (String)this.wiz.getProperty(DEVICE);
        String jdk = (String)((JavaPlatform)this.wiz.getProperty(JDK_PLATFORM)).getProperties().get("platform.ant.name");
        String optionalApi = (String)this.wiz.getProperty(OPTIONAL_API);
        String bootclasspath = (String)this.wiz.getProperty(PLATFORM_BOOTCLASSPATH);
        String platformType = ((J2MEPlatform)this.wiz.getProperty(PLATFORM)).getType();
        FileObject templateFO = templateWizard.getTemplate().getPrimaryFile();
        FileObject prjLoc = J2MESampleProjectGenerator.createProjectFromTemplate(templateFO, projectLocation, name, jdk, j2mePlatform, device, configuration, profile, optionalApi, bootclasspath, platformType);
        HashSet<DataObject> set = new HashSet<DataObject>();
        set.add(DataObject.find((FileObject)prjLoc));
        Object openFile = templateFO.getAttribute("defaultFileToOpen");
        if (openFile instanceof String) {
            FileObject openFO = prjLoc.getFileObject((String)openFile);
            set.add(DataObject.find((FileObject)openFO));
        }
        return set;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = new String[]{NbBundle.getMessage(J2MESampleProjectIterator.class, (String)"LBL_NWP1_ProjectTitleName")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }
}

