/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.LinkRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputLinkRenderer
extends LinkRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.OUTPUTLINK);
    protected boolean namespaceParameters;

    public OutputLinkRenderer() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        this.namespaceParameters = webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (this.shouldDecode(component)) {
            this.decodeBehaviors(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        UIOutput output = (UIOutput)component;
        boolean componentDisabled = false;
        if (output.getAttributes().get("disabled") != null && output.getAttributes().get("disabled").equals(Boolean.TRUE)) {
            componentDisabled = true;
        }
        if (componentDisabled) {
            this.renderAsDisabled(context, output);
        } else {
            this.renderAsActive(context, output);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.encodeRecursive(context, kid);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (Boolean.TRUE.equals(component.getAttributes().get("disabled"))) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getFragment(UIComponent component) {
        String fragment = (String)component.getAttributes().get("fragment");
        String string = fragment = fragment != null ? fragment.trim() : "";
        if (fragment.length() > 0) {
            fragment = "#" + fragment;
        }
        return fragment;
    }

    protected Object getValue(UIComponent component) {
        if (Util.componentIsDisabled(component)) {
            return null;
        }
        return ((UIOutput)component).getValue();
    }

    protected void renderAsActive(FacesContext context, UIComponent component) throws IOException {
        String hrefVal = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Value to be rendered " + hrefVal);
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("a", component);
        String writtenId = this.writeIdAttributeIfNecessary(context, writer, component);
        if (null != writtenId) {
            writer.writeAttribute("name", writtenId, "name");
        }
        if (null == hrefVal || 0 == hrefVal.length()) {
            hrefVal = "";
        }
        HtmlBasicRenderer.Param[] paramList = this.getParamList(component);
        StringBuffer sb = new StringBuffer();
        sb.append(hrefVal);
        boolean paramWritten = hrefVal.indexOf(63) > 0;
        String namingContainerId = null;
        if (this.namespaceParameters) {
            UIViewRoot viewRoot = context.getViewRoot();
            namingContainerId = viewRoot.getContainerClientId(context);
        }
        int len = paramList.length;
        for (int i = 0; i < len; ++i) {
            String pn = paramList[i].name;
            if (pn == null || pn.length() == 0) continue;
            if (namingContainerId != null) {
                pn = namingContainerId + pn;
            }
            String pv = paramList[i].value;
            sb.append(paramWritten ? (char)'&' : '?');
            sb.append(URLEncoder.encode(pn, "UTF-8"));
            sb.append('=');
            if (pv != null && pv.length() != 0) {
                sb.append(URLEncoder.encode(pv, "UTF-8"));
            }
            paramWritten = true;
        }
        sb.append(this.getFragment(component));
        writer.writeURIAttribute("href", context.getExternalContext().encodeResourceURL(sb.toString()), "href");
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        String target = (String)component.getAttributes().get("target");
        if (target != null && target.trim().length() != 0) {
            writer.writeAttribute("target", target, "target");
        }
        this.writeCommonLinkAttributes(writer, component);
        writer.flush();
    }
}

