/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ejb;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceSupport;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EjbEntRefContainerImpl
implements EnterpriseReferenceContainer {
    private static final String SERVICE_LOCATOR_PROPERTY = "project.serviceLocator.class";
    private final Project ejbProject;

    public EjbEntRefContainerImpl(Project prj) {
        this.ejbProject = prj;
    }

    public String addEjbReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        return this.addReference(ref, refType, ejbRefName, false, referencingFile, referencingClass);
    }

    public String addEjbLocalReference(EjbReference ref, EjbReference.EjbRefIType refType, String ejbRefName, FileObject referencingFile, String referencingClass) throws IOException {
        return this.addReference(ref, refType, ejbRefName, true, referencingFile, referencingClass);
    }

    private String addReference(final EjbReference ejbReference, EjbReference.EjbRefIType refType, final String ejbRefName, final boolean local, FileObject referencingFile, final String referencingClass) throws IOException {
        EjbJar ejbModule = this.findEjbModule(referencingFile);
        MetadataModel metadataModel = ejbModule.getMetadataModel();
        MetadataModel ejbReferenceMetadataModel = ejbReference.getEjbModule().getMetadataModel();
        String ejbName = (String)ejbReferenceMetadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws Exception {
                return metadata.findByEjbClass(ejbReference.getEjbClass()).getEjbName();
            }
        });
        FileObject ejbReferenceEjbClassFO = SourceUtils.getFileObject((String)ejbReference.getComponentName(refType), (ClasspathInfo)ejbReference.getClasspathInfo());
        assert (ejbReferenceEjbClassFO != null) : "Reference FileObject not found: " + ejbReference.getComponentName(refType);
        Project otherPrj = FileOwnerQuery.getOwner((FileObject)ejbReferenceEjbClassFO);
        NbMavenProject oprj = (NbMavenProject)otherPrj.getLookup().lookup(NbMavenProject.class);
        String jarName = "";
        if (oprj != null) {
            jarName = oprj.getMavenProject().getBuild().getFinalName();
        }
        jarName = jarName + "#";
        final String ejbLink = jarName + ejbName;
        final boolean fromSameProject = oprj != null && this.ejbProject.equals(otherPrj) || oprj == null;
        final boolean[] write = new boolean[]{false};
        String resourceName = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) {
                String refName = null;
                Ejb model = metadata.findByEjbClass(referencingClass);
                if (model == null) {
                    return ejbRefName;
                }
                if (local) {
                    refName = EjbEntRefContainerImpl.this.getUniqueEjbLocalRefName(model, ejbRefName);
                    EjbLocalRef ejbRef = model.newEjbLocalRef();
                    ejbRef.setEjbRefName(refName);
                    ejbRef.setEjbRefType(ejbReference.getEjbRefType());
                    ejbRef.setLocal(ejbReference.getLocal());
                    ejbRef.setLocalHome(ejbReference.getLocalHome());
                    if (fromSameProject) {
                        ejbRef.setEjbLink(EjbEntRefContainerImpl.this.stripModuleName(ejbLink));
                    }
                    model.addEjbLocalRef(ejbRef);
                } else {
                    refName = EjbEntRefContainerImpl.this.getUniqueEjbRefName(model, ejbRefName);
                    EjbRef ejbRef = model.newEjbRef();
                    ejbRef.setEjbRefName(refName);
                    ejbRef.setEjbRefType(ejbReference.getEjbRefType());
                    ejbRef.setRemote(ejbReference.getRemote());
                    ejbRef.setHome(ejbReference.getRemoteHome());
                    if (fromSameProject) {
                        ejbRef.setEjbLink(EjbEntRefContainerImpl.this.stripModuleName(ejbLink));
                    }
                    model.addEjbRef(ejbRef);
                }
                write[0] = true;
                return refName;
            }
        });
        if (!fromSameProject && oprj != null) {
            final String grId = oprj.getMavenProject().getGroupId();
            final String artId = oprj.getMavenProject().getArtifactId();
            final String version = oprj.getMavenProject().getVersion();
            Utilities.performPOMModelOperations((FileObject)this.ejbProject.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    Dependency d = ModelUtils.checkModelDependency((POMModel)model, (String)grId, (String)artId, (boolean)true);
                    if (d != null) {
                        d.setVersion(version);
                    }
                }
            }));
        }
        if (write[0]) {
            this.writeDD(ejbModule);
        }
        ProjectManager.getDefault().saveProject(this.ejbProject);
        return resourceName;
    }

    public String getServiceLocatorName() {
        AuxiliaryProperties props = (AuxiliaryProperties)this.ejbProject.getLookup().lookup(AuxiliaryProperties.class);
        return props.get(SERVICE_LOCATOR_PROPERTY, true);
    }

    public void setServiceLocatorName(String serviceLocator) throws IOException {
        AuxiliaryProperties props = (AuxiliaryProperties)this.ejbProject.getLookup().lookup(AuxiliaryProperties.class);
        props.put(SERVICE_LOCATOR_PROPERTY, serviceLocator, true);
    }

    private String stripModuleName(String ejbLink) {
        int index = ejbLink.indexOf(35);
        return ejbLink.substring(index + 1);
    }

    private EjbJar findEjbModule(FileObject fileObject) {
        return EjbJar.getEjbJar((FileObject)fileObject);
    }

    private void writeDD(EjbJar ejbModule) throws IOException {
        FileObject fo;
        if (EjbEntRefContainerImpl.isDescriptorMandatory(ejbModule.getJ2eePlatformVersion()) && (fo = ejbModule.getDeploymentDescriptor()) != null) {
            DDProvider.getDefault().getDDRoot(fo).write(fo);
        }
    }

    public String addResourceRef(final ResourceReference ref, FileObject referencingFile, final String referencingClass) throws IOException {
        EjbJar ejbModule = this.findEjbModule(referencingFile);
        MetadataModel metadataModel = ejbModule.getMetadataModel();
        final boolean[] write = new boolean[]{false};
        String resourceName = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) throws IOException {
                Ejb ejb = metadata.findByEjbClass(referencingClass);
                if (ejb == null) {
                    return ref.getResRefName();
                }
                String resourceRefName = ref.getResRefName();
                if (DataSource.class.getName().equals(ref.getResType())) {
                    if (!EjbEntRefContainerImpl.this.isJdbcConnectionAlreadyUsed(ejb, ref)) {
                        resourceRefName = EjbEntRefContainerImpl.this.getUniqueResRefName(ejb, ref.getResRefName());
                        ResourceRef resourceRef = ejb.newResourceRef();
                        EnterpriseReferenceSupport.populate((ResourceReference)ref, (String)resourceRefName, (ResourceRef)resourceRef);
                        ejb.addResourceRef(resourceRef);
                        write[0] = true;
                    }
                } else if (!EjbEntRefContainerImpl.isResourceRefUsed(ejb, ref)) {
                    resourceRefName = EjbEntRefContainerImpl.this.getUniqueResRefName(ejb, ref.getResRefName());
                    ResourceRef resourceRef = ejb.newResourceRef();
                    EnterpriseReferenceSupport.populate((ResourceReference)ref, (String)resourceRefName, (ResourceRef)resourceRef);
                    ejb.addResourceRef(resourceRef);
                    write[0] = true;
                }
                return resourceRefName;
            }
        });
        if (write[0]) {
            this.writeDD(ejbModule);
        }
        return resourceName;
    }

    public String addDestinationRef(final MessageDestinationReference ref, FileObject referencingFile, final String referencingClass) throws IOException {
        EjbJar ejbModule = this.findEjbModule(referencingFile);
        MetadataModel metadataModel = ejbModule.getMetadataModel();
        final boolean[] write = new boolean[]{false};
        String resourceName = (String)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){

            public String run(EjbJarMetadata metadata) {
                Ejb ejb = metadata.findByEjbClass(referencingClass);
                if (ejb == null) {
                    return ref.getMessageDestinationRefName();
                }
                try {
                    for (MessageDestinationRef mdRef : ejb.getMessageDestinationRef()) {
                        if (!mdRef.getMessageDestinationRefName().equals(ref.getMessageDestinationRefName())) continue;
                        return mdRef.getMessageDestinationRefName();
                    }
                }
                catch (VersionNotSupportedException ex) {
                    Logger.getLogger("global").log(Level.INFO, null, ex);
                }
                String destinationRefName = EjbEntRefContainerImpl.this.getUniqueMessageDestRefName(ejb, ref.getMessageDestinationRefName());
                try {
                    MessageDestinationRef messageDestinationRef = ejb.newMessageDestinationRef();
                    EnterpriseReferenceSupport.populate((MessageDestinationReference)ref, (String)destinationRefName, (MessageDestinationRef)messageDestinationRef);
                    ejb.addMessageDestinationRef(messageDestinationRef);
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    // empty catch block
                }
                write[0] = true;
                return destinationRefName;
            }
        });
        if (write[0]) {
            this.writeDD(ejbModule);
        }
        return resourceName;
    }

    private boolean isJdbcConnectionAlreadyUsed(Ejb ejb, ResourceReference ref) throws IOException {
        if (DataSource.class.getName().equals(ref.getResType())) {
            for (ResourceRef existingRef : ejb.getResourceRef()) {
                boolean canCompareDefDesc;
                String newDefaultDescription = ref.getDefaultDescription();
                String existingDefaultDescription = existingRef.getDefaultDescription();
                boolean bl = canCompareDefDesc = newDefaultDescription != null && existingDefaultDescription != null;
                if (!DataSource.class.getName().equals(existingRef.getResType()) || canCompareDefDesc && !newDefaultDescription.equals(existingDefaultDescription) || !ref.getResRefName().equals(existingRef.getResRefName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isResourceRefUsed(Ejb ejb, ResourceReference resRef) {
        String resRefName = resRef.getResRefName();
        String resRefType = resRef.getResType();
        for (ResourceRef existingRef : ejb.getResourceRef()) {
            if (!resRefName.equals(existingRef.getResRefName()) || !resRefType.equals(existingRef.getResType())) continue;
            return true;
        }
        return false;
    }

    private String getUnigueName(Set<String> existingNames, String originalValue) {
        String proposedValue = originalValue;
        int index = 1;
        while (existingNames.contains(proposedValue)) {
            proposedValue = originalValue + Integer.toString(index++);
        }
        return proposedValue;
    }

    private String getUniqueResRefName(Ejb bean, String originalValue) {
        HashSet<String> resRefNames = new HashSet<String>();
        for (ResourceRef resourceRef : bean.getResourceRef()) {
            resRefNames.add(resourceRef.getResRefName());
        }
        return this.getUnigueName(resRefNames, originalValue);
    }

    private String getUniqueEjbRefName(Ejb bean, String originalValue) {
        HashSet<String> ejbRefNames = new HashSet<String>();
        for (EjbRef ejbRef : bean.getEjbRef()) {
            ejbRefNames.add(ejbRef.getEjbRefName());
        }
        return this.getUnigueName(ejbRefNames, originalValue);
    }

    private String getUniqueEjbLocalRefName(Ejb bean, String originalValue) {
        HashSet<String> ejbLocalRefNames = new HashSet<String>();
        for (EjbLocalRef ejbLocalRef : bean.getEjbLocalRef()) {
            ejbLocalRefNames.add(ejbLocalRef.getEjbRefName());
        }
        return this.getUnigueName(ejbLocalRefNames, originalValue);
    }

    private String getUniqueMessageDestRefName(Ejb bean, String originalValue) {
        HashSet<String> messageDestRefNames = new HashSet<String>();
        try {
            for (MessageDestinationRef messageDestRef : bean.getMessageDestinationRef()) {
                messageDestRefNames.add(messageDestRef.getMessageDestinationRefName());
            }
        }
        catch (VersionNotSupportedException vnse) {
            Exceptions.printStackTrace((Throwable)vnse);
        }
        return this.getUnigueName(messageDestRefNames, originalValue);
    }

    private static boolean isDescriptorMandatory(String j2eeVersion) {
        return "1.3".equals(j2eeVersion) || "1.4".equals(j2eeVersion);
    }
}

