/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.j2ee.weblogic9.Bundle;
import org.openide.util.NbBundle;

public class CertificateQuestionPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CertificateQuestionPanel.class.getName());
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private JScrollPane certificateScrollPane;
    private JTable certificateTable;
    private JScrollPane messageScrollPane;
    private JTextArea messageTextArea;

    public CertificateQuestionPanel(X509Certificate cert) {
        this.initComponents();
        this.setCertificateInfo(cert);
    }

    private void setCertificateInfo(X509Certificate cert) {
        BigInteger serialNumber = cert.getSerialNumber();
        byte[] byteValue = serialNumber.toByteArray();
        String certSerialNumber = CertificateQuestionPanel.bytesToHex(byteValue);
        String md5 = CertificateQuestionPanel.getCertFingerPrint("MD5", cert);
        String sha1 = CertificateQuestionPanel.getCertFingerPrint("SHA1", cert);
        Map<String, String> subject = CertificateQuestionPanel.getDNString(cert.getSubjectDN().toString());
        Map<String, String> issuer = CertificateQuestionPanel.getDNString(cert.getIssuerDN().toString());
        DateFormat format = DateFormat.getDateInstance();
        Object[] columnNames = new String[]{Bundle.LBL_Description(), Bundle.LBL_Value()};
        Object[][] data = new Object[][]{{Bundle.LBL_IssuedTo(), null}, {Bundle.LBL_CommonName(), subject.get("CN")}, {Bundle.LBL_Organization(), subject.get("O")}, {Bundle.LBL_OrganizationalUnit(), subject.get("OU")}, {Bundle.LBL_SerialNumber(), certSerialNumber}, {Bundle.LBL_IssuedBy(), null}, {Bundle.LBL_CommonName(), issuer.get("CN")}, {Bundle.LBL_Organization(), issuer.get("O")}, {Bundle.LBL_OrganizationalUnit(), issuer.get("OU")}, {Bundle.LBL_ValidityPeriod(), null}, {Bundle.LBL_BeginsOn(), format.format(cert.getNotBefore())}, {Bundle.LBL_ExpiresOn(), format.format(cert.getNotAfter())}, {Bundle.LBL_Fingerprints(), null}, {Bundle.LBL_MD5Fingerprint(), md5}, {Bundle.LBL_SHA1Fingerprint(), sha1}};
        this.certificateTable.setModel(new DefaultTableModel(data, columnNames){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        this.certificateTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.certificateTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.certificateTable.setAutoResizeMode(4);
        this.certificateTable.repaint();
    }

    private static Map<String, String> getDNString(String dnString) {
        int len = dnString.length();
        boolean inQuote = false;
        boolean inKey = true;
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = dnString.charAt(i);
            if (!inQuote) {
                if (inKey && ch == '=') {
                    inKey = false;
                    continue;
                }
                if (ch == ',') {
                    result.put(key.toString().trim(), value.toString().trim());
                    key.setLength(0);
                    value.setLength(0);
                    inKey = true;
                    continue;
                }
            }
            if (ch == '\"' || ch == '\'') {
                inQuote = !inQuote;
                continue;
            }
            if (inKey) {
                key.append(ch);
                continue;
            }
            value.append(ch);
        }
        result.put(key.toString().trim(), value.toString().trim());
        return result;
    }

    private static String getCertFingerPrint(String mdAlg, X509Certificate cert) {
        try {
            byte[] encCertInfo = cert.getEncoded();
            MessageDigest md = MessageDigest.getInstance(mdAlg);
            byte[] digest = md.digest(encCertInfo);
            return CertificateQuestionPanel.bytesToHex(digest);
        }
        catch (CertificateEncodingException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return null;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private void initComponents() {
        this.certificateScrollPane = new JScrollPane();
        this.certificateTable = new JTable();
        this.messageScrollPane = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.certificateScrollPane.setViewportView(this.certificateTable);
        this.messageScrollPane.setBorder(null);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setText(NbBundle.getMessage(CertificateQuestionPanel.class, (String)"MSG_Explanation"));
        this.messageTextArea.setWrapStyleWord(true);
        this.messageScrollPane.setViewportView(this.messageTextArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageScrollPane).addComponent(this.certificateScrollPane, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messageScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certificateScrollPane, -1, 344, Short.MAX_VALUE)));
    }
}

