/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.optional.NonProxyHostsHelper;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.spi.WebLogicTrustHandler;
import org.openide.util.Lookup;

public final class WLConnectionSupport {
    private final WLDeploymentManager deploymentManager;
    private static final String PORTABLE_OBJECT_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";

    public WLConnectionSupport(WLDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeAction(Callable<T> action) throws Exception {
        WLConnectionSupport wLConnectionSupport = this;
        synchronized (wLConnectionSupport) {
            WebLogicTrustHandler handler;
            String nonProxyHosts;
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            String portable = System.getProperty(PORTABLE_OBJECT_PROPERTY);
            String originalNonProxyHosts = System.getProperty("http.nonProxyHosts");
            String configuredNonProxyHosts = NonProxyHostsHelper.getNonProxyHosts();
            boolean nonProxyHostsChanged = false;
            if (!configuredNonProxyHosts.isEmpty() && !(nonProxyHosts = originalNonProxyHosts != null ? NonProxyHostsHelper.compactNonProxyHosts(originalNonProxyHosts + "," + configuredNonProxyHosts) : configuredNonProxyHosts).equals(originalNonProxyHosts)) {
                nonProxyHostsChanged = true;
                System.setProperty("http.nonProxyHosts", nonProxyHosts);
            }
            if (this.deploymentManager.getCommonConfiguration().isSecured() && (handler = (WebLogicTrustHandler)Lookup.getDefault().lookup(WebLogicTrustHandler.class)) != null) {
                for (Map.Entry e : handler.getTrustProperties(this.deploymentManager.getCommonConfiguration()).entrySet()) {
                    System.setProperty((String)e.getKey(), (String)e.getValue());
                }
            }
            Thread.currentThread().setContextClassLoader(WLDeploymentFactory.getInstance().getClassLoader(this.deploymentManager));
            T t = action.call();
            return t;
            finally {
                Thread.currentThread().setContextClassLoader(originalLoader);
                if (nonProxyHostsChanged) {
                    if (originalNonProxyHosts == null) {
                        System.clearProperty("http.nonProxyHosts");
                    } else {
                        System.setProperty("http.nonProxyHosts", originalNonProxyHosts);
                    }
                }
                if (portable == null) {
                    System.clearProperty(PORTABLE_OBJECT_PROPERTY);
                } else {
                    System.setProperty(PORTABLE_OBJECT_PROPERTY, portable);
                }
            }
        }
    }

    public <T> T executeAction(final JMXAction<T> action) throws Exception {
        InstanceProperties instanceProperties = this.deploymentManager.getInstanceProperties();
        String host = instanceProperties.getProperty("host");
        String port = instanceProperties.getProperty("port");
        if (host == null || host.trim().length() == 0 && (port == null || port.trim().length() == 0)) {
            if (!this.deploymentManager.isRemote()) {
                WebLogicConfiguration config = this.deploymentManager.getCommonConfiguration();
                host = config.getHost();
                port = Integer.toString(config.getPort());
            }
            if (host == null || host.trim().length() == 0 && (port == null || port.trim().length() == 0)) {
                String[] parts = this.deploymentManager.getUri().split(":");
                host = parts[3].substring(2);
                port = parts[4] != null ? parts[4].trim() : parts[4];
            }
        }
        final String resolvedHost = host.trim();
        final String resolvedPort = port.trim();
        return this.executeAction(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                boolean secured = WLConnectionSupport.this.deploymentManager.getCommonConfiguration().isSecured();
                JMXServiceURL url = new JMXServiceURL(secured ? "t3s" : "t3", resolvedHost, Integer.parseInt(resolvedPort), action.getPath());
                String username = WLConnectionSupport.this.deploymentManager.getInstanceProperties().getProperty("username");
                String password = WLConnectionSupport.this.deploymentManager.getInstanceProperties().getProperty("password");
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("jmx.remote.credentials", new String[]{username, password});
                JMXConnector jmxConnector = JMXConnectorFactory.newJMXConnector(url, env);
                jmxConnector.connect();
                try {
                    Object t = action.call(jmxConnector.getMBeanServerConnection());
                    return t;
                }
                finally {
                    jmxConnector.close();
                }
            }
        });
    }

    public static abstract class JMXEditAction<T>
    implements JMXAction<T> {
        public abstract T call(MBeanServerConnection var1, ObjectName var2) throws Exception;

        @Override
        public final T call(MBeanServerConnection connection) throws Exception {
            ObjectName service = new ObjectName("com.bea:Name=EditService,Type=weblogic.management.mbeanservers.edit.EditServiceMBean");
            return this.call(connection, service);
        }

        @Override
        public final String getPath() {
            return "/jndi/weblogic.management.mbeanservers.edit";
        }
    }

    public static abstract class JMXRuntimeAction<T>
    implements JMXAction<T> {
        public abstract T call(MBeanServerConnection var1, ObjectName var2) throws Exception;

        @Override
        public final T call(MBeanServerConnection connection) throws Exception {
            ObjectName service = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
            return this.call(connection, service);
        }

        @Override
        public final String getPath() {
            return "/jndi/weblogic.management.mbeanservers.domainruntime";
        }
    }

    public static interface JMXAction<T> {
        public T call(MBeanServerConnection var1) throws Exception;

        public String getPath();
    }
}

