/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.dd.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.weblogic9.dd.model.EjbJarModel;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BaseDescriptorModel {
    protected static final Version VERSION_10_3_1 = Version.fromJsr277NotationWithFallback((String)"10.3.1");
    protected static final Version VERSION_10_3_0 = Version.fromJsr277NotationWithFallback((String)"10.3.0");
    protected static final Version VERSION_12_1_1 = Version.fromJsr277NotationWithFallback((String)"12.1.1");
    protected static final Version VERSION_12_2_1 = Version.fromJsr277NotationWithFallback((String)"12.2.1");
    private final CommonDDBean bean;

    public BaseDescriptorModel(CommonDDBean bean) {
        this.bean = bean;
    }

    public final void write(OutputStream os) throws IOException {
        this.bean.write(os);
    }

    public final void write(final File file) throws ConfigurationException {
        try {
            FileObject cfolder = FileUtil.toFileObject((File)file.getParentFile());
            if (cfolder == null) {
                File parentFile = file.getParentFile();
                try {
                    cfolder = FileUtil.createFolder((File)parentFile);
                }
                catch (IOException ioe) {
                    String msg = NbBundle.getMessage(EjbJarModel.class, (String)"MSG_FailedToCreateConfigFolder", (Object)parentFile.getPath());
                    throw new ConfigurationException(msg, (Throwable)ioe);
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    String name = file.getName();
                    FileObject configFO = FileUtil.createData((FileObject)folder, (String)name);
                    FileLock lock = configFO.lock();
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        try {
                            if (BaseDescriptorModel.this.bean != null) {
                                BaseDescriptorModel.this.bean.write((OutputStream)os);
                            }
                        }
                        finally {
                            ((OutputStream)os).close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
            });
            FileUtil.refreshFor((File[])new File[]{file});
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(EjbJarModel.class, (String)"MSG_WriteToFileFailed", (Object)file.getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }
}

