/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.ErrorPage;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ErrorPagesTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ErrorPagesTablePanel
extends DefaultTablePanel {
    private static final Logger LOG = Logger.getLogger(ErrorPagesTablePanel.class.getName());
    private ErrorPagesTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;

    public ErrorPagesTablePanel(final DDDataObject dObj, final ErrorPagesTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.dObj = dObj;
        this.webApp = dObj.getWebApp();
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                dObj.modelUpdatedFromUI();
                dObj.setChangedFromUI(true);
                int row = ErrorPagesTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
                dObj.setChangedFromUI(false);
            }
        });
        this.addButton.addActionListener(new TableActionListener(true));
        this.editButton.addActionListener(new TableActionListener(false));
    }

    void setModel(WebApp webApp, ErrorPage[] pages) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])pages);
        this.webApp = webApp;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            final int row = this.add ? -1 : ErrorPagesTablePanel.this.getTable().getSelectedRow();
            String[] labels = new String[]{NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"LBL_errorPage"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"LBL_errorCode"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"LBL_exceptionType")};
            String[] a11y_desc = new String[]{NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_errorPage"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_errorCode"), NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_exceptionType")};
            SimpleDialogPanel.DialogDescriptor descriptor = new SimpleDialogPanel.DialogDescriptor(labels, true);
            if (!this.add) {
                Integer val = (Integer)ErrorPagesTablePanel.this.model.getValueAt(row, 1);
                String[] initValues = new String[]{(String)ErrorPagesTablePanel.this.model.getValueAt(row, 0), val == null ? "" : val.toString(), (String)ErrorPagesTablePanel.this.model.getValueAt(row, 2)};
                descriptor.setInitValues(initValues);
            }
            descriptor.setButtons(new boolean[]{true, false, false});
            descriptor.setA11yDesc(a11y_desc);
            final SimpleDialogPanel dialogPanel = new SimpleDialogPanel(descriptor);
            if (this.add) {
                dialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_add_err_page"));
                dialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_add_err_page"));
            } else {
                dialogPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_edit_err_page"));
                dialogPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"ACSD_edit_err_page"));
            }
            dialogPanel.getTextComponents()[0].setEditable(false);
            dialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = DDUtils.getDocBaseGroups(ErrorPagesTablePanel.this.dObj);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String res = DDUtils.getResourcePath(groups, fo, '/', true);
                            dialogPanel.getTextComponents()[0].setText("/" + res);
                        }
                    }
                    catch (IOException ex) {
                        LOG.log(Level.FINE, "ignored exception", ex);
                    }
                }
            });
            EditDialog dialog = new EditDialog((JPanel)dialogPanel, NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TTL_ErrorPage"), this.add){

                protected String validate() {
                    String[] values = dialogPanel.getValues();
                    String page = values[0].trim();
                    String code = values[1].trim();
                    String exc = values[2].trim();
                    if (page.length() == 0) {
                        return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EmptyErrorPageLocation");
                    }
                    if (code.length() == 0 && exc.length() == 0) {
                        return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EP_BothMissing");
                    }
                    if (code.length() > 0 && exc.length() > 0) {
                        return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EP_BothSpecified");
                    }
                    if (code.length() > 0) {
                        Integer c = null;
                        try {
                            c = new Integer(code);
                        }
                        catch (NumberFormatException ex) {
                            LOG.log(Level.FINE, "ignored exception", ex);
                        }
                        if (c == null) {
                            return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_EP_wrongNumber", (Object)code);
                        }
                        ErrorPage[] pages = ErrorPagesTablePanel.this.webApp.getErrorPage();
                        boolean exists = false;
                        for (int i = 0; i < pages.length; ++i) {
                            if (row == i || !c.equals(pages[i].getErrorCode())) continue;
                            exists = true;
                            break;
                        }
                        if (exists) {
                            return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_ErrorCodeExists", (Object)c);
                        }
                    } else {
                        ErrorPage[] pages = ErrorPagesTablePanel.this.webApp.getErrorPage();
                        boolean exists = false;
                        for (int i = 0; i < pages.length; ++i) {
                            if (row == i || !exc.equals(pages[i].getExceptionType())) continue;
                            exists = true;
                            break;
                        }
                        if (exists) {
                            return NbBundle.getMessage(ErrorPagesTablePanel.class, (String)"TXT_ExcTypeExists", (Object)exc);
                        }
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[2].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[2].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                ErrorPagesTablePanel.this.dObj.modelUpdatedFromUI();
                ErrorPagesTablePanel.this.dObj.setChangedFromUI(true);
                String[] values = dialogPanel.getValues();
                String page = values[0].trim();
                String code = values[1].trim();
                String exc = values[2].trim();
                if (this.add) {
                    ErrorPagesTablePanel.this.model.addRow(new Object[]{page, code.length() == 0 ? null : new Integer(code), exc.length() == 0 ? null : exc});
                } else {
                    ErrorPagesTablePanel.this.model.editRow(row, new Object[]{page, code.length() == 0 ? null : new Integer(code), exc.length() == 0 ? null : exc});
                }
                ErrorPagesTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

