/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.TokenStreamRecognitionException;
import org.netbeans.modules.cnd.apt.impl.structure.APTBaseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTDefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTElseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTEndifNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTErrorNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTFileNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfdefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIfndefNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNextNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTIncludeNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTNodeBuilder;
import org.netbeans.modules.cnd.apt.impl.structure.APTPragmaNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTStreamNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUndefineNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTUnknownNode;
import org.netbeans.modules.cnd.apt.impl.support.generated.APTLexer;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTPragma;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public final class APTBuilderImpl {
    private LinkedList<Pair> nodeStack = new LinkedList();

    public APTFile buildAPT(FileSystem fileSystem, CharSequence path, TokenStream ts) {
        if (ts == null) {
            return null;
        }
        APTFileNode aptFile = new APTFileNode(fileSystem, path);
        try {
            this.buildFileAPT(aptFile, ts);
        }
        catch (TokenStreamRecognitionException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on building APT\n {0}", new Object[]{ex});
        }
        catch (TokenStreamException ex) {
            APTUtils.LOG.log(Level.SEVERE, "error on converting token stream to text while building APT\n{0}", new Object[]{ex});
            APTUtils.LOG.log(Level.SEVERE, "problem file is {0}", new Object[]{path});
        }
        return aptFile;
    }

    public static APT buildAPTLight(APT apt) {
        assert (apt != null);
        assert (APTBuilderImpl.isRootNode(apt));
        APT outApt = APTBuilderImpl.createLightCopy(apt);
        APT node = APTBuilderImpl.nextRoot(apt);
        APT nodeLight = outApt;
        do {
            APT sibling;
            APT child;
            if ((child = APTBuilderImpl.nextRoot(node.getFirstChild())) != null) {
                APT childLight = APTBuilderImpl.buildAPTLight(child);
                assert (childLight != null);
                assert (APTBuilderImpl.isRootNode(childLight));
                nodeLight.setFirstChild(childLight);
            }
            node = sibling = APTBuilderImpl.nextRoot(node.getNextSibling());
            if (sibling == null) continue;
            APT siblingLight = APTBuilderImpl.createLightCopy(sibling);
            assert (siblingLight != null);
            assert (APTBuilderImpl.isRootNode(siblingLight));
            nodeLight.setNextSibling(siblingLight);
            nodeLight = siblingLight;
        } while (node != null);
        assert (outApt != null);
        assert (APTBuilderImpl.isRootNode(outApt));
        return outApt;
    }

    private void buildFileAPT(APTFileNode aptFile, TokenStream ts) throws TokenStreamException {
        GuardDetector guardDetector = new GuardDetector(aptFile, ts);
        APTToken lastToken = this.nonRecursiveBuild(aptFile, ts, guardDetector);
        aptFile.setGuard(guardDetector.getGuard());
        assert (APTUtils.isEOF(lastToken));
    }

    private APTToken nonRecursiveBuild(APTFileNode aptFile, TokenStream stream, GuardDetector guardDetector) throws TokenStreamException {
        assert (stream != null);
        Pair root = new Pair(aptFile);
        APTToken nextToken = (APTToken)stream.nextToken();
        while (!APTUtils.isEOF(nextToken)) {
            if (nextToken.getType() == 104 && this.nodeStack.size() == 1) {
                assert (this.nodeStack.getLast().active == aptFile) : " " + aptFile;
                guardDetector.onTopLevelEndif(nextToken.getType());
            }
            APTNodeBuilder builder = this.createNodeBuilder(nextToken);
            nextToken = this.initNode(aptFile, builder, (APTToken)stream.nextToken(), stream);
            APTBaseNode activeNode = builder.getNode();
            if (APTUtils.isEndConditionNode(activeNode.getType())) {
                if (!this.nodeStack.isEmpty()) {
                    root = this.nodeStack.removeLast();
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} without corresponding #if\n", new Object[]{APTTraceUtils.toFileString(aptFile), nextToken.getLine(), nextToken.getText()});
                }
            }
            root.addChild(activeNode);
            if (root.active == aptFile && activeNode.getType() != 12) {
                if (activeNode.getType() != 2) {
                    guardDetector.onTopLevelAPTNode(activeNode);
                } else if (guardDetector.attached) assert (APTUtils.toList(new APTCommentsFilter(((APTStreamNode)activeNode).getTokenStream())).isEmpty()) : "only comments are expected " + activeNode + " " + aptFile;
            }
            if (!APTUtils.isStartOrSwitchConditionNode(activeNode.getType())) continue;
            this.nodeStack.addLast(root);
            root = new Pair(activeNode);
        }
        for (Pair pair : this.nodeStack) {
            guardDetector.invalidate();
            APTToken token = pair.lastChild == null ? pair.active.getToken() : pair.lastChild.getToken();
            APTUtils.LOG.log(Level.SEVERE, "{0}, line {1}: {2} without closing #endif\n", new Object[]{APTTraceUtils.toFileString(aptFile), token == null ? -1 : token.getLine(), token == null ? Integer.valueOf(-1) : token.getText()});
        }
        return nextToken;
    }

    private APTToken initNode(APTFileNode aptFile, APTNodeBuilder builder, APTToken nextToken, TokenStream stream) throws TokenStreamException {
        while (!APTUtils.isEOF(nextToken) && builder.accept(aptFile, nextToken)) {
            nextToken = (APTToken)stream.nextToken();
        }
        if (APTUtils.isEndDirectiveToken(nextToken.getType())) {
            nextToken = (APTToken)stream.nextToken();
        }
        return nextToken;
    }

    private APTNodeBuilder createNodeBuilder(APTToken token) {
        assert (!APTUtils.isEOF(token));
        int ttype = token.getType();
        switch (ttype) {
            case 101: {
                return new APTIfNode(token);
            }
            case 99: {
                return new APTIfdefNode(token);
            }
            case 100: {
                return new APTIfndefNode(token);
            }
            case 95: {
                return new APTIncludeNode(token);
            }
            case 96: {
                return new APTIncludeNextNode(token);
            }
            case 102: {
                return new APTElifNode(token);
            }
            case 103: {
                return new APTElseNode(token);
            }
            case 104: {
                return new APTEndifNode(token);
            }
            case 97: {
                return new APTDefineNode.Builder(token);
            }
            case 98: {
                return new APTUndefineNode(token);
            }
            case 107: {
                return new APTErrorNode(token);
            }
            case 105: {
                return new APTPragmaNode(token);
            }
            case 106: 
            case 108: {
                return new APTUnknownNode(token);
            }
        }
        assert (!APTUtils.isPreprocessorToken(ttype)) : "all preprocessor tokens should be handled above";
        return new APTStreamNode(token);
    }

    @SuppressWarnings(value={"BC"})
    public static APT createLightCopy(APT apt) {
        assert (apt != null);
        assert (APTBuilderImpl.isRootNode(apt));
        APTBaseNode light = null;
        switch (apt.getType()) {
            case 2: {
                break;
            }
            case 5: {
                light = new APTDefineNode((APTDefineNode)apt);
                break;
            }
            case 6: {
                light = new APTUndefineNode((APTUndefineNode)apt);
                break;
            }
            case 7: {
                light = new APTIfdefNode((APTIfdefNode)apt);
                break;
            }
            case 8: {
                light = new APTIfndefNode((APTIfndefNode)apt);
                break;
            }
            case 9: {
                light = new APTIfNode((APTIfNode)apt);
                break;
            }
            case 10: {
                light = new APTElifNode((APTElifNode)apt);
                break;
            }
            case 11: {
                light = new APTElseNode((APTElseNode)apt);
                break;
            }
            case 12: {
                light = new APTEndifNode((APTEndifNode)apt);
                break;
            }
            case 3: {
                light = new APTIncludeNode((APTIncludeNode)apt);
                break;
            }
            case 4: {
                light = new APTIncludeNextNode((APTIncludeNextNode)apt);
                break;
            }
            case 15: {
                light = new APTErrorNode((APTErrorNode)apt);
                break;
            }
            case 13: {
                light = new APTPragmaNode((APTPragmaNode)apt);
                break;
            }
            case 1: {
                light = new APTFileNode((APTFileNode)apt);
                break;
            }
        }
        return light;
    }

    private static boolean isRootNode(APT apt) {
        switch (apt.getType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static APT nextRoot(APT apt) {
        for (APT node = apt; node != null; node = node.getNextSibling()) {
            if (!APTBuilderImpl.isRootNode(node)) continue;
            return node;
        }
        return null;
    }

    private static final class GuardDetector
    implements APTLexer.APTLexerCallback {
        private State state;
        private final APTFile aptFile;
        private CharSequence guard = CharSequences.empty();
        private final APTLexer plainLexer;
        private boolean attached;

        public GuardDetector(APTFile aptFile, TokenStream ts) {
            this.aptFile = aptFile;
            this.plainLexer = this.findLexer(ts);
            this.state = State.INITIAL;
            this.attachLexerCallback();
        }

        private APTLexer findLexer(TokenStream ts) {
            if (ts instanceof APTLexer) {
                return (APTLexer)ts;
            }
            return null;
        }

        public void invalidate() {
            this.state = State.INVALID;
            this.detachLexerCallback();
        }

        public CharSequence getGuard() {
            switch (this.state) {
                case AFTER_GUARD_ENDIF: {
                    return this.guard;
                }
                case PRAGMA_ONCE_DETECTED: {
                    return CharSequences.create((CharSequence)APTUtils.getFileOnceMacroName(this.aptFile));
                }
            }
            return CharSequences.empty();
        }

        @Override
        public void onMakeToken(int tokType, int startColumn, int startLine) {
            switch (tokType) {
                case 1: 
                case 488: 
                case 495: 
                case 496: {
                    return;
                }
            }
            switch (this.state) {
                case INITIAL: {
                    if (APTUtils.isPreprocessorToken(tokType)) {
                        this.state = State.FIRST_TOP_LEVEL_NODE;
                        this.detachLexerCallback();
                        break;
                    }
                    APTUtils.LOG.log(Level.FINE, "{0}:{1} non comment token {2} before guard block\n", new Object[]{APTTraceUtils.toFileString(this.aptFile), startLine, APTUtils.getAPTTokenName(tokType)});
                    this.invalidate();
                    break;
                }
                case IN_GUARD_ENDIF: {
                    if (!APTUtils.isEndDirectiveToken(tokType)) break;
                    this.state = State.AFTER_GUARD_ENDIF;
                    break;
                }
                case AFTER_GUARD_ENDIF: {
                    APTUtils.LOG.log(Level.FINE, "{0}:{1} non comment token {2} after guard #endif\n", new Object[]{APTTraceUtils.toFileString(this.aptFile), startLine, APTUtils.getAPTTokenName(tokType)});
                    this.invalidate();
                    break;
                }
                default: {
                    assert (false) : "unexpected state " + (Object)((Object)this.state) + " " + this.aptFile;
                    this.invalidate();
                }
            }
        }

        void onTopLevelEndif(int type) {
            assert (!this.attached || this.state == State.IFNDEF_GUARD_DETECTED) : "can not be attached in state " + (Object)((Object)this.state) + " " + this.aptFile;
            switch (this.state) {
                case INVALID: {
                    return;
                }
                case PRAGMA_ONCE_DETECTED: {
                    return;
                }
                case IFNDEF_GUARD_DETECTED: {
                    assert (type == 104) : " " + this.aptFile;
                    this.state = State.IN_GUARD_ENDIF;
                    this.attachLexerCallback();
                    break;
                }
                default: {
                    assert (false) : "we can not be here " + (Object)((Object)this.state) + " " + this.aptFile;
                    this.invalidate();
                }
            }
        }

        @SuppressWarnings(value={"BC"})
        public void onTopLevelAPTNode(APT apt) {
            assert (!this.attached) : "can not be attached in state " + (Object)((Object)this.state) + " " + this.aptFile;
            switch (this.state) {
                case INVALID: {
                    return;
                }
                case PRAGMA_ONCE_DETECTED: {
                    return;
                }
                case FIRST_TOP_LEVEL_NODE: {
                    switch (apt.getType()) {
                        case 13: {
                            APTPragma pragma = (APTPragma)apt;
                            APTToken name = pragma.getName();
                            if (name == null || !"once".contentEquals(name.getTextID())) break;
                            this.state = State.PRAGMA_ONCE_DETECTED;
                            break;
                        }
                        case 8: {
                            APTIfndefNode ifndef = (APTIfndefNode)apt;
                            APTToken macroName = ifndef.getMacroName();
                            if (macroName == null) break;
                            this.guard = macroName.getTextID();
                            this.state = State.IFNDEF_GUARD_DETECTED;
                            break;
                        }
                        case 9: {
                            APTIfNode iff = (APTIfNode)apt;
                            List<APTToken> condition = APTUtils.toList(new APTCommentsFilter(iff.getCondition()));
                            if (condition.size() == 3) {
                                if (condition.get(0).getType() != 41 || condition.get(1).getType() != 56 || condition.get(2).getType() != 514) break;
                                this.guard = condition.get(2).getTextID();
                                this.state = State.IFNDEF_GUARD_DETECTED;
                                break;
                            }
                            if (condition.size() != 5 || condition.get(0).getType() != 41 || condition.get(1).getType() != 56 || condition.get(2).getType() != 12 || condition.get(3).getType() != 514 || condition.get(4).getType() != 13) break;
                            this.guard = condition.get(3).getTextID();
                            this.state = State.IFNDEF_GUARD_DETECTED;
                            break;
                        }
                    }
                    if (this.state == State.IFNDEF_GUARD_DETECTED || this.state == State.PRAGMA_ONCE_DETECTED) break;
                    APTUtils.LOG.log(Level.FINE, "{0}: no guard due to {1}\n", new Object[]{APTTraceUtils.toFileString(this.aptFile), apt});
                    this.invalidate();
                    break;
                }
                case AFTER_GUARD_ENDIF: 
                case IFNDEF_GUARD_DETECTED: {
                    APTUtils.LOG.log(Level.FINE, "{0}: no #endif is not guard protection due to {1}\n", new Object[]{APTTraceUtils.toFileString(this.aptFile), apt});
                    this.invalidate();
                    break;
                }
                default: {
                    assert (false) : "error " + this.aptFile + " in state " + (Object)((Object)this.state) + " with " + apt;
                    this.invalidate();
                }
            }
        }

        private void detachLexerCallback() {
            this.attached = false;
            if (this.plainLexer != null) {
                this.plainLexer.setCallback(null);
            }
        }

        private void attachLexerCallback() {
            if (this.plainLexer != null) {
                this.plainLexer.setCallback(this);
                this.attached = true;
            } else {
                this.attached = false;
            }
        }

        private static enum State {
            INITIAL,
            FIRST_TOP_LEVEL_NODE,
            PRAGMA_ONCE_DETECTED,
            IFNDEF_GUARD_DETECTED,
            IN_GUARD_ENDIF,
            AFTER_GUARD_ENDIF,
            INVALID;

        }
    }

    private static final class Pair {
        final APTBaseNode active;
        APTBaseNode lastChild;

        Pair(APTBaseNode activeNode) {
            this.active = activeNode;
        }

        void addChild(APTBaseNode newChild) {
            if (this.lastChild == null) {
                this.active.setFirstChild(newChild);
            } else {
                this.lastChild.setNextSibling(newChild);
            }
            this.lastChild = newChild;
        }

        public String toString() {
            return "active:" + this.active + " lastChild:" + this.lastChild;
        }
    }
}

