/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.clank;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.directory_iterator;
import org.clang.tools.services.support.ClangUtilities;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankFileSystemProviderImpl;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankMemoryBufferImpl;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.spi.APTBufferProvider;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ClankFileObjectBasedFileSystem
extends FileSystem {
    private static final boolean TRACE_TIME = Boolean.getBoolean("clank.fs.trace.time");
    private static final AtomicLong totalReadTime = TRACE_TIME ? new AtomicLong() : null;
    private static final AtomicLong totalReadCount = TRACE_TIME ? new AtomicLong() : null;
    private static final AtomicLong totalStatTime = TRACE_TIME ? new AtomicLong() : null;
    private static final AtomicLong totalStatCount = TRACE_TIME ? new AtomicLong() : null;
    private static final org.openide.filesystems.FileSystem LOCAL_FS = CndFileUtils.getLocalFileSystem();
    private final APTBufferProvider bufferProvider;
    private final SmallString BufString = new SmallString(512);
    private final StringRef BufRef = new StringRef();
    private final StringBuilder BufBuilder = new StringBuilder();

    public static ClankFileObjectBasedFileSystem getInstance() {
        return new ClankFileObjectBasedFileSystem();
    }

    private ClankFileObjectBasedFileSystem() {
        if (APTTraceFlags.ALWAYS_USE_BUFFER_BASED_FILES) {
            this.bufferProvider = (APTBufferProvider)Lookup.getDefault().lookup(APTBufferProvider.class);
            if (this.bufferProvider == null) {
                Exceptions.printStackTrace((Throwable)new IllegalStateException("No providers found for " + APTBufferProvider.class.getName()));
            }
        } else {
            this.bufferProvider = null;
        }
    }

    private static void printStatistics(std.string Name, long readTime) {
        assert (TRACE_TIME);
        StringBuilder sb = new StringBuilder();
        sb.append("Reading ").append(Name).append(" took ").append(readTime).append(" ms").append("\nTotal reads: count=").append(totalReadCount.get()).append(" time=").append(totalReadTime.get()).append(" ms").append("\nTotal stats: count=").append(totalStatCount.get()).append(" time=").append(totalStatTime.get()).append(" ms").append("\n");
        llvm.errs().$out(sb.toString());
    }

    public void destroy() {
    }

    public ErrorOr<Status> status(Twine Path) {
        long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
        FileObject fo = this.getFileObject(Path);
        ErrorOr<Status> status = this.getStatus(fo);
        if (TRACE_TIME) {
            totalStatTime.addAndGet(System.currentTimeMillis() - time);
            totalStatCount.incrementAndGet();
        }
        return status;
    }

    public ErrorOr<std_ptr.unique_ptr<File>> openFileForRead(Twine Path) {
        ErrorOr result;
        long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
        FileObject fo = this.getFileObject(Path);
        if (fo == null || !fo.isValid()) {
            result = new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.no_such_file_or_directory);
        } else if (this.bufferProvider == null) {
            ClankFileObjectBasedFile file = new ClankFileObjectBasedFile(fo);
            result = new ErrorOr((Object)new std_ptr.unique_ptr((Object)file));
        } else {
            APTFileBuffer buffer = this.bufferProvider.getOrCreateFileBuffer(fo);
            if (buffer == null) {
                result = new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.no_such_file_or_directory);
            } else {
                ClankAPTFileBufferBasedFile file = new ClankAPTFileBufferBasedFile(fo, buffer);
                result = new ErrorOr((Object)new std_ptr.unique_ptr((Object)file));
            }
        }
        if (TRACE_TIME) {
            totalReadTime.addAndGet(System.currentTimeMillis() - time);
            totalReadCount.incrementAndGet();
        }
        return result;
    }

    public directory_iterator dir_begin(Twine Dir, std_errors.error_code EC) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private CharSequence toCharSequence(Twine twine) {
        this.BufString.clear();
        this.BufBuilder.setLength(0);
        StringRef StrRef = twine.toStringRef(this.BufString, this.BufRef);
        int Len = StrRef.size();
        if (this.BufString.size() > 0) {
            assert (Len == this.BufString.size());
            this.BufString.toStringBuilder(this.BufBuilder);
        } else {
            char.ptr data = StrRef.data();
            Casts.toStringBuilder((StringBuilder)this.BufBuilder, (char.ptr)data, (int)Len);
        }
        return this.BufBuilder;
    }

    private fs.UniqueID getUniqueID(FileObject fo) {
        CndFileSystemProvider.CndStatInfo stat = CndFileSystemProvider.getStatInfo((FileObject)fo);
        if (stat.isValid()) {
            return new fs.UniqueID(stat.device, stat.inode);
        }
        return null;
    }

    private FileObject getFileObject(Twine Path) {
        org.openide.filesystems.FileSystem fs2;
        String path;
        String url = this.toCharSequence(Path).toString();
        if (CharSequenceUtils.startsWith((CharSequence)url, (CharSequence)"rfs:")) {
            path = ClankFileSystemProviderImpl.getPathFromUrl(url);
            fs2 = CndFileSystemProvider.urlToFileSystem((CharSequence)url);
        } else {
            path = url;
            fs2 = LOCAL_FS;
        }
        if (fs2 != null && CndFileUtils.exists((org.openide.filesystems.FileSystem)fs2, (String)(path = CndFileUtils.normalizeAbsolutePath((org.openide.filesystems.FileSystem)fs2, (String)path)))) {
            return CndFileUtils.toFileObject((org.openide.filesystems.FileSystem)fs2, (CharSequence)path);
        }
        return null;
    }

    private ErrorOr<Status> getStatus(ClankFileObjectBasedFile file) {
        long time = TRACE_TIME ? System.currentTimeMillis() : 0L;
        ErrorOr<Status> result = this.getStatus(file.getFileObject());
        if (TRACE_TIME) {
            totalStatTime.addAndGet(System.currentTimeMillis() - time);
            totalStatCount.incrementAndGet();
        }
        return result;
    }

    private ErrorOr<Status> getStatus(FileObject fo) {
        if (fo == null || !fo.isValid()) {
            return new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.no_such_file_or_directory);
        }
        StringRef name = ClangUtilities.createPathStringRef((CharSequence)CndFileSystemProvider.toUrl((FSPath)FSPath.toFSPath((FileObject)fo)));
        fs.UniqueID uid = this.getUniqueID(fo);
        if (uid == null) {
            return new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.io_error);
        }
        long ms = fo.lastModified().getTime();
        TimeValue time = new TimeValue(ms / 1000L, (int)(ms % 1000L) * 1000000);
        int user = 0;
        int group = 0;
        int permissions = 511;
        fs.file_type type = fo.isFolder() ? fs.file_type.directory_file : (fo.isData() ? fs.file_type.regular_file : fs.file_type.type_unknown);
        Status st = new Status(name, uid, time, user, group, fo.getSize(), type, permissions);
        return new ErrorOr((Object)st);
    }

    public std_errors.error_code setCurrentWorkingDirectory(Twine Path) {
        throw new UnsupportedOperationException();
    }

    public ErrorOr<std.string> getCurrentWorkingDirectory() {
        throw new UnsupportedOperationException();
    }

    private final class ClankAPTFileBufferBasedFile
    extends ClankFileObjectBasedFile {
        private final APTFileBuffer buffer;

        public ClankAPTFileBufferBasedFile(FileObject fo, APTFileBuffer buffer) {
            super(fo);
            this.buffer = buffer;
        }

        @Override
        protected ClankMemoryBufferImpl createMemoryBufferImpl() throws IOException {
            return ClankMemoryBufferImpl.create(this.getURL(), this.buffer.getCharBuffer());
        }
    }

    private class ClankFileObjectBasedFile
    extends File {
        private final FileObject fo;
        private final CharSequence foURL;

        public ClankFileObjectBasedFile(FileObject fo) {
            this.fo = fo;
            this.foURL = CndFileSystemProvider.toUrl((FSPath)FSPath.toFSPath((FileObject)fo));
        }

        FileObject getFileObject() {
            return this.fo;
        }

        CharSequence getURL() {
            return this.foURL;
        }

        public ErrorOr<Status> status() {
            return ClankFileObjectBasedFileSystem.this.getStatus(this);
        }

        protected ClankMemoryBufferImpl createMemoryBufferImpl() throws IOException {
            return ClankMemoryBufferImpl.create(this.fo, this.getURL());
        }

        public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize, boolean RequiresNullTerminator, boolean IsVolatile) {
            ErrorOr buf;
            String pathAsUrl;
            long time;
            long l = time = TRACE_TIME ? System.currentTimeMillis() : 0L;
            if (CndUtils.isDebugMode() && !(pathAsUrl = Name.str().toJavaString()).contentEquals(this.foURL)) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Unexpected Name parameter: '" + pathAsUrl + " expected own " + pathAsUrl + " for wrapped " + this.fo));
            }
            try {
                ClankMemoryBufferImpl mb = this.createMemoryBufferImpl();
                std_ptr.unique_ptr p = new std_ptr.unique_ptr((Object)mb);
                buf = new ErrorOr((Object)p);
            }
            catch (FileNotFoundException ex) {
                buf = new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.no_such_file_or_directory);
            }
            catch (IOException ex) {
                buf = new ErrorOr((std_errors.ErrorCodeEnumerator)std_errors.errc.io_error);
            }
            if (TRACE_TIME) {
                time = System.currentTimeMillis() - time;
                totalReadCount.incrementAndGet();
                totalReadTime.addAndGet(time);
                ClankFileObjectBasedFileSystem.printStatistics(Name.str(), time);
            }
            return buf;
        }

        public std_errors.error_code close() {
            return std_errors.error_code.success();
        }
    }
}

