/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.project.ui.customizer.SourceRootsUi;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerSources
extends JPanel
implements HelpCtx.Provider,
ActionListener {
    private String originalEncoding;
    private boolean notified;
    private final JCProjectProperties uiProperties;
    private final SourceRootsUi.EditMediator emSR;
    private JButton addSourceRoot;
    private JButton downSourceRoot;
    private JComboBox encoding;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField projectLocation;
    private JButton removeSourceRoot;
    private JComboBox sourceLevel;
    private JTable sourceRoots;
    private JPanel sourceRootsPanel;
    private JButton upSourceRoot;

    public CustomizerSources(JCProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        GuiUtils.prepareContainer((Container)this);
        this.jScrollPane1.getViewport().setBackground(this.sourceRoots.getBackground());
        this.sourceRoots.setModel(uiProperties.SOURCE_ROOTS_MODEL);
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        FileObject projectFolder = uiProperties.getProject().getProjectDirectory();
        File pf = FileUtil.toFile((FileObject)projectFolder);
        this.projectLocation.setText(pf == null ? "" : pf.getPath());
        this.emSR = SourceRootsUi.registerEditMediator((Project)uiProperties.getProject(), (SourceRoots)uiProperties.getProject().getRoots(), (JTable)this.sourceRoots, (JButton)this.addSourceRoot, (JButton)this.removeSourceRoot, (JButton)this.upSourceRoot, (JButton)this.downSourceRoot, (CellEditor)new LabelCellEditor(this.sourceRoots), (boolean)false);
        this.sourceLevel.setEditable(false);
        this.enableSourceLevel();
        this.originalEncoding = this.uiProperties.getProject().evaluator().getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(new EncodingModel(this.originalEncoding));
        this.encoding.setRenderer(new EncodingRenderer());
        String lafid = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(lafid)) {
            this.encoding.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encoding.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    combo.setPopupVisible(false);
                }
            });
        }
        this.encoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomizerSources.this.handleEncodingChange();
            }
        });
        this.initTableVisualProperties(this.sourceRoots);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.SourcesPanel");
        this.addSourceRoot.removeActionListener((ActionListener)this.emSR);
    }

    private void initTableVisualProperties(JTable table) {
        table.setSelectionMode(2);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        double pw = table.getParent().getParent().getPreferredSize().getWidth();
        table.setAutoResizeMode(0);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMinWidth(226);
        column.setWidth((int)pw / 2 - 1);
        column.setPreferredWidth((int)pw / 2 - 1);
        column.setMinWidth(75);
        column = table.getColumnModel().getColumn(1);
        column.setMinWidth(226);
        column.setWidth((int)pw / 2 - 1);
        column.setPreferredWidth((int)pw / 2 - 1);
        column.setMinWidth(75);
        this.addComponentListener(new TableColumnSizeComponentAdapter(table));
    }

    private void handleEncodingChange() {
        Charset enc = (Charset)this.encoding.getSelectedItem();
        String encName = enc != null ? enc.name() : this.originalEncoding;
        if (!this.notified && encName != null && !encName.equals(this.originalEncoding)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"MSG_EncodingWarning"), 2));
            this.notified = true;
        }
        this.uiProperties.setSourceEncoding(encName);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerSources.class);
    }

    private void enableSourceLevel() {
        this.sourceLevel.setEnabled(this.sourceLevel.getItemCount() > 0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectLocation = new JTextField();
        this.sourceRootsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sourceRoots = new ResizableRowHeightTable();
        this.addSourceRoot = new JButton();
        this.removeSourceRoot = new JButton();
        this.upSourceRoot = new JButton();
        this.downSourceRoot = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.sourceLevel = this.uiProperties.createSourceLevelComboBox();
        this.jLabel5 = new JLabel();
        this.encoding = new JComboBox();
        this.jPanel2 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectLocation);
        this.jLabel1.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_ProjectFolder"));
        this.add((Component)this.jLabel1, new GridBagConstraints());
        this.projectLocation.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.projectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_projectLocation"));
        this.sourceRootsPanel.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.sourceRoots);
        this.jLabel2.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_SourceRoots"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.sourceRootsPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(450, 150));
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.sourceRoots);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.sourceRootsPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_AddSourceRoot"));
        this.addSourceRoot.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.sourceRootsPanel.add((Component)this.addSourceRoot, gridBagConstraints);
        this.removeSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_RemoveSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.sourceRootsPanel.add((Component)this.removeSourceRoot, gridBagConstraints);
        this.upSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_UpSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.sourceRootsPanel.add((Component)this.upSourceRoot, gridBagConstraints);
        this.downSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_DownSourceRoot"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.sourceRootsPanel.add((Component)this.downSourceRoot, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.sourceRootsPanel, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.sourceLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(CustomizerSources.class, (String)"TXT_SourceLevel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.sourceLevel.setMinimumSize(this.sourceLevel.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sourceLevel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CustomizerSources.class, (String)"TXT_Encoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 12);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.encoding.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel1.add((Component)this.encoding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addSourceRoot) {
            this.addSourceRootActionPerformed(evt);
        }
    }

    private void addSourceRootActionPerformed(ActionEvent evt) {
        ActionEvent ae = new ActionEvent(this.addSourceRoot, evt.getID(), evt.getActionCommand());
        Set<File> currRoots = this.currSourceRoots();
        this.emSR.actionPerformed(ae);
        Set<File> newRoots = this.currSourceRoots();
        newRoots.removeAll(currRoots);
        FileObject projectRoot = this.uiProperties.getProject().getProjectDirectory();
        HashSet<File> badRoots = new HashSet<File>();
        for (File file : newRoots) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (FileUtil.isParentOf((FileObject)projectRoot, (FileObject)fileObject)) continue;
            badRoots.add(file);
        }
        if (!badRoots.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (File file : badRoots) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(file.getName());
                this.removeSourceRoot(file);
            }
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"ERR_BAD_ROOT", (Object)sb));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private void removeSourceRoot(File f) {
        DefaultTableModel mdl = (DefaultTableModel)this.sourceRoots.getModel();
        int max = mdl.getRowCount();
        for (int i = max - 1; i >= 0; --i) {
            if (!f.equals(mdl.getValueAt(i, 0))) continue;
            mdl.removeRow(i);
        }
    }

    private Set<File> currSourceRoots() {
        HashSet<File> result = new HashSet<File>();
        int max = this.sourceRoots.getModel().getRowCount();
        for (int i = 0; i < max; ++i) {
            File f = (File)this.sourceRoots.getModel().getValueAt(i, 0);
            result.add(f);
        }
        return result;
    }

    private static class LabelCellEditor
    extends DefaultCellEditor {
        private JTable sourceRoots;

        public LabelCellEditor(JTable sourceRoots) {
            super(new JTextField());
            this.sourceRoots = sourceRoots;
        }

        @Override
        public boolean stopCellEditing() {
            String value;
            int rowIndex;
            JTextField field = (JTextField)this.getComponent();
            String text = field.getText();
            boolean validCell = true;
            TableModel model = this.sourceRoots.getModel();
            int rowCount = model.getRowCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                value = (String)model.getValueAt(rowIndex, 1);
                if (!text.equals(value)) continue;
                validCell = false;
            }
            rowCount = model.getRowCount();
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                value = (String)model.getValueAt(rowIndex, 1);
                if (!text.equals(value)) continue;
                validCell = false;
            }
            return !validCell ? validCell : super.stopCellEditing();
        }
    }

    private static class ResizableRowHeightTable
    extends JTable {
        private boolean needResize = true;

        private ResizableRowHeightTable() {
        }

        @Override
        public void setFont(Font font) {
            this.needResize = true;
            super.setFont(font);
        }

        @Override
        public void paint(Graphics g) {
            if (this.needResize) {
                this.setRowHeight(g.getFontMetrics(this.getFont()).getHeight());
                this.needResize = false;
            }
            super.paint(g);
        }
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String name) {
            super(name, new String[0]);
        }

        @Override
        public boolean contains(Charset c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel(String originalEncoding) {
            Charset defEnc = null;
            for (Charset c : Charset.availableCharsets().values()) {
                if (c.name().equals(originalEncoding)) {
                    defEnc = c;
                }
                this.addElement(c);
            }
            if (defEnc == null) {
                try {
                    defEnc = new UnknownCharset(originalEncoding);
                    this.addElement(defEnc);
                }
                catch (IllegalCharsetNameException e) {
                    Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + originalEncoding);
                }
            }
            if (defEnc == null) {
                defEnc = Charset.defaultCharset();
            }
            this.setSelectedItem(defEnc);
        }
    }

    private static class EncodingRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            assert (value instanceof Charset);
            this.setName("ComboBox.listRenderer");
            this.setText(((Charset)value).displayName());
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class TableColumnSizeComponentAdapter
    extends ComponentAdapter {
        private JTable table = null;

        public TableColumnSizeComponentAdapter(JTable table) {
            this.table = table;
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            double pw = this.table.getParent().getParent().getSize().getWidth();
            this.table.setAutoResizeMode(0);
            TableColumn column = this.table.getColumnModel().getColumn(0);
            column.setWidth((int)pw / 2 - 1);
            column.setPreferredWidth((int)pw / 2 - 1);
            column = this.table.getColumnModel().getColumn(1);
            column.setWidth((int)pw / 2 - 1);
            column.setPreferredWidth((int)pw / 2 - 1);
        }
    }
}

