/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.wizard;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.projecttemplates.FileCreator;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class ProjectXmlCreator
extends FileCreator {
    private final String projectName;
    private final StringBuilder sb = new StringBuilder();
    private ProjectKind kind;

    public ProjectXmlCreator(String projectName, ProjectKind kind) {
        super("nbproject", "project.xml", false);
        this.projectName = projectName;
        this.kind = kind;
    }

    public DataObject create(FileObject project, Map<String, String> params) throws IOException {
        return DataObject.find((FileObject)this.create(project));
    }

    public FileObject create(final FileObject project) throws IOException {
        try {
            return (FileObject)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<FileObject>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public FileObject run() throws Exception {
                    ProjectXmlCreator.this.sb.setLength(0);
                    ProjectXmlCreator.this.sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    ProjectXmlCreator.this.sb.append("<project xmlns=\"http://www.netbeans.org/ns/project/1\">\n");
                    ProjectXmlCreator.this.write(1, "<type>org.netbeans.modules.javacard.JCPROJECT</type>");
                    ProjectXmlCreator.this.write(1, "<configuration>");
                    ProjectXmlCreator.this.write(2, "<data xmlns=\"http://www.netbeans.org/ns/javacard-project/3\">");
                    ProjectXmlCreator.this.write(2, "<!-- Do not use Project Properties customizer when editing this file manually. -->");
                    ProjectXmlCreator.this.write(3, "<name>" + ProjectXmlCreator.this.projectName + "</name>");
                    ProjectXmlCreator.this.write(3, "<properties>");
                    ProjectXmlCreator.this.write(4, "<property name=\"javacard.project.subtype\">" + ProjectXmlCreator.this.kind + "</property>");
                    ProjectXmlCreator.this.write(3, "</properties>");
                    ProjectXmlCreator.this.write(3, "<source-roots>");
                    ProjectXmlCreator.this.write(4, "<root id=\"src.dir\"/>");
                    ProjectXmlCreator.this.write(3, "</source-roots>");
                    ProjectXmlCreator.this.write(3, "<dependencies>");
                    ProjectXmlCreator.this.write(3, "</dependencies>");
                    ProjectXmlCreator.this.write(2, "</data>");
                    ProjectXmlCreator.this.write(1, "</configuration>");
                    ProjectXmlCreator.this.write(0, "</project>");
                    FileObject projectXml = FileUtil.createData((FileObject)project, (String)"nbproject/project.xml");
                    FileLock lock = projectXml.lock();
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(projectXml.getOutputStream(lock));
                        PrintWriter writer = null;
                        try {
                            writer = new PrintWriter(out);
                            writer.println(ProjectXmlCreator.this.sb.toString());
                        }
                        finally {
                            if (writer != null) {
                                writer.flush();
                                writer.close();
                            }
                            ((OutputStream)out).close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                    return projectXml;
                }
            });
        }
        catch (MutexException me) {
            if (me.getException() instanceof IOException) {
                throw (IOException)me.getException();
            }
            throw new IOException(me);
        }
    }

    void write(int indent, String toWrite) {
        char[] c = new char[indent * 4];
        Arrays.fill(c, ' ');
        this.sb.append(c);
        this.sb.append(toWrite);
        this.sb.append('\n');
    }
}

