/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.team.commons.treelist.ListNode;

public final class ListRendererPanel
extends JPanel {
    private final ListNode node;

    public ListRendererPanel(ListNode node) {
        super(new BorderLayout());
        this.node = node;
        this.setOpaque(true);
    }

    public void configure(Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowHeight, int rowWidth) {
        this.removeAll();
        int maxWidth = rowWidth - 5 - 5;
        JComponent inner = this.node.getComponent(foreground, background, isSelected, hasFocus, maxWidth > 0 ? maxWidth : 0);
        this.add((Component)inner, "Center");
        this.setBackground(background);
        this.setForeground(foreground);
        Border border = null;
        if (hasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        }
        border = null != border ? BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5)) : BorderFactory.createEmptyBorder(5, 5, 5, 5);
        try {
            this.setBorder(border);
        }
        catch (NullPointerException npe) {
            Logger.getLogger(ListRendererPanel.class.getName()).log(Level.INFO, "Bug #175940", npe);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        JComponent jc;
        String tooltip;
        Component c = SwingUtilities.getDeepestComponentAt(this, event.getX(), event.getY());
        if (c instanceof JComponent && null != (tooltip = (jc = (JComponent)c).getToolTipText())) {
            return tooltip;
        }
        return super.getToolTipText(event);
    }
}

