/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.OpenSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableOpenSupportRedirector;

public class COSRedirectorImpl
extends CloneableOpenSupportRedirector {
    private static final Logger LOG = Logger.getLogger(COSRedirectorImpl.class.getName());
    private static final boolean ENABLED;
    private static final boolean ENABLED_REMOTE;
    private static final int L1_CACHE_SIZE = 10;
    private static final FileKey INVALID_INODE;
    private static final Method getDataObjectMethod;
    private final Map<FileKey, Storage> imap = new HashMap<FileKey, Storage>();
    private final LinkedList<FileKey> cache = new LinkedList();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloneableOpenSupport redirect(CloneableOpenSupport.Env env) {
        CloneableOpenSupport aCes;
        DataObject dobj = this.getDataObjectIfApplicable(env);
        if (dobj == null) {
            return null;
        }
        Lookup dobjLookup = dobj.getLookup();
        if (dobjLookup == null) {
            return null;
        }
        CloneableOpenSupport cos = env.findCloneableOpenSupport();
        Storage storage = this.getCachedStorage(dobj);
        if (storage != null && (aCes = storage.getCloneableOpenSupport(dobj, cos)) != null) {
            if (cos != aCes && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Use {0}:\n\t{1}\n for {2}", new Object[]{storage.cosPath, aCes, dobj.getPrimaryFile().getPath()});
            }
            return aCes;
        }
        FileKey inode = COSRedirectorImpl.getINode(dobj);
        if (inode == INVALID_INODE) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            this.cache.remove(inode);
            this.cache.addFirst(inode);
            if (this.cache.size() > 10) {
                this.cache.removeLast();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        storage = this.findOrCreateINodeList(inode);
        if (storage.addDataObject(inode, dobj, cos)) {
            return null;
        }
        CloneableOpenSupport aCes2 = storage.getCloneableOpenSupport(dobj, cos);
        if (cos != aCes2 && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Use {0}:\n\t{1}\n for {2}", new Object[]{storage.cosPath, aCes2, dobj.getPrimaryFile().getPath()});
        }
        return aCes2;
    }

    private Storage findOrCreateINodeList(FileKey inode) {
        Storage list;
        assert (inode != INVALID_INODE);
        this.lock.writeLock().lock();
        try {
            list = this.imap.get(inode);
            if (list == null) {
                list = new Storage();
                this.imap.put(inode, list);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return list;
    }

    protected void opened(CloneableOpenSupport.Env env) {
        this.redirect(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closed(CloneableOpenSupport.Env env) {
        DataObject dobj = this.getDataObjectIfApplicable(env);
        if (dobj == null) {
            return;
        }
        Storage storage = this.getCachedStorage(dobj);
        FileKey inode = INVALID_INODE;
        if (storage == null) {
            inode = COSRedirectorImpl.getINode(dobj);
        }
        this.lock.writeLock().lock();
        try {
            if (storage == null && (storage = this.imap.get(inode)) == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "clear not existing for inode={0}:dobj={1}\nimap.get={2} cache.contains={3} cache.size={4}, imap.size={5}\n", new Object[]{inode, dobj, this.imap.get(inode), this.cache.contains(inode), this.cache.size(), this.imap.size()});
                }
                return;
            }
            storage.clear();
            this.cache.remove(inode);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "clear for inode={0}:dobj={1}\nimap.get={2} cache.contains={3} cache.size={4}, imap.size={5}\n", new Object[]{inode, dobj, this.imap.get(inode), this.cache.contains(inode), this.cache.size(), this.imap.size()});
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage getCachedStorage(DataObject dobj) {
        this.lock.writeLock().lock();
        try {
            for (FileKey n : this.cache) {
                Storage storage = this.imap.get(n);
                if (storage == null || !storage.hasDataObject(dobj)) continue;
                Storage storage2 = storage;
                return storage2;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private DataObject getDataObjectIfApplicable(CloneableOpenSupport.Env env) {
        if (!ENABLED) {
            return null;
        }
        if (!(env instanceof OpenSupport.Env)) {
            return null;
        }
        DataObject dobj = null;
        if (getDataObjectMethod != null) {
            try {
                dobj = (DataObject)getDataObjectMethod.invoke((Object)env, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (dobj == null) {
            return null;
        }
        if (!dobj.isValid()) {
            return null;
        }
        FileObject primaryFile = dobj.getPrimaryFile();
        if (primaryFile == null) {
            return null;
        }
        try {
            if (CndFileUtils.isLocalFileSystem((FileSystem)primaryFile.getFileSystem()) && Utilities.isWindows()) {
                return null;
            }
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        return dobj;
    }

    private static StorageItem createItem(Storage owner, FileKey origINode, DataObject dao, CloneableOpenSupport origCOS) {
        FileObject primaryFile = dao.getPrimaryFile();
        StorageItem out = new StorageItem(owner, origINode, dao, primaryFile, origCOS);
        dao.addPropertyChangeListener((PropertyChangeListener)out);
        primaryFile.addFileChangeListener((FileChangeListener)out);
        return out;
    }

    private static FileKey getINode(DataObject dao) {
        block15: {
            if (!dao.isValid()) {
                return INVALID_INODE;
            }
            FileObject fo = dao.getPrimaryFile();
            try {
                FileSystem fs = fo.getFileSystem();
                if (!CndFileSystemProvider.isRemote((FileSystem)fs)) break block15;
                if (ENABLED_REMOTE) {
                    try {
                        FileObject canonicalFO = fo.getCanonicalFileObject();
                        CndFileSystemProvider.CndStatInfo statInfo = CndFileSystemProvider.getStatInfo((FileObject)canonicalFO);
                        if (statInfo.isValid()) {
                            return FileKey.createRemote(fs, statInfo);
                        }
                        return INVALID_INODE;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                        break block15;
                    }
                }
                return INVALID_INODE;
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return INVALID_INODE;
            }
        }
        BasicFileAttributes attrs = null;
        try {
            Path path = FileSystems.getDefault().getPath(FileUtil.getFileDisplayName((FileObject)dao.getPrimaryFile()), new String[0]);
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.FINE, "FileNotFoundException: can not get inode for {0}:\n{1}", new Object[]{dao, ex.getMessage()});
        }
        catch (NoSuchFileException ex) {
            LOG.log(Level.FINE, "NoSuchFileException: can not get inode for {0}:\n{1}", new Object[]{dao, ex.getMessage()});
        }
        catch (InvalidPathException ex) {
            LOG.log(Level.INFO, "InvalidPathException: can not get inode for {0}:\n{1}", new Object[]{dao, ex.getMessage()});
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "{0}: can not get inode for {1}:\n{2}", new Object[]{ex.getClass().getName(), dao, ex.getMessage()});
        }
        Object key = null;
        if (attrs != null) {
            key = attrs.fileKey();
        }
        FileKey inode = INVALID_INODE;
        if (key != null) {
            inode = FileKey.createLocal(key.hashCode());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "getInode {0}[{1}], {2}", new Object[]{key, dao, inode});
            }
        }
        return inode;
    }

    static {
        INVALID_INODE = FileKey.createInvalid();
        Method m = null;
        try {
            m = OpenSupport.Env.class.getDeclaredMethod("getDataObject", new Class[0]);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            getDataObjectMethod = m;
        }
        String prop = System.getProperty("nb.cosredirector", "true");
        boolean enabled = true;
        try {
            enabled = Boolean.parseBoolean(prop);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        ENABLED = enabled;
        ENABLED_REMOTE = enabled && CndUtils.getBoolean((String)"nb.cosredirector.remote", (boolean)true);
    }

    private static final class StorageItem
    implements PropertyChangeListener,
    FileChangeListener {
        private final DataObject dao;
        private final FileKey origINode;
        private final AtomicBoolean removed = new AtomicBoolean(false);
        private final CloneableOpenSupport origCOS;
        private final Storage owner;
        private final FileObject file;

        private StorageItem(Storage owner, FileKey origINode, DataObject dao, FileObject primaryFile, CloneableOpenSupport cos) {
            this.owner = owner;
            this.dao = dao;
            this.file = primaryFile;
            this.origINode = origINode;
            this.origCOS = cos;
        }

        private DataObject getValidDataObject() {
            if (!this.removed.get() && this.dao.isValid()) {
                return this.dao;
            }
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.removed.get() && (evt.getPropertyName().equals("name") || evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("primaryFile"))) {
                if (!(evt.getSource() instanceof DataObject)) {
                    return;
                }
                DataObject toBeRemoved = (DataObject)evt.getSource();
                if (this.dao.equals(toBeRemoved)) {
                    this.checkAndUpdateIfNeeded();
                }
            }
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            this.checkAndUpdateIfNeeded();
        }

        public void fileDeleted(FileEvent fe) {
            this.removed.set(true);
            this.owner.removeItem(this);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.checkAndUpdateIfNeeded();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private void checkAndUpdateIfNeeded() {
            FileKey curINode = COSRedirectorImpl.getINode(this.dao);
            if (this.origINode != curINode) {
                LOG.log(Level.INFO, "inode file Changed {0} {1}->{2}", new Object[]{this.dao, this.origINode, curINode});
                if (this.removed.compareAndSet(false, true)) {
                    if (curINode != INVALID_INODE) {
                        COSRedirectorImpl instance = (COSRedirectorImpl)((Object)Lookup.getDefault().lookup(COSRedirectorImpl.class));
                        Storage list = instance.findOrCreateINodeList(curINode);
                        list.addDataObject(curINode, this.dao, this.origCOS);
                    }
                    this.owner.removeItem(this);
                }
            }
        }

        public String toString() {
            return this.origINode + "[" + this.removed + "]" + this.dao + "->" + this.origCOS;
        }
    }

    private static final class Storage {
        private final List<StorageItem> list = new LinkedList<StorageItem>();
        private WeakReference<CloneableOpenSupport> cosRef;
        private String cosPath = "";

        private Storage() {
        }

        private synchronized boolean addDataObject(FileKey origINode, DataObject dao, CloneableOpenSupport cos) {
            Iterator<StorageItem> iterator = this.list.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                StorageItem next = iterator.next();
                DataObject aDao = next.getValidDataObject();
                if (aDao == null) {
                    iterator.remove();
                    continue;
                }
                if (!aDao.equals(dao)) continue;
                found = true;
            }
            if (this.list.isEmpty()) {
                this.cosRef = null;
            }
            if (!found) {
                this.list.add(COSRedirectorImpl.createItem(this, origINode, dao, cos));
            }
            if (this.cosRef == null || this.cosRef.get() == null) {
                this.cosRef = new WeakReference<CloneableOpenSupport>(cos);
                this.cosPath = dao.getPrimaryFile().getPath();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Store SES for {0}", this.cosPath);
                }
                return true;
            }
            return false;
        }

        private synchronized void clear() {
            this.list.clear();
            this.cosRef = null;
        }

        private synchronized boolean hasDataObject(DataObject dao) {
            Iterator<StorageItem> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                StorageItem next = iterator.next();
                DataObject aDao = next.getValidDataObject();
                if (aDao == null) {
                    iterator.remove();
                    continue;
                }
                if (!aDao.equals(dao)) continue;
                return true;
            }
            return false;
        }

        private synchronized CloneableOpenSupport getCloneableOpenSupport(DataObject dao, CloneableOpenSupport cos) {
            CloneableOpenSupport aCos = null;
            if (this.cosRef != null) {
                aCos = (CloneableOpenSupport)this.cosRef.get();
                if (aCos == null) {
                    this.list.clear();
                    this.cosRef = null;
                    this.cosPath = "";
                } else {
                    return aCos;
                }
            }
            Iterator<StorageItem> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                StorageItem next = iterator.next();
                DataObject aDao = next.getValidDataObject();
                if (aDao == null) {
                    iterator.remove();
                    continue;
                }
                if (!aDao.equals(dao)) continue;
                this.cosRef = new WeakReference<CloneableOpenSupport>(cos);
                this.cosPath = dao.getPrimaryFile().getPath();
                aCos = cos;
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, "Store SES for {0}", this.cosPath);
                break;
            }
            return aCos;
        }

        public String toString() {
            return this.cosPath + ":" + this.list + "->" + this.cosRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeItem(StorageItem item) {
            assert (item.removed.get());
            item.dao.removePropertyChangeListener((PropertyChangeListener)item);
            item.file.removeFileChangeListener((FileChangeListener)item);
            Storage storage = this;
            synchronized (storage) {
                this.list.remove(item);
            }
        }
    }

    private static class FileKey {
        private final int fs;
        private final long dev;
        private final long inode;

        private FileKey(int fs, long dev, long inode) {
            this.fs = fs;
            this.dev = dev;
            this.inode = inode;
        }

        public static FileKey createLocal(long fileID) {
            return new FileKey(0, 0L, fileID);
        }

        public static FileKey createRemote(FileSystem fs, CndFileSystemProvider.CndStatInfo statInfo) {
            return new FileKey(System.identityHashCode(fs), statInfo.device, statInfo.inode);
        }

        private static FileKey createInvalid() {
            return new FileKey(0, 0L, -1L);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + this.fs;
            hash = 47 * hash + (int)(this.dev ^ this.dev >>> 32);
            hash = 47 * hash + (int)(this.inode ^ this.inode >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileKey other = (FileKey)obj;
            if (this.fs != other.fs) {
                return false;
            }
            if (this.dev != other.dev) {
                return false;
            }
            return this.inode == other.inode;
        }

        public String toString() {
            return "Key{fs=" + this.fs + ", dev=" + this.dev + ", inode=" + this.inode + '}';
        }
    }
}

