/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.disk.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.disk.index.FileIndex;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class SimpleFileIndex
implements FileIndex,
SelfPersistent {
    private static final int DEFAULT_INDEX_CAPACITY = 53711;
    private final Map<LayerKey, ChunkInfoBase> map = new ConcurrentHashMap<LayerKey, ChunkInfoBase>(53711);

    public SimpleFileIndex() {
    }

    public SimpleFileIndex(RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.map.put(LayerKey.read((RepositoryDataInput)input), new ChunkInfoBase(input));
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public int remove(LayerKey key) {
        ChunkInfo oldInfo = this.map.remove(key);
        return oldInfo == null ? 0 : oldInfo.getSize();
    }

    @Override
    public Collection<LayerKey> keySet() {
        return this.map.keySet();
    }

    @Override
    public Iterator<LayerKey> getKeySetIterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int put(LayerKey key, long offset, int size) {
        ChunkInfo oldInfo = this.map.put(key, new ChunkInfoBase(offset, size));
        return oldInfo == null ? 0 : oldInfo.getSize();
    }

    @Override
    public ChunkInfo get(LayerKey key) {
        ChunkInfo info = this.map.get(key);
        return info;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        output.writeInt(this.size());
        Set<Map.Entry<LayerKey, ChunkInfoBase>> aSet = this.map.entrySet();
        for (Map.Entry<LayerKey, ChunkInfoBase> anEntry : aSet) {
            LayerKey.write((LayerKey)anEntry.getKey(), (RepositoryDataOutput)output);
            anEntry.getValue().write(output);
        }
    }

    private static final class ChunkInfoBase
    implements ChunkInfo,
    Comparable<ChunkInfo>,
    SelfPersistent {
        private long offset;
        private int size;

        public ChunkInfoBase(long offset, int size) {
            this.offset = offset;
            this.size = size;
        }

        public ChunkInfoBase(RepositoryDataInput input) throws IOException {
            this.offset = input.readLong();
            this.size = input.readInt();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ChunkInfo [");
            sb.append("offset=");
            sb.append(this.getOffset());
            sb.append(" size=");
            sb.append(this.getSize());
            sb.append(']');
            return sb.toString();
        }

        @Override
        public int compareTo(ChunkInfo o) {
            return this.getOffset() < o.getOffset() ? -1 : 1;
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeLong(this.offset);
            output.writeInt(this.size);
        }
    }
}

