/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.repository.util.IntToValueList;

final class FilePathsDictionary
implements Persistent,
SelfPersistent {
    private static final Logger LOG = Logger.getLogger("repository.support.filecreate.logger");
    static final String WRONG_PATH = "<WRONG FILE>";
    private final List<CharSequence> paths;
    private final Map<CharSequence, Integer> map = new HashMap<CharSequence, Integer>();
    private final Object lock = new Object();

    FilePathsDictionary(List<CharSequence> initData) {
        if (initData != null) {
            this.paths = new ArrayList<CharSequence>(initData);
            int idx = 0;
            for (CharSequence path : initData) {
                this.map.put(path, idx++);
            }
        } else {
            this.paths = new ArrayList<CharSequence>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence getFilePath(int fileIdx) {
        Object object = this.lock;
        synchronized (object) {
            if (fileIdx >= this.paths.size()) {
                return WRONG_PATH;
            }
            return this.paths.get(fileIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.paths.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFileID(CharSequence filePath, int clientShortUnitID) {
        Object object = this.lock;
        synchronized (object) {
            Integer idx = this.map.get(filePath);
            if (idx == null) {
                int new_idx = this.paths.size();
                this.paths.add(filePath);
                this.map.put(filePath, new_idx);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Create index {0}/{1}={2}", new Object[]{new_idx, clientShortUnitID, filePath});
                }
                return new_idx;
            }
            return idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CharSequence> toList() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.paths));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n[clientFilePathID <-> clientFilePaths]\n");
        int idx = 0;
        for (CharSequence path : this.toList()) {
            sb.append(idx++).append(" => ").append(path.toString()).append("\n");
        }
        return sb.toString();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        IntToValueList<CharSequence> list = IntToValueList.createEmpty("traceName");
        int i = 0;
        List<CharSequence> toList = this.toList();
        for (CharSequence file : toList) {
            list.set(i++, file);
        }
        list.write((DataOutput)output);
    }
}

