/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.JBRemoteAction;
import org.netbeans.modules.j2ee.jboss4.JBoss5ProfileServiceProxy;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAbilitiesSupport;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAsyncChildren;
import org.netbeans.modules.j2ee.jboss4.nodes.JBWebModuleNode;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.Refreshable;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class JBWebApplicationsChildren
extends JBAsyncChildren
implements Refreshable {
    private static final Logger LOGGER = Logger.getLogger(JBWebApplicationsChildren.class.getName());
    private static final Set<String> SYSTEM_WEB_APPLICATIONS = new HashSet<String>();
    private final JBAbilitiesSupport abilitiesSupport;
    private final Lookup lookup;

    public JBWebApplicationsChildren(Lookup lookup) {
        this.lookup = lookup;
        this.abilitiesSupport = new JBAbilitiesSupport(lookup);
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        this.getExecutorService().submit(this.abilitiesSupport.isJB7x() ? new JBoss7WebNodeUpdater() : new JBossWebNodeUpdater(), 0);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof JBWebModuleNode) {
            return new Node[]{(JBWebModuleNode)((Object)key)};
        }
        if (key instanceof String && key.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }

    static {
        Collections.addAll(SYSTEM_WEB_APPLICATIONS, "jbossws-context", "jmx-console", "jbossws", "jbossws", "web-console", "invoker", "jbossmq-httpil");
    }

    class JBoss7WebNodeUpdater
    implements Runnable {
        List keys = new ArrayList();

        JBoss7WebNodeUpdater() {
        }

        @Override
        public void run() {
            try {
                final JBDeploymentManager dm = (JBDeploymentManager)JBWebApplicationsChildren.this.lookup.lookup(JBDeploymentManager.class);
                dm.invokeLocalAction(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            Target[] targets = dm.getTargets();
                            ModuleType moduleType = ModuleType.WAR;
                            TargetModuleID[] modules = dm.getAvailableModules(moduleType, targets);
                            if (modules != null) {
                                for (int intModule = 0; intModule < modules.length; ++intModule) {
                                    String name = modules[intModule].getModuleID();
                                    if (name.endsWith(".war")) {
                                        name = name.substring(0, name.lastIndexOf(".war"));
                                    }
                                    if ("".equals(name)) {
                                        name = "ROOT";
                                    }
                                    if (SYSTEM_WEB_APPLICATIONS.contains(name)) continue;
                                    name = name + ".war";
                                    JBoss7WebNodeUpdater.this.keys.add(new JBWebModuleNode(name, JBWebApplicationsChildren.this.lookup, null));
                                }
                            }
                        }
                        catch (TargetException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                        }
                        catch (IllegalStateException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            JBWebApplicationsChildren.this.setKeys(this.keys);
        }
    }

    class JBossWebNodeUpdater
    implements Runnable {
        List keys = new ArrayList();

        JBossWebNodeUpdater() {
        }

        @Override
        public void run() {
            try {
                final JBDeploymentManager dm = (JBDeploymentManager)JBWebApplicationsChildren.this.lookup.lookup(JBDeploymentManager.class);
                dm.invokeRemoteAction(new JBRemoteAction<Void>(){

                    @Override
                    public Void action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                        ObjectName searchPattern = JBWebApplicationsChildren.this.abilitiesSupport.isRemoteManagementSupported() && (JBWebApplicationsChildren.this.abilitiesSupport.isJB4x() || JBWebApplicationsChildren.this.abilitiesSupport.isJB6x()) ? new ObjectName("jboss.management.local:j2eeType=WebModule,J2EEApplication=null,*") : new ObjectName("jboss.web:j2eeType=WebModule,J2EEApplication=none,*");
                        Method method = connection.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class);
                        method = Util.fixJava4071957(method);
                        Set managedObj = (Set)method.invoke((Object)connection, searchPattern, null);
                        Iterator it = managedObj.iterator();
                        while (it.hasNext()) {
                            try {
                                ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                                String name = elem.getKeyProperty("name");
                                String url = "http://" + dm.getHost() + ":" + dm.getPort();
                                String context = null;
                                if (name.endsWith(".war")) {
                                    name = name.substring(0, name.lastIndexOf(".war"));
                                }
                                if (JBWebApplicationsChildren.this.abilitiesSupport.isRemoteManagementSupported() && (JBWebApplicationsChildren.this.abilitiesSupport.isJB4x() || JBWebApplicationsChildren.this.abilitiesSupport.isJB6x())) {
                                    if (SYSTEM_WEB_APPLICATIONS.contains(name)) continue;
                                    String descr = (String)Util.getMBeanParameter(connection, "jbossWebDeploymentDescriptor", elem.getCanonicalName());
                                    context = Util.getWebContextRoot(descr, name);
                                } else {
                                    if (name.startsWith("//localhost/")) {
                                        name = name.substring("//localhost/".length());
                                    }
                                    if ("".equals(name)) {
                                        name = "ROOT";
                                    }
                                    if (SYSTEM_WEB_APPLICATIONS.contains(name)) continue;
                                    context = (String)Util.getMBeanParameter(connection, "path", elem.getCanonicalName());
                                }
                                name = name + ".war";
                                JBossWebNodeUpdater.this.keys.add(new JBWebModuleNode(name, JBWebApplicationsChildren.this.lookup, context == null ? null : url + context));
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.INFO, null, ex);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            JBWebApplicationsChildren.this.setKeys(this.keys);
        }
    }
}

