/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public final class CndLanguageStandards {
    public static CndLanguageStandard StringToLanguageStandard(String st) {
        for (CndLanguageStandard standard : CndLanguageStandard.values()) {
            if (!standard.id.equals(st)) continue;
            return standard;
        }
        return null;
    }

    public static Collection<CndLanguageStandard> getSupported(String mime) {
        if ("text/x-c++".equals(mime)) {
            return Arrays.asList(CndLanguageStandard.CPP98, CndLanguageStandard.CPP11, CndLanguageStandard.CPP14);
        }
        if ("text/x-c".equals(mime)) {
            return Arrays.asList(CndLanguageStandard.C89, CndLanguageStandard.C99, CndLanguageStandard.C11);
        }
        if ("text/x-h".equals(mime)) {
            return Arrays.asList(CndLanguageStandard.C89, CndLanguageStandard.C99, CndLanguageStandard.C11, CndLanguageStandard.CPP98, CndLanguageStandard.CPP11, CndLanguageStandard.CPP14);
        }
        return Collections.emptyList();
    }

    public static enum CndLanguageStandard {
        C89("C89"),
        C99("C99"),
        C11("C11"),
        CPP98("C++98"),
        CPP11("C++11"),
        CPP14("C++14");

        private final String id;

        private CndLanguageStandard(String id) {
            this.id = id;
        }

        public String getID() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

