/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.FileAndFileObjectFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class CoreFileFilter
extends FileAndFileObjectFilter {
    private static final String[] MIME_TYPES = new String[]{"application/x-core+elf"};
    private static final CoreFileFilter instance = new CoreFileFilter();
    private static final int ELF_CORE_HEADER_SIZE = 18;
    private static final byte[] elf_ms = new byte[]{127, 69, 76, 70};

    public static CoreFileFilter getInstance() {
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(CoreFileFilter.class, (String)"FILECHOOSER_CORE_FILEFILTER");
    }

    @Override
    protected boolean mimeAccept(File f) {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        FileObject fo = CndFileSystemProvider.toFileObject(f);
        if (fo != null) {
            return this.mimeAccept(fo);
        }
        return this.checkElfCoreHeader(f);
    }

    @Override
    protected boolean mimeAccept(FileObject fo) {
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        return Arrays.binarySearch(MIME_TYPES, fo.getMIMEType(MIME_TYPES)) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkElfCoreHeader(File f) {
        if (!f.isFile()) {
            return false;
        }
        FileChannel channel = null;
        byte[] ms = new byte[4];
        try {
            channel = new RandomAccessFile(f, "r").getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 18L).load();
            buffer.get(ms, 0, 4);
            if (Arrays.equals(elf_ms, ms)) {
                switch (buffer.get(5)) {
                    case 1: {
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        break;
                    }
                    case 2: {
                        buffer.order(ByteOrder.BIG_ENDIAN);
                        break;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = buffer.getShort(16) == 4;
                return bl;
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return false;
    }

    @Override
    protected String[] getSuffixes() {
        return new String[0];
    }
}

