/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileSystem;

public class IncludePath {
    private final FSPath fsPath;
    private final boolean isFramework;

    private IncludePath(FSPath fsPath, boolean isFramework) {
        this.fsPath = fsPath;
        this.isFramework = isFramework;
    }

    public IncludePath(FSPath fsPath) {
        this(fsPath, false);
    }

    public IncludePath(FileSystem fileSystem, String absPath) {
        this(new FSPath(fileSystem, absPath), false);
    }

    public IncludePath(FileSystem fileSystem, String absPath, boolean isFramework) {
        this(new FSPath(fileSystem, absPath), isFramework);
    }

    public FSPath getFSPath() {
        return this.fsPath;
    }

    public FileSystem getFileSystem() {
        return this.fsPath.getFileSystem();
    }

    public boolean isFramework() {
        return this.isFramework;
    }

    public boolean ignoreSysRoot() {
        return true;
    }

    public String toString() {
        if (this.isFramework()) {
            return this.getFSPath().getPath() + "/{framework}";
        }
        return this.getFSPath().getPath();
    }

    public static IncludePath toIncludePath(FileSystem fileSystem, String path) {
        if (path.endsWith("/{framework}")) {
            return new IncludePath(fileSystem, path.substring(0, path.length() - "/{framework}".length()), true);
        }
        return new IncludePath(fileSystem, path, false);
    }

    public static List<IncludePath> toIncludePathList(FileSystem fileSystem, Collection<String> paths) {
        if (paths != null && paths.size() > 0) {
            ArrayList<IncludePath> result = new ArrayList<IncludePath>(paths.size());
            for (String path : paths) {
                result.add(IncludePath.toIncludePath(fileSystem, path));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<String> toStringList(List<IncludePath> list) {
        ArrayList<String> res = new ArrayList<String>(list.size());
        for (IncludePath p : list) {
            res.add(p.toString());
        }
        return res;
    }
}

