/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gsf.testrunner.plugin.RootsProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public abstract class TestCreatorProvider {
    public static final String FRAMEWORK_JUNIT = "JUnit";
    public static final String FRAMEWORK_TESTNG = "TestNG";
    public static final String FRAMEWORK_SELENIUM = "Selenium";
    public static final String FRAMEWORK_PHP = "PHP";
    public static final String IDENTIFIER_JUNIT = "junit";
    public static final String IDENTIFIER_TESTNG = "testng";
    public static final String IDENTIFIER_SELENIUM = "selenium";
    public static final String IDENTIFIER_PHP = "php";
    public static final String TEST_CLASS_SUFFIX = "Test";
    public static final String INTEGRATION_TEST_CLASS_SUFFIX = "IT";
    public static final String TESTNG_TEST_CLASS_SUFFIX = "NG";

    public abstract boolean enable(FileObject[] var1);

    public abstract void createTests(Context var1);

    public static SourceGroup getSourceGroup(FileObject file, Project prj) {
        SourceGroup[] srcGrps;
        Sources src = ProjectUtils.getSources((Project)prj);
        String type = "";
        Collection providers = Lookup.getDefault().lookupAll(RootsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            RootsProvider provider = (RootsProvider)iterator.next();
            type = provider.getSourceRootType();
        }
        for (SourceGroup srcGrp : srcGrps = src.getSourceGroups(type)) {
            FileObject rootFolder = srcGrp.getRootFolder();
            if (file != rootFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)file) || !srcGrp.contains(file)) continue;
            return srcGrp;
        }
        return null;
    }

    public static final class Context {
        private boolean singleClass;
        private String testClassName;
        private FileObject targetFolder;
        private final FileObject[] activatedFOs;
        private boolean integrationTests;
        private Map<String, Object> configurationPanelProperties;

        public Context(FileObject[] activatedNodes) {
            this.activatedFOs = activatedNodes;
        }

        public FileObject[] getActivatedFOs() {
            return this.activatedFOs;
        }

        public boolean isSingleClass() {
            return this.singleClass;
        }

        public void setSingleClass(boolean singleClass) {
            this.singleClass = singleClass;
        }

        public FileObject getTargetFolder() {
            return this.targetFolder;
        }

        public void setTargetFolder(FileObject targetFolder) {
            this.targetFolder = targetFolder;
        }

        public String getTestClassName() {
            return this.testClassName;
        }

        public void setTestClassName(String testClassName) {
            this.testClassName = testClassName;
        }

        public boolean isIntegrationTests() {
            return this.integrationTests;
        }

        public void setIntegrationTests(boolean integrationTests) {
            this.integrationTests = integrationTests;
        }

        public void setConfigurationPanelProperties(Map<String, Object> configurationPanelProperties) {
            this.configurationPanelProperties = configurationPanelProperties;
        }

        public Map<String, Object> getConfigurationPanelProperties() {
            return Collections.unmodifiableMap(this.configurationPanelProperties);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Registration {
        public String identifier();

        public String displayName();
    }
}

