/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.toolchain;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.openide.util.NbBundle;

public final class ToolchainScriptGenerator {
    private static final boolean TRACE = true;
    private final StringBuilder buf = new StringBuilder();
    private boolean isAutoDetected;
    private int level = 0;

    private ToolchainScriptGenerator() {
    }

    public static String generateScript(String path, HostInfo host) {
        String platformName;
        int platform;
        ToolchainScriptGenerator generator = new ToolchainScriptGenerator();
        switch (host.getOSFamily()) {
            case LINUX: {
                platform = 2;
                platformName = "PLATFORM_LINUX";
                break;
            }
            case MACOSX: {
                platform = 4;
                platformName = "PLATFORM_MACOSX";
                break;
            }
            case SUNOS: {
                if (host.getCpuFamily() == HostInfo.CpuFamily.SPARC) {
                    platform = 0;
                    platformName = "PLATFORM_SOLARIS_SPARC";
                    break;
                }
                platform = 1;
                platformName = "PLATFORM_SOLARIS_INTEL";
                break;
            }
            case WINDOWS: {
                platform = 3;
                platformName = "PLATFORM_WINDOWS";
                break;
            }
            default: {
                platform = 6;
                platformName = "PLATFORM_NONE";
            }
        }
        generator.prefix(path, platform, platformName);
        generator.scanPaths(platform);
        return generator.buf.toString();
    }

    private void prefix(String path, int platform, String platformName) {
        this.line("#!/bin/sh");
        this.line("PLATFORM=" + platform);
        this.line("PLATFORM_NAME=" + platformName);
        this.lines(NbBundle.getMessage(ToolchainScriptGenerator.class, (String)"DetectHostInfo"));
        if (path != null) {
            this.line("PATHSLIST=\"" + path + "\"");
            this.isAutoDetected = false;
        } else {
            this.isAutoDetected = true;
            this.line("echo $PLATFORM_NAME");
            if (platform == 3) {
                this.line("PATH=$PATH;C:/WINDOWS/System32;C:/WINDOWS;C:/WINDOWS/System32/WBem");
            } else if (platform != 6) {
                this.line("PATH=$PATH:/bin:/usr/bin:/sbin:/usr/sbin");
            } else {
                this.line("PATH=$PATH");
            }
            ArrayList<String> dirlist = new ArrayList<String>();
            CompilerSetManagerImpl.appendDefaultLocations(platform, dirlist);
            for (String s : dirlist) {
                this.line("PATH=$PATH:" + s);
            }
            this.line("PATHSLIST=$PATH");
        }
        if (platform == 3) {
            this.line(" IFS=;");
        } else {
            this.line(" IFS=:");
        }
        this.line("foundFlavors=\";\"");
    }

    private void scanPaths(int platform) {
        this.line("for f in $PATHSLIST; do");
        this.line("  line=");
        this.line("  flavor=");
        this.line("  version=");
        this.line("  flags=");
        this.line("  echo $f | egrep -e \"^/\" >/dev/null");
        this.line("  if [ \"$?\" != \"0\" ]; then");
        this.line("    continue  # skip relative directories");
        this.line("  fi");
        this.line("  echo $f | egrep -e \"^/usr/ucb\" >/dev/null");
        this.line("  if [ \"$?\" = \"0\" ]; then");
        this.line("    continue  # skip /usr/ucb (IZ #142780)");
        this.line("  fi");
        this.scanPath(platform);
        this.line("done");
    }

    private void scanPath(int platform) {
        this.platformPath(platform);
    }

    private void platformPath(int platform) {
        for (ToolchainManager.ToolchainDescriptor d : ToolchainManagerImpl.getImpl().getToolchains(platform)) {
            ToolchainManager.CompilerDescriptor c;
            if (d.isAbstract() || this.isAutoDetected && !d.isAutoDetected() || d.getModuleID() != null || (c = d.getC()) == null || c.getNames().length == 0) continue;
            this.line("status=");
            this.line("while [ ! -n \"$status\" ]; do");
            if (c.getPathPattern() != null) {
                this.line("  echo $f | egrep -e \"" + c.getPathPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                if (c.getExistFolder() == null) {
                    this.line("    break");
                } else {
                    this.line("    if [ ! -d \"$f/" + c.getExistFolder() + "\" ]; then");
                    this.line("      break");
                    this.line("    fi");
                }
                this.line("  fi");
            }
            this.line("  file=\"$f/" + c.getNames()[0] + "\"");
            this.line("  if [ ! -x \"$file\" ]; then");
            if (platform == 3) {
                this.line("    file=\"$f/" + c.getNames()[0] + ".exe\"");
                this.line("    if [ ! -x \"$f/" + c.getNames()[0] + ".exe\" ]; then");
                this.line("      break");
                this.line("    fi");
            } else {
                this.line("    break");
            }
            this.line("  fi");
            if (c.getVersionFlags() != null && c.getVersionPattern() != null) {
                this.line("  if [ ! \"$flags\" = \"" + c.getVersionFlags() + "\" ]; then");
                this.line("    version=`$file " + c.getVersionFlags() + " 2>&1`");
                this.line("    flags=" + c.getVersionFlags());
                this.line("  fi");
                this.line("  echo ${version} | egrep -e \"" + c.getVersionPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                this.line("    break");
                this.line("  fi");
                this.line("  versionstring=`echo ${version} | egrep -e \"" + c.getVersionPattern() + "\" | head -1`");
            } else if (c.getFingerPrintFlags() != null && c.getFingerPrintPattern() != null) {
                this.line("  if [ ! \"$flags\" = \"" + c.getFingerPrintFlags() + "\" ]; then");
                this.line("    version=`$file " + c.getFingerPrintFlags() + " 2>&1`");
                this.line("    flags=" + c.getFingerPrintFlags());
                this.line("  fi");
                this.line("  echo ${version} | egrep -e \"" + c.getFingerPrintPattern() + "\" >/dev/null");
                this.line("  status=$?");
                this.line("  if [ ! \"$status\" = \"0\" ]; then");
                this.line("    break");
                this.line("  fi");
                this.line("  versionstring=`echo ${version} | egrep -e \"" + c.getFingerPrintPattern() + "\" | head -1`");
            } else if (c.getVersionFlags() != null) {
                this.line("  if [ ! \"$flags\" = \"" + c.getVersionFlags() + "\" ]; then");
                this.line("    version=`$file " + c.getVersionFlags() + " 2>&1`");
                this.line("    flags=" + c.getVersionFlags());
                this.line("  fi");
                this.line("  versionstring=`echo ${version} | head -1`");
            } else {
                this.line("  versionstring=");
            }
            this.line("  line=\"" + d.getName() + ";$f\"");
            this.line("  flavor=\"" + d.getName() + ";\"");
            this.addTool("c", d.getC().getNames(), platform);
            if (d.getCpp() != null) {
                this.addTool("cpp", d.getCpp().getNames(), platform);
            }
            if (d.getFortran() != null) {
                this.addTool("fortran", d.getFortran().getNames(), platform);
            }
            if (d.getAssembler() != null) {
                this.addTool("assembler", d.getAssembler().getNames(), platform);
            }
            if (d.getMake() != null) {
                this.addTool("make", d.getMake().getNames(), platform);
            }
            if (d.getDebugger() != null) {
                this.addTool("debugger", d.getDebugger().getNames(), platform);
            }
            if (d.getCMake() != null) {
                this.addTool("cmake", d.getCMake().getNames(), platform);
            }
            if (d.getQMake() != null) {
                this.addTool("qmake", d.getQMake().getNames(), platform);
            }
            this.line("line=\"${line};version=${versionstring}\"");
            this.line("  addNewToolChain");
            this.line("  break");
            this.line("done");
        }
    }

    private void addTool(String kind, String[] names, int platform) {
        if (names != null) {
            StringBuilder list = new StringBuilder();
            for (String name : names) {
                if (list.length() > 0) {
                    if (platform == 3) {
                        list.append(';');
                    } else {
                        list.append(':');
                    }
                }
                list.append(name);
            }
            this.line("findCompiler \"" + list.toString() + "\" \"" + kind + "\"");
        }
    }

    private void lines(String lines) {
        StringTokenizer st = new StringTokenizer(lines, "\n");
        while (st.hasMoreTokens()) {
            this.line(st.nextToken());
        }
    }

    private void line(String line) {
        String l = line.trim();
        if (l.equals("fi") || l.equals("done") || l.equals("else") || l.equals("}")) {
            --this.level;
        }
        if (this.level >= 0) {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append(' ');
                this.buf.append(' ');
            }
        }
        if (l.startsWith("while ") || l.startsWith("if ") || l.startsWith("for ") || l.equals("else") || l.endsWith("{")) {
            ++this.level;
        }
        this.buf.append(l).append('\n');
    }
}

