/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Utilities;

class LocalHostInfoProvider
extends HostInfoProvider {
    private final ExecutionEnvironment execEnv;

    LocalHostInfoProvider(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
    }

    public boolean fileExists(String path) {
        if (new File(path).exists()) {
            return true;
        }
        if (Utilities.isWindows() && !path.endsWith(".lnk")) {
            return new File(path + ".lnk").exists();
        }
        return false;
    }

    public Map<String, String> getEnv() {
        Map result = null;
        if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.execEnv)) {
            try {
                result = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getEnvironment();
            }
            catch (IOException iOException) {
            }
            catch (ConnectionManager.CancellationException cancellationException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = System.getenv();
        }
        return result;
    }

    public String getLibDir() {
        return null;
    }

    public PathMap getMapper() {
        return new LocalPathMap();
    }

    private static class LocalPathMap
    extends PathMap {
        private LocalPathMap() {
        }

        public boolean checkRemotePaths(File[] localPaths, boolean fixMissingPath) {
            return false;
        }

        public String getLocalPath(String rpath, boolean useDefault) {
            return rpath;
        }

        public String getRemotePath(String lpath, boolean useDefault) {
            return lpath;
        }

        public String getTrueLocalPath(String rpath) {
            return rpath;
        }
    }
}

