/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bugtracking.spi.IssuePriorityInfo;
import org.openide.util.ImageUtilities;

public class IssuePrioritySupport {
    private final Map<String, IssuePriorityInfo> mapping = new HashMap<String, IssuePriorityInfo>(5);
    private final HashMap<String, Integer> order = new HashMap(5);
    private static final List<Image> icons = new ArrayList<Image>(5);
    private static final Image defaultIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/task.png", (boolean)true);

    public IssuePrioritySupport(IssuePriorityInfo[] pis) {
        for (int i = 0; i < pis.length; ++i) {
            IssuePriorityInfo info = pis[i];
            this.mapping.put(info.getID(), info);
            this.order.put(info.getID(), i);
        }
    }

    public static Image getDefaultIcon() {
        return defaultIcon;
    }

    public static Image[] getIcons() {
        return icons.toArray(new Image[icons.size()]);
    }

    private IssuePriorityInfo getInfo(String id) {
        return this.mapping != null ? this.mapping.get(id) : null;
    }

    public String getName(String id) {
        IssuePriorityInfo info = this.getInfo(id);
        String name = info != null ? info.getDisplayName() : null;
        return name != null ? name : "";
    }

    public Image getIcon(String id) {
        IssuePriorityInfo info = this.getInfo(id);
        Image icon = null;
        if (info != null && (icon = info.getIcon()) == null) {
            Integer idx = this.order.get(id);
            Image image = icon = idx < icons.size() ? icons.get(idx) : IssuePrioritySupport.getDefaultIcon();
        }
        if (icon == null) {
            icon = IssuePrioritySupport.getDefaultIcon();
        }
        return icon;
    }

    static {
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/taskP1.png", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/taskP2.png", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/taskP3.png", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/taskP4.png", (boolean)true));
        icons.add(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/tasks/resources/taskP5.png", (boolean)true));
    }
}

