/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.form.editors.ClassPathFileChooser;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.editors.ImportImageWizard;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class CustomIconEditor
extends JPanel {
    private IconEditor propertyEditor;
    private FileObject packageRoot;
    private FileObject selectedPackage;
    private FileObject selectedCPFile;
    private File selectedExternalFile;
    private String selectedURL;
    private static String lastDirectoryUsed;
    private boolean ignoreSetValue;
    private boolean ignoreNull;
    private boolean ignoreCombo;
    private Icon packageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/form/resources/package.gif", (boolean)false);
    private JButton browseExternalButton;
    private JButton browseFileButton;
    private ButtonGroup buttonGroup1;
    private JRadioButton classPathRadio;
    private JRadioButton externalRadio;
    private JComboBox fileCombo;
    private JLabel fileLabel;
    private JButton importButton;
    private JRadioButton noIconRadio;
    private JComboBox packageCombo;
    private JLabel packageLabel;
    private JLabel previewLabel;
    private JScrollPane scrollPane;
    private JTextField urlField;
    private JLabel urlLabel;

    public CustomIconEditor(IconEditor prEd) {
        this.propertyEditor = prEd;
        this.initComponents();
        this.scrollPane.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        CustomIconEditor.setupBrowseButton(this.browseFileButton);
        CustomIconEditor.setupBrowseButton(this.browseExternalButton);
        if (!prEd.isExternalIconsAllowed()) {
            this.externalRadio.setEnabled(false);
            this.urlField.setEnabled(false);
            this.browseExternalButton.setEnabled(false);
        }
        this.packageCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(CustomIconEditor.this.packageIcon);
                return this;
            }
        });
        this.fileCombo.setPrototypeDisplayValue(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor_FileCombo_Select"));
        this.fileCombo.setRenderer(new IconComboRenderer());
        this.setTransferHandler(new FileDropHandler());
    }

    private static void setupBrowseButton(JButton button) {
        Insets margin = button.getMargin();
        if (margin.left > 4) {
            margin.left = 4;
            margin.right = 4;
            button.setMargin(margin);
        }
    }

    void setValue(IconEditor.NbImageIcon nbIcon) {
        if (this.ignoreSetValue || nbIcon == null && this.ignoreNull) {
            return;
        }
        this.selectedCPFile = null;
        this.selectedExternalFile = null;
        this.selectedURL = null;
        this.ignoreCombo = true;
        if (this.fileCombo.getItemCount() > 0) {
            this.fileCombo.setSelectedIndex(0);
        }
        this.ignoreCombo = false;
        this.urlField.setText("");
        if (nbIcon == null || nbIcon.getType() != 3) {
            FileObject sourceFile = this.propertyEditor.getSourceFile();
            ClassPath cp = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/source");
            if (cp != null) {
                FileObject defaultFolder = this.propertyEditor.getDefaultResourceFolder();
                this.setPackageRoot(cp.findOwnerRoot(defaultFolder));
                this.setPackage(defaultFolder);
            } else {
                this.externalRadio.setSelected(true);
                this.classPathRadio.setEnabled(false);
                this.packageCombo.setEnabled(false);
                this.fileCombo.setEnabled(false);
                this.browseFileButton.setEnabled(false);
                this.importButton.setEnabled(false);
                return;
            }
        }
        if (nbIcon == null) {
            this.classPathRadio.setSelected(true);
            this.previewLabel.setIcon(null);
            return;
        }
        switch (nbIcon.getType()) {
            case 3: {
                this.setFromResourceName(nbIcon.getName(), true);
                this.classPathRadio.setSelected(true);
                break;
            }
            case 2: {
                this.setFromFileName(nbIcon.getName());
                this.externalRadio.setSelected(true);
                break;
            }
            case 1: {
                this.setFromURL(nbIcon.getName());
                this.externalRadio.setSelected(true);
            }
        }
        this.previewLabel.setIcon(nbIcon.getIcon());
    }

    private void setFromResourceName(String resName, boolean setDefaultIfInvalid) {
        FileObject[] roots;
        if (resName.startsWith("/")) {
            resName = resName.substring(1);
        }
        FileObject sourceFile = this.propertyEditor.getSourceFile();
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/source");
        ClassPath execCP = null;
        ClassPath cp = sourceCP;
        FileObject fo = cp.findResource(resName);
        if (fo == null && (fo = (cp = (execCP = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/execute"))).findResource(resName)) != null && (roots = this.findSourceRoots(fo)) != null && roots.length != 0) {
            FileObject fob = this.findSourceRootOf(roots, resName);
            if (fob == null) {
                fo = null;
                cp = sourceCP;
            } else {
                fo = fob;
                cp = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
            }
        }
        if (fo != null) {
            this.setPackageRoot(cp.findOwnerRoot(fo));
            this.setPackage(fo.getParent());
            this.setPackageFile(fo);
        } else if (setDefaultIfInvalid) {
            String pkgName;
            FileObject folder = null;
            int i = resName.lastIndexOf(47);
            if (i < 0) {
                pkgName = null;
            } else {
                cp = sourceCP;
                pkgName = resName.substring(0, i);
                folder = cp.findResource(pkgName);
                if (folder == null) {
                    FileObject[] roots2;
                    cp = execCP;
                    folder = cp.findResource(pkgName);
                    if (folder != null && (roots2 = this.findSourceRoots(folder)) != null && roots2.length > 0) {
                        FileObject fob = this.findSourceRootOf(roots2, pkgName);
                        if (fob == null) {
                            folder = null;
                        } else {
                            folder = fob;
                            cp = ClassPath.getClassPath((FileObject)fob, (String)"classpath/source");
                        }
                    }
                } else if (cp.findAllResources(pkgName).size() > 1) {
                    folder = null;
                }
            }
            if (folder == null) {
                folder = this.propertyEditor.getDefaultResourceFolder();
                cp = sourceCP;
            }
            this.setPackageRoot(cp.findOwnerRoot(folder));
            this.setPackage(folder);
        }
    }

    private FileObject[] findSourceRoots(FileObject fo) {
        try {
            ClassPath cp = ClassPath.getClassPath((FileObject)this.propertyEditor.getSourceFile(), (String)"classpath/execute");
            return SourceForBinaryQuery.findSourceRoots((URL)cp.findOwnerRoot(fo).getURL()).getRoots();
        }
        catch (FileStateInvalidException fsiex) {
            Logger.getLogger(CustomIconEditor.class.getName()).log(Level.INFO, null, fsiex);
            return null;
        }
    }

    private FileObject findSourceRootOf(FileObject[] roots, String resName) {
        for (FileObject root : roots) {
            FileObject res;
            ClassPath resCP = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
            if (resCP == null || (res = resCP.findResource(resName)) == null) continue;
            return res;
        }
        return null;
    }

    private void setFromFileName(String fileName) {
        this.selectedExternalFile = new File(fileName);
        try {
            this.urlField.setText(this.selectedExternalFile.toURL().toExternalForm());
        }
        catch (MalformedURLException ex) {
            this.urlField.setText("file:/" + fileName);
        }
    }

    private void setFromURL(String urlString) {
        this.selectedURL = urlString;
        this.urlField.setText(this.selectedURL);
    }

    private void setPackageRoot(FileObject root) {
        if (root != this.packageRoot) {
            this.packageCombo.setModel(CustomIconEditor.createPackageComboModel(root));
            this.packageRoot = root;
        }
    }

    private void setPackage(FileObject folder) {
        if (folder != this.selectedPackage) {
            this.selectedPackage = folder;
            this.ignoreCombo = true;
            this.packageCombo.setSelectedItem(CustomIconEditor.getPackageName(folder, this.packageRoot));
            this.ignoreCombo = false;
            this.fileCombo.setModel(CustomIconEditor.createFileComboModel(folder));
        }
    }

    private void setPackageFile(FileObject fo) {
        this.selectedCPFile = null;
        int n = this.fileCombo.getModel().getSize();
        for (int i = 1; i < n; ++i) {
            IconFileItem item = (IconFileItem)this.fileCombo.getModel().getElementAt(i);
            if (!item.file.equals(fo)) continue;
            this.selectedCPFile = fo;
            this.ignoreCombo = true;
            this.fileCombo.setSelectedIndex(i);
            this.ignoreCombo = false;
            break;
        }
    }

    private void setExternalFile(File file) {
        this.setExternalAsCPFile(file);
        this.selectedExternalFile = file;
        this.selectedURL = null;
    }

    private boolean setExternalAsCPFile(File file) {
        ClassPath cp;
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo != null && (cp = ClassPath.getClassPath((FileObject)this.propertyEditor.getSourceFile(), (String)"classpath/source")).contains(fo)) {
            this.setPackageRoot(cp.findOwnerRoot(fo));
            this.setPackage(fo.getParent());
            this.setPackageFile(fo);
            return true;
        }
        return false;
    }

    private void switchFromCPToExternal() {
        if (this.isClassPathSelected() && this.selectedCPFile != null && this.selectedExternalFile == null && this.selectedURL == null) {
            this.selectedExternalFile = FileUtil.toFile((FileObject)this.selectedCPFile);
            try {
                this.urlField.setText(this.selectedExternalFile.toURL().toExternalForm());
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        int type = -1;
        String name = null;
        ImageIcon icon = null;
        if (this.isClassPathSelected()) {
            if (this.selectedCPFile != null) {
                name = FileUtil.getRelativePath((FileObject)this.packageRoot, (FileObject)this.selectedCPFile);
                try {
                    try {
                        BufferedImage image = ImageIO.read(this.selectedCPFile.getURL());
                        if (image != null) {
                            icon = new ImageIcon(image);
                            type = 3;
                        }
                    }
                    catch (IllegalArgumentException iaex) {
                        Logger.getLogger(CustomIconEditor.class.getName()).log(Level.INFO, null, iaex);
                        icon = new ImageIcon(this.selectedCPFile.getURL());
                        type = 3;
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        } else if (this.isExternalSelected()) {
            if (this.selectedExternalFile != null) {
                name = this.selectedExternalFile.getAbsolutePath();
                try {
                    try {
                        BufferedImage image = ImageIO.read(new File(name));
                        if (image != null) {
                            icon = new ImageIcon(image);
                            type = 2;
                        }
                    }
                    catch (IllegalArgumentException iaex) {
                        Logger.getLogger(CustomIconEditor.class.getName()).log(Level.INFO, null, iaex);
                        icon = new ImageIcon(name);
                        type = 2;
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, ex);
                }
            } else if (this.selectedURL != null && !"".equals(this.selectedURL)) {
                type = 1;
                name = this.selectedURL;
                try {
                    try {
                        BufferedImage image = ImageIO.read(new URL(this.selectedURL));
                        if (image != null) {
                            icon = new ImageIcon(image);
                        }
                    }
                    catch (IllegalArgumentException iaex) {
                        Logger.getLogger(CustomIconEditor.class.getName()).log(Level.INFO, null, iaex);
                        icon = new ImageIcon(new URL(this.selectedURL));
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, ex);
                }
            }
        }
        this.ignoreSetValue = true;
        try {
            this.propertyEditor.setValue(type != -1 ? new IconEditor.NbImageIcon(type, name, icon) : null);
        }
        finally {
            this.ignoreSetValue = false;
        }
        this.previewLabel.setIcon(icon);
    }

    private boolean isClassPathSelected() {
        return this.classPathRadio.isSelected();
    }

    private boolean isExternalSelected() {
        return this.externalRadio.isSelected();
    }

    private static ComboBoxModel createPackageComboModel(FileObject root) {
        TreeSet<String> data = new TreeSet<String>();
        CustomIconEditor.collectPackages(root, root, data);
        return new DefaultComboBoxModel<String>(new Vector<String>(data));
    }

    private static void collectPackages(FileObject folder, FileObject root, Collection<String> col) {
        assert (folder.isFolder());
        boolean hasSubfolders = false;
        boolean hasFiles = false;
        for (FileObject fo : folder.getChildren()) {
            if (fo.isFolder() && VisibilityQuery.getDefault().isVisible(fo)) {
                CustomIconEditor.collectPackages(fo, root, col);
                hasSubfolders = true;
                continue;
            }
            hasFiles = true;
        }
        if (hasFiles || !hasSubfolders) {
            col.add(CustomIconEditor.getPackageName(folder, root));
        }
    }

    private static String getPackageName(FileObject folder, FileObject root) {
        String path = FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        return "".equals(path) ? "<default>" : path.replace('/', '.');
    }

    private static ComboBoxModel createFileComboModel(FileObject folder) {
        TreeSet<IconFileItem> data = new TreeSet<IconFileItem>();
        int maxIconW = 0;
        int maxIconH = 0;
        for (FileObject fo : folder.getChildren()) {
            if (!IconEditor.isImageFile(fo)) continue;
            IconFileItem ifi = new IconFileItem(fo);
            data.add(ifi);
            Dimension iconSize = ifi.getScaledSize();
            if (iconSize.width > maxIconW) {
                maxIconW = iconSize.width;
            }
            if (iconSize.height <= maxIconH) continue;
            maxIconH = iconSize.height;
        }
        for (IconFileItem ifi : data) {
            ifi.setEffectiveSize(maxIconW, maxIconH);
        }
        Vector<Object> v = new Vector<Object>(data.size() + 1);
        v.add(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor_FileCombo_Select"));
        v.addAll(data);
        return new DefaultComboBoxModel(v);
    }

    private void selectClassPathFile() {
        ClassPathFileChooser chooser = new ClassPathFileChooser(this.propertyEditor.getSourceFile(), new ClassPathFileChooser.Filter(){

            @Override
            public boolean accept(FileObject fo) {
                return fo.isFolder() || IconEditor.isImageFileName(fo.getNameExt());
            }
        }, false, true);
        try {
            if (this.selectedCPFile != null) {
                chooser.setSelectedFile(this.selectedCPFile);
            } else {
                chooser.setSelectedFile(this.selectedPackage);
                chooser.setSelectedFile(null);
            }
        }
        catch (IllegalArgumentException iaex) {
            ErrorManager.getDefault().notify(1, (Throwable)iaex);
        }
        chooser.getDialog(NbBundle.getMessage(CustomIconEditor.class, (String)"CTL_OpenDialogName"), null).setVisible(true);
        if (chooser.isConfirmed()) {
            this.setPackageRoot(chooser.getSelectedPackageRoot());
            FileObject fo = chooser.getSelectedFile();
            this.setPackage(fo.getParent());
            this.setPackageFile(fo);
            this.classPathRadio.setSelected(true);
            this.updateValue();
        }
    }

    private String getFileChooserDir() {
        if (lastDirectoryUsed == null && this.selectedPackage != null) {
            lastDirectoryUsed = FileUtil.toFile((FileObject)this.selectedPackage).getPath();
        }
        return lastDirectoryUsed;
    }

    private void selectExternalFile() {
        JFileChooser fileChooser = new JFileChooser(this.getFileChooserDir());
        fileChooser.setDialogTitle(NbBundle.getMessage(CustomIconEditor.class, (String)"CTL_OpenDialogName"));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setControlButtonsAreShown(true);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || IconEditor.isImageFileName(f.getName());
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CustomIconEditor.class, (String)"CTL_ImagesExtensionName");
            }
        });
        if (fileChooser.showOpenDialog(this.getTopLevelAncestor()) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file != null) {
                try {
                    this.urlField.setText(file.toURL().toExternalForm());
                }
                catch (MalformedURLException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                this.externalRadio.setSelected(true);
            }
            lastDirectoryUsed = file.getParent();
            this.setExternalFile(file);
            this.updateValue();
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.previewLabel = new JLabel();
        this.classPathRadio = new JRadioButton();
        this.externalRadio = new JRadioButton();
        this.fileLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.urlLabel = new JLabel();
        this.browseExternalButton = new JButton();
        this.fileCombo = new JComboBox();
        this.packageCombo = new JComboBox();
        this.importButton = new JButton();
        this.noIconRadio = new JRadioButton();
        this.urlField = new JTextField();
        this.browseFileButton = new JButton();
        this.previewLabel.setHorizontalAlignment(0);
        this.scrollPane.setViewportView(this.previewLabel);
        this.buttonGroup1.add(this.classPathRadio);
        this.classPathRadio.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.classPathRadio.text"));
        this.classPathRadio.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.classPathRadio.toolTipText"));
        this.classPathRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classPathRadio.setMargin(new Insets(0, 0, 0, 0));
        this.classPathRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.classPathRadioActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.externalRadio);
        this.externalRadio.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.externalRadio.text"));
        this.externalRadio.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.externalRadio.toolTipText"));
        this.externalRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.externalRadio.setMargin(new Insets(0, 0, 0, 0));
        this.externalRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.externalRadioActionPerformed(evt);
            }
        });
        this.fileLabel.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.fileLabel.text"));
        this.packageLabel.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.packageLabel.text"));
        this.urlLabel.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.urlLabel.text"));
        this.browseExternalButton.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseExternalButton.text"));
        this.browseExternalButton.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseExternalButton.toolTipText"));
        this.browseExternalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.browseExternalButtonActionPerformed(evt);
            }
        });
        this.fileCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.fileComboActionPerformed(evt);
            }
        });
        this.packageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.packageComboActionPerformed(evt);
            }
        });
        this.importButton.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.importButton.text"));
        this.importButton.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.importButton.toolTipText"));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.importButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.noIconRadio);
        this.noIconRadio.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.noIconRadio.text"));
        this.noIconRadio.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.noIconRadio.toolTipText"));
        this.noIconRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noIconRadio.setMargin(new Insets(0, 0, 0, 0));
        this.noIconRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.noIconRadioActionPerformed(evt);
            }
        });
        this.urlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.urlFieldActionPerformed(evt);
            }
        });
        this.browseFileButton.setText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseFileButton.text"));
        this.browseFileButton.setToolTipText(NbBundle.getMessage(CustomIconEditor.class, (String)"CustomIconEditor.browseFileButton.toolTipText"));
        this.browseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomIconEditor.this.browseFileButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, -1, 453, Short.MAX_VALUE).addComponent(this.classPathRadio, GroupLayout.Alignment.LEADING).addComponent(this.externalRadio, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel).addComponent(this.packageLabel).addComponent(this.urlLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.urlField, -1, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseExternalButton)).addGroup(layout.createSequentialGroup().addComponent(this.fileCombo, 0, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseFileButton)).addComponent(this.importButton).addComponent(this.packageCombo, 0, 345, Short.MAX_VALUE))).addComponent(this.noIconRadio, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.classPathRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageLabel).addComponent(this.packageCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileCombo, -2, -1, -2).addComponent(this.browseFileButton)).addGap(11, 11, 11).addComponent(this.externalRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseExternalButton).addComponent(this.urlLabel).addComponent(this.urlField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importButton).addGap(11, 11, 11).addComponent(this.noIconRadio).addGap(11, 11, 11).addComponent(this.scrollPane, -1, 64, Short.MAX_VALUE)));
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        ClassPath cp;
        FileObject fo;
        File[] files;
        files = this.selectedExternalFile != null ? (files = new File[]{this.selectedExternalFile}) : null;
        FileObject srcFile = this.propertyEditor.getSourceFile();
        ImportImageWizard.lastDirectoryUsed = this.getFileChooserDir();
        FileObject[] imported = new ImportImageWizard(files, this.selectedPackage, srcFile).show();
        lastDirectoryUsed = ImportImageWizard.lastDirectoryUsed;
        FileObject fileObject = fo = imported != null && imported.length > 0 ? imported[0] : null;
        if (fo != null && (cp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source")).contains(fo)) {
            this.setPackageRoot(cp.findOwnerRoot(fo));
            this.selectedPackage = null;
            this.setPackage(fo.getParent());
            this.setPackageFile(fo);
            this.classPathRadio.setSelected(true);
            this.updateValue();
        }
    }

    private void urlFieldActionPerformed(ActionEvent evt) {
        String text = this.urlField.getText();
        if (this.selectedPackage != null) {
            this.propertyEditor.setCurrentFolder(this.selectedPackage);
        }
        this.ignoreNull = true;
        try {
            this.propertyEditor.setAsText(text);
        }
        finally {
            this.ignoreNull = false;
        }
        if (this.propertyEditor.getValue() instanceof IconEditor.NbImageIcon) {
            this.setValue((IconEditor.NbImageIcon)this.propertyEditor.getValue());
            this.switchFromCPToExternal();
        } else if (!"".equals(text.trim())) {
            this.urlField.setText(text);
            this.urlField.setSelectionStart(0);
            this.urlField.setSelectionEnd(text.length());
            Toolkit.getDefaultToolkit().beep();
        }
        this.externalRadio.setSelected(true);
    }

    private void classPathRadioActionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    private void externalRadioActionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    private void noIconRadioActionPerformed(ActionEvent evt) {
        this.updateValue();
    }

    private void fileComboActionPerformed(ActionEvent evt) {
        if (!this.ignoreCombo) {
            Object item = this.fileCombo.getSelectedItem();
            if (item instanceof IconFileItem) {
                this.selectedCPFile = ((IconFileItem)item).file;
                this.classPathRadio.setSelected(true);
            } else {
                this.selectedCPFile = null;
            }
            this.updateValue();
        }
    }

    private void browseExternalButtonActionPerformed(ActionEvent evt) {
        this.selectExternalFile();
    }

    private void browseFileButtonActionPerformed(ActionEvent evt) {
        this.selectClassPathFile();
    }

    private void packageComboActionPerformed(ActionEvent evt) {
        if (!this.ignoreCombo) {
            String pkgName = this.packageCombo.getSelectedItem().toString();
            this.selectedPackage = this.packageRoot.getFileObject(pkgName.replace('.', '/'));
            if (this.selectedPackage == null) {
                this.selectedPackage = this.packageRoot;
            }
            this.fileCombo.setModel(CustomIconEditor.createFileComboModel(this.selectedPackage));
        }
    }

    private class FileDropHandler
    extends TransferHandler {
        private FileDropHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (DataFlavor f : flavors) {
                if (!DataFlavor.javaFileListFlavor.equals(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            File file;
            if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            List files = null;
            try {
                files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return false;
            }
            if (files.size() > 0 && (file = (File)files.get(0)) != null && IconEditor.isImageFileName(file.getName())) {
                if (CustomIconEditor.this.setExternalAsCPFile(file)) {
                    CustomIconEditor.this.classPathRadio.setSelected(true);
                } else {
                    CustomIconEditor.this.selectedExternalFile = file;
                    CustomIconEditor.this.selectedURL = null;
                    CustomIconEditor.this.externalRadio.setSelected(true);
                    try {
                        CustomIconEditor.this.urlField.setText(file.toURL().toExternalForm());
                    }
                    catch (MalformedURLException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                CustomIconEditor.this.updateValue();
                return true;
            }
            return false;
        }
    }

    private class IconComboRenderer
    extends DefaultListCellRenderer {
        private IconComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value != null ? value.toString() : value, index, isSelected, cellHasFocus);
            this.setIcon(value instanceof IconFileItem ? (IconFileItem)value : null);
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            Icon icon = this.getIcon();
            if (icon != null && !CustomIconEditor.this.fileCombo.isPopupVisible()) {
                this.setIcon(null);
            } else {
                icon = null;
            }
            super.paintComponent(g);
            if (icon != null) {
                this.setIcon(icon);
            }
        }
    }

    private static class IconFileItem
    implements Comparable,
    Icon {
        private FileObject file;
        private ImageIcon icon;
        private boolean scaled;
        private int maxW;
        private int maxH;
        private static final int MAX_W = 32;
        private static final int MAX_H = 32;
        private static final long SIZE_LIMIT = 50000L;

        IconFileItem(FileObject file) {
            this.file = file;
            try {
                try {
                    BufferedImage image = file.getSize() < 50000L ? ImageIO.read(file.getURL()) : null;
                    this.icon = image != null ? new ImageIcon(image) : null;
                }
                catch (IllegalArgumentException iaex) {
                    Logger.getLogger(CustomIconEditor.class.getName()).log(Level.INFO, null, iaex);
                    this.icon = new ImageIcon(file.getURL());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CustomIconEditor.class.getName()).log(Level.WARNING, null, ex);
            }
        }

        public String toString() {
            return this.file.getNameExt();
        }

        public int compareTo(Object obj) {
            return this.toString().compareTo(obj.toString());
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon == null) {
                return;
            }
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            if (!this.scaled) {
                if (w > this.maxW || h > this.maxH) {
                    Dimension size = this.getScaledSize();
                    w = size.width;
                    h = size.height;
                    this.icon.setImage(this.icon.getImage().getScaledInstance(w, h, 2));
                }
                this.scaled = true;
            }
            this.icon.paintIcon(c, g, x + (this.maxW - w) / 2, y + (this.maxH - h) / 2);
        }

        @Override
        public int getIconWidth() {
            return this.maxW;
        }

        @Override
        public int getIconHeight() {
            return this.maxH;
        }

        Dimension getScaledSize() {
            if (this.icon == null) {
                return new Dimension(0, 0);
            }
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            if (w > 32 || h > 32) {
                float ratio = (float)w / (float)h;
                if (w > h) {
                    w = 32;
                    h = Math.max(1, Math.round(32.0f / ratio));
                } else {
                    h = 32;
                    w = Math.max(1, Math.round(32.0f * ratio));
                }
            }
            return new Dimension(w, h);
        }

        void setEffectiveSize(int w, int h) {
            this.maxW = w > 0 ? w : 32;
            this.maxH = h > 0 ? h : 32;
        }
    }
}

