/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.remote;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.remote.RemoteClass;

public final class RemoteServices {
    private RemoteServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference uploadClass(ThreadReference tr, RemoteClass rc) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        StringReference nameMirror;
        ArrayReference byteArray;
        ClassObjectReference theUploadedClass;
        block16: {
            VirtualMachine vm = MirrorWrapper.virtualMachine(tr);
            ObjectReference classLoader = RemoteServices.getContextClassLoader(tr, vm);
            ClassType classLoaderClass = (ClassType)ObjectReferenceWrapper.referenceType(classLoader);
            String className = rc.name;
            theUploadedClass = null;
            byteArray = RemoteServices.createTargetBytes(vm, rc.bytes, new ByteValue[256]);
            nameMirror = null;
            try {
                ClassType bc;
                Method defineClass = ClassTypeWrapper.concreteMethodByName(classLoaderClass, "defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
                boolean uploaded = false;
                while (!uploaded) {
                    nameMirror = VirtualMachineWrapper.mirrorOf(vm, className);
                    try {
                        ObjectReferenceWrapper.disableCollection(nameMirror);
                        uploaded = true;
                    }
                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    }
                    catch (UnsupportedOperationExceptionWrapper uex) {
                        uploaded = true;
                    }
                }
                uploaded = false;
                while (!uploaded) {
                    theUploadedClass = (ClassObjectReference)ObjectReferenceWrapper.invokeMethod(classLoader, tr, defineClass, Arrays.asList(nameMirror, byteArray, vm.mirrorOf(0), vm.mirrorOf(rc.bytes.length)), 1);
                    try {
                        ObjectReferenceWrapper.disableCollection(theUploadedClass);
                        uploaded = true;
                    }
                    catch (ObjectCollectedExceptionWrapper uex) {
                    }
                    catch (UnsupportedOperationExceptionWrapper uex) {
                        uploaded = true;
                    }
                }
                if (!uploaded || (bc = (ClassType)theUploadedClass.reflectedType()).isInitialized()) break block16;
                ClassType theClass = RemoteServices.getClass(vm, Class.class.getName());
                Method aMethod = ClassTypeWrapper.concreteMethodByName(theClass, "getConstructors", "()[Ljava/lang/reflect/Constructor;");
                ObjectReferenceWrapper.invokeMethod(theUploadedClass, tr, aMethod, Collections.EMPTY_LIST, 1);
            }
            catch (Throwable throwable) {
                try {
                    ObjectReferenceWrapper.enableCollection(byteArray);
                    if (nameMirror != null) {
                        ObjectReferenceWrapper.enableCollection(nameMirror);
                    }
                }
                catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            ObjectReferenceWrapper.enableCollection(byteArray);
            if (nameMirror != null) {
                ObjectReferenceWrapper.enableCollection(nameMirror);
            }
        }
        catch (UnsupportedOperationExceptionWrapper unsupportedOperationExceptionWrapper) {}
        return theUploadedClass;
    }

    private static ObjectReference getContextClassLoader(ThreadReference tr, VirtualMachine vm) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, ObjectCollectedExceptionWrapper {
        ReferenceType threadType = tr.referenceType();
        Method getContextCl = ClassTypeWrapper.concreteMethodByName((ClassType)threadType, "getContextClassLoader", "()Ljava/lang/ClassLoader;");
        ObjectReference cl = (ObjectReference)ObjectReferenceWrapper.invokeMethod(tr, tr, getContextCl, Collections.EMPTY_LIST, 1);
        ClassType classLoaderClass = null;
        if (cl == null) {
            classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
            Method getSystemClassLoader = ClassTypeWrapper.concreteMethodByName(classLoaderClass, "getSystemClassLoader", "()Ljava/lang/ClassLoader;");
            cl = (ObjectReference)ClassTypeWrapper.invokeMethod(classLoaderClass, tr, getSystemClassLoader, Collections.EMPTY_LIST, 1);
        }
        return cl;
    }

    private static ClassType getClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, ObjectCollectedExceptionWrapper, VMDisconnectedExceptionWrapper {
        List<ReferenceType> classList = VirtualMachineWrapper.classesByName(vm, name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader(c) != null) continue;
            clazz = c;
            break;
        }
        if (clazz == null && classList.size() > 0) {
            clazz = classList.get(0);
        }
        return (ClassType)clazz;
    }

    private static ArrayType getArrayClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, ObjectCollectedExceptionWrapper, VMDisconnectedExceptionWrapper {
        List<ReferenceType> classList = VirtualMachineWrapper.classesByName(vm, name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader(c) != null) continue;
            clazz = c;
            break;
        }
        return (ArrayType)clazz;
    }

    private static ArrayReference createTargetBytes(VirtualMachine vm, byte[] bytes, ByteValue[] mirrorBytesCache) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        ArrayType bytesArrayClass = RemoteServices.getArrayClass(vm, "byte[]");
        ArrayReference array = null;
        boolean disabledCollection = false;
        while (!disabledCollection) {
            array = ArrayTypeWrapper.newInstance(bytesArrayClass, bytes.length);
            try {
                ObjectReferenceWrapper.disableCollection(array);
                disabledCollection = true;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            }
            catch (UnsupportedOperationExceptionWrapper uex) {
                disabledCollection = true;
            }
        }
        ArrayList<ByteValue> values = new ArrayList<ByteValue>(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            ByteValue mb = mirrorBytesCache[128 + b];
            if (mb == null) {
                mirrorBytesCache[128 + b] = mb = VirtualMachineWrapper.mirrorOf(vm, b);
            }
            values.add(mb);
        }
        ArrayReferenceWrapper.setValues(array, values);
        return array;
    }
}

