/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.DriverFactory;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdump.source.Driver;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class CompilerSettings {
    private final ProjectBridge projectBridge;
    private final List<String> systemIncludePathsC;
    private final List<String> systemIncludePathsCpp;
    private final Map<String, String> systemMacroDefinitionsC;
    private final Map<String, String> systemMacroDefinitionsCpp;
    private Map<String, String> normalizedPaths = new ConcurrentHashMap<String, String>();
    private final CompilerFlavor compileFlavor;
    private final String cygwinDriveDirectory;
    private final boolean isWindows;
    private final boolean isLicalFileSystem;
    private final ExecutionEnvironment developmentHostExecutionEnvironment;
    private final FileSystem soruceFileSystem;
    private final CompilerSet compilerSet;
    private final Driver driver;

    public CompilerSettings(ProjectProxy project) {
        this.projectBridge = DiscoveryUtils.getProjectBridge((ProjectProxy)project);
        this.systemIncludePathsCpp = this.getSystemIncludePaths(this.projectBridge, true);
        this.systemIncludePathsC = this.getSystemIncludePaths(this.projectBridge, false);
        this.systemMacroDefinitionsCpp = this.getSystemMacroDefinitions(this.projectBridge, true);
        this.systemMacroDefinitionsC = this.getSystemMacroDefinitions(this.projectBridge, false);
        this.compileFlavor = this.getCompilerFlavor(this.projectBridge);
        this.isWindows = Utilities.isWindows();
        this.cygwinDriveDirectory = this.isWindows ? this.getCygwinDrive(this.projectBridge) : null;
        if (this.projectBridge != null) {
            this.developmentHostExecutionEnvironment = this.projectBridge.getDevelopmentHostExecutionEnvironment();
            this.soruceFileSystem = this.projectBridge.getBaseFolderFileSystem();
            this.compilerSet = this.projectBridge.getCompilerSet();
            this.isLicalFileSystem = CndFileUtils.isLocalFileSystem((FileSystem)this.soruceFileSystem);
        } else {
            this.developmentHostExecutionEnvironment = ExecutionEnvironmentFactory.getLocal();
            this.soruceFileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)this.developmentHostExecutionEnvironment);
            this.compilerSet = null;
            this.isLicalFileSystem = true;
        }
        this.driver = DriverFactory.getDriver((CompilerSet)this.compilerSet);
    }

    public ProjectBridge getProjectBridge() {
        return this.projectBridge;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public boolean isRemoteDevelopmentHost() {
        if (this.developmentHostExecutionEnvironment == null) {
            return false;
        }
        return this.developmentHostExecutionEnvironment.isRemote();
    }

    public boolean isLocalFileSystem() {
        return this.isLicalFileSystem;
    }

    public FileSystem getFileSystem() {
        return this.soruceFileSystem;
    }

    public List<String> getSystemIncludePaths(ItemProperties.LanguageKind lang) {
        if (lang == ItemProperties.LanguageKind.CPP) {
            return this.systemIncludePathsCpp;
        }
        if (lang == ItemProperties.LanguageKind.C) {
            return this.systemIncludePathsC;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getSystemMacroDefinitions(ItemProperties.LanguageKind lang) {
        if (lang == ItemProperties.LanguageKind.CPP) {
            return this.systemMacroDefinitionsCpp;
        }
        if (lang == ItemProperties.LanguageKind.C) {
            return this.systemMacroDefinitionsC;
        }
        return Collections.emptyMap();
    }

    public String getNormalizedPath(String path) {
        String res = this.normalizedPaths.get(path);
        if (res == null) {
            res = PathCache.getString(this.normalizePath(path));
            this.normalizedPaths.put(PathCache.getString(path), res);
        }
        return res;
    }

    protected String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = this.isWindows() && this.isRemoteDevelopmentHost() ? PathUtilities.normalizeUnixPath((String)path) : DiscoveryUtils.normalizeAbsolutePath((String)path);
        } else if (path.length() > 2 && path.charAt(1) == ':') {
            path = DiscoveryUtils.normalizeAbsolutePath((String)path);
        }
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public CompilerFlavor getCompileFlavor() {
        return this.compileFlavor;
    }

    public String getCygwinDrive() {
        return this.cygwinDriveDirectory;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public void dispose() {
        this.systemIncludePathsC.clear();
        this.systemIncludePathsCpp.clear();
        this.systemMacroDefinitionsC.clear();
        this.systemMacroDefinitionsCpp.clear();
        this.normalizedPaths.clear();
        this.normalizedPaths = new ConcurrentHashMap<String, String>();
    }

    private String getCygwinDrive(ProjectBridge bridge) {
        if (bridge != null) {
            return bridge.getCygwinDrive();
        }
        return null;
    }

    private Map<String, String> getSystemMacroDefinitions(ProjectBridge bridge, boolean isCPP) {
        if (bridge != null) {
            return bridge.getSystemMacroDefinitions(isCPP);
        }
        return new HashMap<String, String>();
    }

    private CompilerFlavor getCompilerFlavor(ProjectBridge bridge) {
        if (bridge != null) {
            return bridge.getCompilerFlavor();
        }
        return null;
    }

    private List<String> getSystemIncludePaths(ProjectBridge bridge, boolean isCPP) {
        if (bridge != null) {
            return bridge.getSystemIncludePaths(isCPP);
        }
        return new ArrayList<String>();
    }
}

