/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.execution.ExecutorTask;
import org.openide.util.NbCollections;
import org.openide.util.Parameters;

public final class AntTargetExecutor {
    private final Env env;

    private AntTargetExecutor(Env env) {
        this.env = env;
    }

    public static AntTargetExecutor createTargetExecutor(Env env) {
        return new AntTargetExecutor(env);
    }

    public ExecutorTask execute(AntProjectCookie antProject, String[] targets) throws IOException {
        TargetExecutor te = new TargetExecutor(antProject, targets);
        te.setVerbosity(this.env.getVerbosity());
        te.setProperties(NbCollections.checkedMapByCopy((Map)this.env.getProperties(), String.class, String.class, (boolean)true));
        te.setConcealedProperties(this.env.getConcealedProperties());
        if (this.env.getLogger() == null) {
            return te.execute();
        }
        return te.execute(this.env.getLogger());
    }

    public static final class Env {
        private int verbosity = AntSettings.getVerbosity();
        private Properties properties = new Properties();
        private OutputStream outputStream;
        private volatile Set<String> concealedProperties;

        public Env() {
            this.properties.putAll(AntSettings.getProperties());
            this.concealedProperties = Collections.emptySet();
        }

        public void setVerbosity(int v) {
            this.verbosity = v;
        }

        public int getVerbosity() {
            return this.verbosity;
        }

        public synchronized void setProperties(Properties p) {
            this.properties = (Properties)p.clone();
        }

        public synchronized Properties getProperties() {
            return (Properties)this.properties.clone();
        }

        @Deprecated
        public void setLogger(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public OutputStream getLogger() {
            return this.outputStream;
        }

        public void setConcealedProperties(@NonNull Set<? extends String> properties) {
            Parameters.notNull((CharSequence)"properties", properties);
            this.concealedProperties = Collections.unmodifiableSet(new HashSet<String>(properties));
        }

        @NonNull
        public Set<String> getConcealedProperties() {
            return this.concealedProperties;
        }
    }
}

