/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.networkneighbour;

import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NeighbourHost;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NeighbourHostNode;
import org.netbeans.modules.cnd.remote.ui.networkneighbour.NetworkNeighbourhoodList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

final class NeighbourhoodRootNode
extends AbstractNode {
    private static final NeighbourHost refreshing = new NeighbourHost("*refreshing*", false);
    private final NeighbourhoodChildren children = new NeighbourhoodChildren();

    public NeighbourhoodRootNode() {
        super(Children.LEAF);
        this.setChildren((Children)this.children);
    }

    void refresh(NeighbourHost[] hosts) {
        if (hosts.length == 0) {
            this.children.refreshChildren(new NeighbourHost[]{NeighbourhoodRootNode.refreshing});
        } else {
            this.children.refreshChildren(hosts);
        }
    }

    private static class NeighbourhoodChildren
    extends Children.Keys<NeighbourHost> {
        private final BufferedImage emptyIcon = new BufferedImage(1, 1, 2);

        private NeighbourhoodChildren() {
        }

        protected Node[] createNodes(NeighbourHost host) {
            if (host == refreshing) {
                return new Node[]{new AbstractNode(LEAF){

                    public String getHtmlDisplayName() {
                        return "<html><font color=\"#808080\">" + NbBundle.getMessage(NetworkNeighbourhoodList.class, (String)"NetworkNeighbourhoodList.Refreshing");
                    }

                    public Image getIcon(int type) {
                        return NeighbourhoodChildren.this.emptyIcon;
                    }
                }};
            }
            NeighbourHostNode node = new NeighbourHostNode(host);
            return new Node[]{node};
        }

        private void refreshChildren(final NeighbourHost[] hosts) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setKeys(hosts);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NeighbourhoodChildren.this.setKeys(hosts);
                    }
                });
            }
        }
    }
}

