/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.ui.setup.CreateHostWizardIterator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.remote.ui.HostNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;

public final class HostListRootNode
extends AbstractNode {
    public static final String NODE_NAME = "remote";
    private static final String ICON_BASE = "org/netbeans/modules/remote/ui/servers.png";
    private final Action[] actions;

    public static HostListRootNode getDefault() {
        return new HostListRootNode();
    }

    private HostListRootNode() {
        super(Children.create((ChildFactory)new HostChildren(), (boolean)true));
        this.setName(NODE_NAME);
        this.setDisplayName(NbBundle.getMessage(HostListRootNode.class, (String)"LBL_HostRootNode"));
        this.setIconBaseWithExtension(ICON_BASE);
        this.actions = RemoteStatistics.COLLECT_STATISTICS ? new Action[]{new AddHostAction(), new TraficStatisticsAction()} : new Action[]{new AddHostAction()};
    }

    public Action[] getActions(boolean context) {
        return this.actions;
    }

    public static class AddHostAction
    extends AbstractAction
    implements Runnable {
        private static final RequestProcessor RP = new RequestProcessor("AddHostAction", 1);

        public AddHostAction() {
            super(NbBundle.getMessage(HostListRootNode.class, (String)"AddHostMenuItem"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RP.post((Runnable)this);
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setEnabled(true);
            } else {
                try {
                    this.work();
                }
                finally {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        private void work() {
            ArrayList<ServerRecord> hosts;
            ToolsCacheManager cacheManager = ToolsCacheManager.createInstance((boolean)true);
            ServerRecord newServerRecord = CreateHostWizardIterator.invokeMe(cacheManager);
            if (newServerRecord != null && !(hosts = new ArrayList<ServerRecord>(ServerList.getRecords())).contains(newServerRecord)) {
                hosts.add(newServerRecord);
                cacheManager.setHosts(hosts);
                cacheManager.setDefaultRecord(ServerList.getDefaultRecord());
                cacheManager.applyChanges();
            }
        }
    }

    private static class TraficStatisticsAction
    extends NodeAction {
        public String getName() {
            return NbBundle.getMessage(HostListRootNode.class, (String)"TrafficStatisticsMenuItem");
        }

        protected boolean asynchronous() {
            return false;
        }

        protected boolean enable(Node[] activatedNodes) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected void performAction(Node[] activatedNodes) {
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine("Log file:", "Turn Remote Statistics On");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
                final String inputText = notifyDescriptor.getInputText();
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        RemoteStatistics.startTest((String)inputText, null, (int)0, (int)10000);
                    }
                });
            }
        }
    }

    private static class HostChildren
    extends ChildFactory<ExecutionEnvironment>
    implements PropertyChangeListener,
    Runnable {
        private final RequestProcessor.Task refreshTask;

        public HostChildren() {
            ServerList.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, null));
            this.refreshTask = new RequestProcessor("Refreshing Host List", 1).create((Runnable)this);
        }

        protected boolean createKeys(List<ExecutionEnvironment> toPopulate) {
            for (ExecutionEnvironment env : ServerList.getEnvironments()) {
                toPopulate.add(env);
            }
            return true;
        }

        protected Node createNodeForKey(ExecutionEnvironment key) {
            HostNode node = new HostNode(key);
            return node;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refreshTask.schedule(0);
        }

        @Override
        public void run() {
            this.refresh(true);
        }
    }
}

