/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.highlight.semantic.debug.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.semantic.debug.TestSemanticHighlighting;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class TestSemanticHighlightingAction
extends TestProjectActionBase {
    public static Action getInstance() {
        return (Action)SharedClassObject.findObject(TestSemanticHighlightingAction.class, (boolean)true);
    }

    @Override
    protected void performAction(Collection<CsmProject> projects) {
        if (projects != null) {
            for (CsmProject p : projects) {
                try {
                    this.testProject(p);
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestSemanticHighlighting");
    }

    private void testProject(CsmProject csmProject) {
        String taskName = "Testing Semantic Highlighting - " + csmProject.getName();
        InputOutput io = IOProvider.getDefault().getIO(taskName, false);
        io.select();
        OutputWriter out = io.getOut();
        OutputWriter err = io.getErr();
        final InterrupterImpl interrupter = new InterrupterImpl();
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)taskName, (Cancellable)new Cancellable(){

            public boolean cancel() {
                interrupter.cancel();
                return true;
            }
        });
        handle.start();
        long time = System.currentTimeMillis();
        if (!csmProject.isStable(null)) {
            out.printf("Waiting until the project is parsed", new Object[0]);
            csmProject.waitParse();
        }
        Collection files = csmProject.getAllFiles();
        handle.switchToDeterminate(files.size());
        int processed = 0;
        for (CsmFile file : files) {
            handle.progress(file.getName().toString(), processed++);
            if (interrupter.cancelled()) break;
            this.testFile(file, out, err, interrupter);
        }
        handle.finish();
        out.printf("%s%n", new Object[]{interrupter.cancelled() ? "Cancelled" : "Done"});
        out.printf("%s took %d ms%n", new Object[]{taskName, System.currentTimeMillis() - time});
        err.flush();
        out.flush();
        err.close();
        out.close();
    }

    private void testFile(CsmFile file, OutputWriter out, OutputWriter err, InterrupterImpl interrupter) {
        long time = System.currentTimeMillis();
        out.printf("%nHighlighting file %s    %s%n", new Object[]{file.getName(), file.getAbsolutePath()});
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
        StyledDocument doc = CsmUtilities.openDocument((CloneableEditorSupport)ces);
        List highlights = TestSemanticHighlighting.gethighlightsBagForTests((Document)doc, (InterrupterImpl)interrupter);
        ArrayList<TestSemanticHighlighting.Highlight> sorted = new ArrayList<TestSemanticHighlighting.Highlight>(highlights);
        Collections.sort(sorted, new Comparator<TestSemanticHighlighting.Highlight>(){

            @Override
            public int compare(TestSemanticHighlighting.Highlight o1, TestSemanticHighlighting.Highlight o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        this.reportHighlights(sorted, out);
        out.printf("Highlighting for file %s took %d ms%n", new Object[]{file.getName(), System.currentTimeMillis() - time});
    }

    private void reportHighlights(List<TestSemanticHighlighting.Highlight> highlights, OutputWriter out) {
        int i = 1;
        for (TestSemanticHighlighting.Highlight b : highlights) {
            out.println("Block " + i++ + ":\tPosition " + b.getStartPosition() + "-" + b.getEndPosition() + "\t" + b.getType());
        }
    }
}

