/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.BinaryName;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Convertors;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public class DocumentUtil {
    static final String FIELD_PACKAGE_NAME = "packageName";
    static final String FIELD_SIMPLE_NAME = "simpleName";
    static final String FIELD_CASE_INSENSITIVE_NAME = "ciName";
    static final String FIELD_IDENTS = "ids";
    static final String FIELD_FEATURE_IDENTS = "fids";
    static final String FIELD_CASE_INSENSITIVE_FEATURE_IDENTS = "cifids";
    private static final String FIELD_BINARY_NAME = "binaryName";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_REFERENCES = "references";
    private static final char NO = '-';
    private static final char YES = '+';
    private static final char WILDCARD_QUERY_WILDCARD = '?';
    private static final char REGEX_QUERY_WILDCARD = '.';
    private static final char EK_CLASS = 'C';
    private static final char EK_LOCAL_CLASS = 'c';
    private static final char EK_INTERFACE = 'I';
    private static final char EK_LOCAL_INTERFACE = 'i';
    private static final char EK_ENUM = 'E';
    private static final char EK_LOCAL_ENUM = 'e';
    private static final char EK_ANNOTATION = 'A';
    private static final char EK_LOCAL_ANNOTATION = 'a';
    private static final int SIZE = ClassIndexImpl.UsageType.values().length;

    private DocumentUtil() {
    }

    public static Analyzer createAnalyzer() {
        PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer());
        analyzer.addAnalyzer(FIELD_IDENTS, (Analyzer)new WhitespaceAnalyzer());
        analyzer.addAnalyzer(FIELD_FEATURE_IDENTS, (Analyzer)new WhitespaceAnalyzer());
        analyzer.addAnalyzer(FIELD_CASE_INSENSITIVE_FEATURE_IDENTS, (Analyzer)new LCWhitespaceAnalyzer());
        return analyzer;
    }

    @NonNull
    public static Convertor<Document, FileObject> fileObjectConvertor(@NonNull ClassIndex.ResourceType resourceType, FileObject ... roots) {
        assert (resourceType != null);
        assert (roots != null);
        return new FileObjectConvertor(resourceType, roots);
    }

    public static Convertor<Document, ElementHandle<TypeElement>> elementHandleConvertor() {
        return new ElementHandleConvertor();
    }

    public static Convertor<Document, String> binaryNameConvertor() {
        return new BinaryNameConvertor();
    }

    public static Convertor<Document, String> sourceNameConvertor() {
        return new SourceNameConvertor();
    }

    static Convertor<Pair<Pair<BinaryName, String>, Object[]>, Document> documentConvertor() {
        return new DocumentConvertor();
    }

    static Convertor<Pair<String, String>, Query> queryClassWithEncConvertor(boolean fileBased) {
        return new QueryClassesWithEncConvertor(fileBased);
    }

    static Convertor<Pair<String, String>, Query> queryClassConvertor() {
        return new QueryClassConvertor();
    }

    static String getBinaryName(Document doc) {
        return DocumentUtil.getBinaryName(doc, null);
    }

    static String getBinaryName(Document doc, ElementKind[] kind) {
        assert (doc != null);
        Field pkgField = doc.getField(FIELD_PACKAGE_NAME);
        Field snField = doc.getField(FIELD_BINARY_NAME);
        if (snField == null) {
            return null;
        }
        String tmp = snField.stringValue();
        String snName = tmp.substring(0, tmp.length() - 1);
        if (snName.length() == 0) {
            return null;
        }
        if (kind != null) {
            assert (kind.length == 1);
            kind[0] = DocumentUtil.decodeKind(tmp.charAt(tmp.length() - 1));
        }
        if (pkgField == null) {
            return snName;
        }
        String pkg = pkgField.stringValue();
        if (pkg.length() == 0) {
            return snName;
        }
        return pkg + '.' + snName;
    }

    public static String getSimpleBinaryName(Document doc) {
        assert (doc != null);
        Fieldable field = doc.getFieldable(FIELD_BINARY_NAME);
        if (field == null) {
            return null;
        }
        String binName = field.stringValue();
        return binName.substring(0, binName.length() - 1);
    }

    public static String getSimpleName(Document doc) {
        Fieldable field = doc.getFieldable(FIELD_SIMPLE_NAME);
        return field == null ? null : field.stringValue();
    }

    public static boolean isLocal(@NonNull Document doc) {
        Fieldable fld = doc.getFieldable(FIELD_BINARY_NAME);
        if (fld == null) {
            return false;
        }
        String binName = fld.stringValue();
        switch (binName.charAt(binName.length() - 1)) {
            case 'a': 
            case 'c': 
            case 'e': 
            case 'i': {
                return true;
            }
        }
        return false;
    }

    static String getPackageName(Document doc) {
        assert (doc != null);
        Field field = doc.getField(FIELD_PACKAGE_NAME);
        return field == null ? null : field.stringValue();
    }

    static Query binaryNameQuery(String resourceName) {
        String sName;
        String pkgName;
        BooleanQuery query = new BooleanQuery();
        int index = resourceName.lastIndexOf(46);
        if (index < 0) {
            pkgName = "";
            sName = resourceName;
        } else {
            pkgName = resourceName.substring(0, index);
            sName = resourceName.substring(index + 1);
        }
        sName = sName + '?';
        query.add((Query)new TermQuery(new Term(FIELD_PACKAGE_NAME, pkgName)), BooleanClause.Occur.MUST);
        query.add((Query)new WildcardQuery(new Term(FIELD_BINARY_NAME, sName)), BooleanClause.Occur.MUST);
        return query;
    }

    static Term referencesTerm(String resourceName, Set<? extends ClassIndexImpl.UsageType> usageType, boolean javaRegEx) {
        assert (resourceName != null);
        if (!resourceName.isEmpty()) {
            char[] cArray;
            char wildcard;
            char c = wildcard = javaRegEx ? (char)'.' : '?';
            if (javaRegEx) {
                char[] cArray2 = new char[2];
                cArray2[0] = 92;
                cArray = cArray2;
                cArray2[1] = 43;
            } else {
                char[] cArray3 = new char[1];
                cArray = cArray3;
                cArray3[0] = 43;
            }
            char[] yes = cArray;
            if (usageType != null) {
                resourceName = DocumentUtil.encodeUsage(resourceName, usageType, wildcard, yes).toString();
            } else {
                StringBuilder sb = new StringBuilder(resourceName);
                for (int i = 0; i < SIZE; ++i) {
                    sb.append(wildcard);
                }
                resourceName = sb.toString();
            }
        }
        return new Term(FIELD_REFERENCES, resourceName);
    }

    private static Document createDocument(BinaryName name, List<String> references, String featureIdents, String idents, String source) {
        assert (references != null);
        String pkgName = name.getPackage();
        String fileName = name.getClassNameKind();
        assert (fileName.length() > 1) : "BinaryName with type char: " + name + ", Package: " + pkgName + ", FileName with type char: " + fileName;
        String simpleName = name.getSimpleName();
        String caseInsensitiveName = simpleName.toLowerCase();
        Document doc = new Document();
        Field field = new Field(FIELD_BINARY_NAME, fileName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        doc.add((Fieldable)field);
        field = new Field(FIELD_PACKAGE_NAME, pkgName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        doc.add((Fieldable)field);
        field = new Field(FIELD_SIMPLE_NAME, simpleName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        doc.add((Fieldable)field);
        field = new Field(FIELD_CASE_INSENSITIVE_NAME, caseInsensitiveName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        doc.add((Fieldable)field);
        for (String reference : references) {
            field = new Field(FIELD_REFERENCES, reference, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            doc.add((Fieldable)field);
        }
        if (featureIdents != null) {
            field = new Field(FIELD_FEATURE_IDENTS, featureIdents, Field.Store.NO, Field.Index.ANALYZED_NO_NORMS);
            doc.add((Fieldable)field);
            field = new Field(FIELD_CASE_INSENSITIVE_FEATURE_IDENTS, featureIdents, Field.Store.NO, Field.Index.ANALYZED_NO_NORMS);
            doc.add((Fieldable)field);
        }
        if (idents != null) {
            field = new Field(FIELD_IDENTS, idents, Field.Store.NO, Field.Index.ANALYZED_NO_NORMS);
            doc.add((Fieldable)field);
        }
        if (source != null) {
            field = new Field(FIELD_SOURCE, source, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
            doc.add((Fieldable)field);
        }
        return doc;
    }

    static String encodeUsage(String className, Set<ClassIndexImpl.UsageType> usageTypes) {
        return DocumentUtil.encodeUsage(className, usageTypes, '-', new char[]{'+'}).toString();
    }

    private static StringBuilder encodeUsage(String className, Set<? extends ClassIndexImpl.UsageType> usageTypes, char fill, char[] yes) {
        assert (className != null);
        assert (usageTypes != null);
        StringBuilder builder = new StringBuilder();
        builder.append(className);
        for (ClassIndexImpl.UsageType ut : ClassIndexImpl.UsageType.values()) {
            if (usageTypes.contains((Object)ut)) {
                builder.append(yes);
                continue;
            }
            builder.append(fill);
        }
        return builder;
    }

    static String decodeUsage(String rawUsage, Set<ClassIndexImpl.UsageType> usageTypes) {
        assert (rawUsage != null);
        assert (usageTypes != null);
        assert (usageTypes.isEmpty());
        int rawUsageLen = rawUsage.length();
        assert (rawUsageLen > SIZE);
        int index = rawUsageLen - SIZE;
        String className = rawUsage.substring(0, index);
        String map = rawUsage.substring(index);
        ClassIndexImpl.UsageType[] values = ClassIndexImpl.UsageType.values();
        for (int i = 0; i < values.length; ++i) {
            if (map.charAt(i) != '+') continue;
            usageTypes.add(values[i]);
        }
        return className;
    }

    @NonNull
    static ElementKind decodeKind(char kind) {
        switch (kind) {
            case 'C': 
            case 'c': {
                return ElementKind.CLASS;
            }
            case 'I': 
            case 'i': {
                return ElementKind.INTERFACE;
            }
            case 'E': 
            case 'e': {
                return ElementKind.ENUM;
            }
            case 'A': 
            case 'a': {
                return ElementKind.ANNOTATION_TYPE;
            }
        }
        throw new IllegalArgumentException();
    }

    static char encodeKind(ElementKind kind) {
        return DocumentUtil.encodeKind(kind, false);
    }

    static char encodeKind(@NonNull ElementKind kind, boolean isLocal) {
        switch (kind) {
            case CLASS: {
                return isLocal ? (char)'c' : 'C';
            }
            case INTERFACE: {
                return isLocal ? (char)'i' : 'I';
            }
            case ENUM: {
                return isLocal ? (char)'e' : 'E';
            }
            case ANNOTATION_TYPE: {
                return isLocal ? (char)'a' : 'A';
            }
        }
        throw new IllegalArgumentException();
    }

    public static FieldSelector declaredTypesFieldSelector(boolean includeSource, boolean includeSimpleName) {
        return includeSource ? (includeSimpleName ? Queries.createFieldSelector((String[])new String[]{FIELD_PACKAGE_NAME, FIELD_BINARY_NAME, FIELD_SIMPLE_NAME, FIELD_SOURCE}) : Queries.createFieldSelector((String[])new String[]{FIELD_PACKAGE_NAME, FIELD_BINARY_NAME, FIELD_SOURCE})) : (includeSimpleName ? Queries.createFieldSelector((String[])new String[]{FIELD_PACKAGE_NAME, FIELD_BINARY_NAME, FIELD_SIMPLE_NAME}) : Queries.createFieldSelector((String[])new String[]{FIELD_PACKAGE_NAME, FIELD_BINARY_NAME}));
    }

    static FieldSelector sourceNameFieldSelector() {
        return Queries.createFieldSelector((String[])new String[]{FIELD_SOURCE});
    }

    static Queries.QueryKind translateQueryKind(ClassIndex.NameKind kind) {
        switch (kind) {
            case SIMPLE_NAME: {
                return Queries.QueryKind.EXACT;
            }
            case PREFIX: {
                return Queries.QueryKind.PREFIX;
            }
            case CASE_INSENSITIVE_PREFIX: {
                return Queries.QueryKind.CASE_INSENSITIVE_PREFIX;
            }
            case CAMEL_CASE: {
                return Queries.QueryKind.CAMEL_CASE;
            }
            case CAMEL_CASE_INSENSITIVE: {
                return Queries.QueryKind.CASE_INSENSITIVE_CAMEL_CASE;
            }
            case REGEXP: {
                return Queries.QueryKind.REGEXP;
            }
            case CASE_INSENSITIVE_REGEXP: {
                return Queries.QueryKind.CASE_INSENSITIVE_REGEXP;
            }
        }
        throw new IllegalArgumentException();
    }

    private static class QueryClassConvertor
    implements Convertor<Pair<String, String>, Query> {
        private QueryClassConvertor() {
        }

        public Query convert(Pair<String, String> p) {
            return QueryClassConvertor.binaryNameSourceNamePairQuery(p);
        }

        private static Query binaryNameSourceNamePairQuery(Pair<String, String> binaryNameSourceNamePair) {
            assert (binaryNameSourceNamePair != null);
            String binaryName = (String)binaryNameSourceNamePair.first();
            String sourceName = (String)binaryNameSourceNamePair.second();
            Query query = DocumentUtil.binaryNameQuery(binaryName);
            if (sourceName != null) {
                assert (query instanceof BooleanQuery) : "The DocumentUtil.binaryNameQuery was incompatibly changed!";
                BooleanQuery bq = (BooleanQuery)query;
                bq.add((Query)new TermQuery(new Term(DocumentUtil.FIELD_SOURCE, sourceName)), BooleanClause.Occur.MUST);
            }
            return query;
        }
    }

    private static class QueryClassesWithEncConvertor
    implements Convertor<Pair<String, String>, Query> {
        private final boolean fileBased;

        private QueryClassesWithEncConvertor(boolean fileBased) {
            this.fileBased = fileBased;
        }

        public Query convert(Pair<String, String> p) {
            String resourceName = (String)p.first();
            String sourceName = (String)p.second();
            return this.fileBased ? QueryClassesWithEncConvertor.createClassesInFileQuery(resourceName, sourceName) : QueryClassesWithEncConvertor.createClassWithEnclosedQuery(resourceName, sourceName);
        }

        private static Query createClassWithEnclosedQuery(String resourceName, String sourceName) {
            BooleanQuery query = QueryClassesWithEncConvertor.createFQNQuery(resourceName);
            if (sourceName != null) {
                query.add((Query)new TermQuery(new Term(DocumentUtil.FIELD_SOURCE, sourceName)), BooleanClause.Occur.MUST);
            }
            return query;
        }

        private static Query createClassesInFileQuery(String resourceName, String sourceName) {
            if (sourceName != null) {
                BooleanQuery result = new BooleanQuery();
                result.add((Query)QueryClassesWithEncConvertor.createFQNQuery(FileObjects.convertFolder2Package(FileObjects.stripExtension(sourceName))), BooleanClause.Occur.SHOULD);
                result.add((Query)new TermQuery(new Term(DocumentUtil.FIELD_SOURCE, sourceName)), BooleanClause.Occur.SHOULD);
                return result;
            }
            BooleanQuery result = new BooleanQuery();
            result.add((Query)QueryClassesWithEncConvertor.createFQNQuery(resourceName), BooleanClause.Occur.SHOULD);
            result.add((Query)new TermQuery(new Term(DocumentUtil.FIELD_SOURCE, FileObjects.convertPackage2Folder(resourceName) + '.' + "java")), BooleanClause.Occur.SHOULD);
            return result;
        }

        private static BooleanQuery createFQNQuery(String resourceName) {
            String sName;
            String pkgName;
            int index = resourceName.lastIndexOf(46);
            if (index < 0) {
                pkgName = "";
                sName = resourceName;
            } else {
                pkgName = resourceName.substring(0, index);
                sName = resourceName.substring(index + 1);
            }
            BooleanQuery snQuery = new BooleanQuery();
            snQuery.add((Query)new WildcardQuery(new Term(DocumentUtil.FIELD_BINARY_NAME, sName + '?')), BooleanClause.Occur.SHOULD);
            snQuery.add((Query)new PrefixQuery(new Term(DocumentUtil.FIELD_BINARY_NAME, sName + '$')), BooleanClause.Occur.SHOULD);
            if (pkgName.length() == 0) {
                return snQuery;
            }
            BooleanQuery fqnQuery = new BooleanQuery();
            fqnQuery.add((Query)new TermQuery(new Term(DocumentUtil.FIELD_PACKAGE_NAME, pkgName)), BooleanClause.Occur.MUST);
            fqnQuery.add((Query)snQuery, BooleanClause.Occur.MUST);
            return fqnQuery;
        }
    }

    private static class DocumentConvertor
    implements Convertor<Pair<Pair<BinaryName, String>, Object[]>, Document> {
        private DocumentConvertor() {
        }

        public Document convert(Pair<Pair<BinaryName, String>, Object[]> entry) {
            Pair pair = (Pair)entry.first();
            BinaryName cn = (BinaryName)pair.first();
            String srcName = (String)pair.second();
            Object[] data = (Object[])entry.second();
            List cr = (List)data[0];
            String fids = (String)data[1];
            String ids = (String)data[2];
            return DocumentUtil.createDocument(cn, cr, fids, ids, srcName);
        }
    }

    private static class SourceNameConvertor
    implements Convertor<Document, String> {
        private SourceNameConvertor() {
        }

        public String convert(Document doc) {
            Field field = doc.getField(DocumentUtil.FIELD_SOURCE);
            return field == null ? null : field.stringValue();
        }
    }

    private static class BinaryNameConvertor
    implements Convertor<Document, String> {
        private BinaryNameConvertor() {
        }

        public String convert(Document doc) {
            return DocumentUtil.getBinaryName(doc, null);
        }
    }

    private static class ElementHandleConvertor
    implements Convertor<Document, ElementHandle<TypeElement>> {
        private final ElementKind[] kindHolder = new ElementKind[1];

        private ElementHandleConvertor() {
        }

        public ElementHandle<TypeElement> convert(Document doc) {
            String binaryName = DocumentUtil.getBinaryName(doc, this.kindHolder);
            return binaryName == null ? null : this.convert(this.kindHolder[0], binaryName);
        }

        private ElementHandle<TypeElement> convert(ElementKind kind, String value) {
            return ElementHandleAccessor.getInstance().create(kind, value);
        }
    }

    private static class FileObjectConvertor
    implements Convertor<Document, FileObject> {
        private final Convertor<String, String> nameFactory;
        private final Convertor<FileObject, Boolean> filter;
        private final FileObject[] roots;

        private FileObjectConvertor(@NonNull ClassIndex.ResourceType type, FileObject ... roots) {
            this.nameFactory = FileObjectConvertor.createNameFactory(type);
            this.filter = FileObjectConvertor.createFilter(type);
            this.roots = roots;
        }

        public FileObject convert(Document doc) {
            String binaryName = DocumentUtil.getBinaryName(doc, null);
            return binaryName == null ? null : this.convert(binaryName);
        }

        private FileObject convert(String value) {
            for (FileObject root : this.roots) {
                FileObject result = this.resolveFile(root, value);
                if (result == null) continue;
                return result;
            }
            ClassIndexManager cim = ClassIndexManager.getDefault();
            for (FileObject root : this.roots) {
                try {
                    FileObject result;
                    String sourceName;
                    ClassIndexImpl impl = cim.getUsagesQuery(root.getURL(), true);
                    if (impl == null || (sourceName = impl.getSourceName(value)) == null || (result = root.getFileObject(sourceName)) == null) continue;
                    return result;
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }

        private FileObject resolveFile(FileObject root, String classBinaryName) {
            String name;
            FileObject folder;
            assert (classBinaryName != null);
            int index = (classBinaryName = classBinaryName.replace('.', '/')).lastIndexOf(47);
            if (index < 0) {
                folder = root;
                name = classBinaryName;
            } else {
                assert (index > 0) : classBinaryName;
                assert (index < classBinaryName.length() - 1) : classBinaryName;
                folder = root.getFileObject(classBinaryName.substring(0, index));
                name = classBinaryName.substring(index + 1);
            }
            if (folder == null) {
                return null;
            }
            name = (String)this.nameFactory.convert((Object)name);
            for (FileObject child : folder.getChildren()) {
                if (!name.equals(child.getName()) || !((Boolean)this.filter.convert((Object)child)).booleanValue()) continue;
                return child;
            }
            return null;
        }

        @NonNull
        private static Convertor<FileObject, Boolean> createFilter(@NonNull ClassIndex.ResourceType type) {
            switch (type) {
                case SOURCE: {
                    return new Convertor<FileObject, Boolean>(){

                        public Boolean convert(FileObject p) {
                            return "java".equalsIgnoreCase(p.getExt());
                        }
                    };
                }
                case BINARY: {
                    return new Convertor<FileObject, Boolean>(){

                        public Boolean convert(FileObject p) {
                            return "class".equalsIgnoreCase(p.getExt());
                        }
                    };
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)type));
        }

        @NonNull
        private static Convertor<String, String> createNameFactory(@NonNull ClassIndex.ResourceType type) {
            switch (type) {
                case SOURCE: {
                    return new Convertor<String, String>(){

                        public String convert(String p) {
                            int index = p.indexOf(36);
                            if (index > 0) {
                                p = p.substring(0, index);
                            }
                            return p;
                        }
                    };
                }
                case BINARY: {
                    return Convertors.identity();
                }
            }
            throw new IllegalArgumentException(String.valueOf((Object)type));
        }
    }

    static final class LCWhitespaceAnalyzer
    extends Analyzer {
        LCWhitespaceAnalyzer() {
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LCWhitespaceTokenizer(reader);
        }
    }

    private static class LCWhitespaceTokenizer
    extends CharTokenizer {
        LCWhitespaceTokenizer(Reader r) {
            super(r);
        }

        protected boolean isTokenChar(int c) {
            return !Character.isWhitespace(c);
        }

        protected char normalize(char c) {
            return Character.toLowerCase(c);
        }
    }
}

