/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.installer.infra.build.ant.utils.Utils;

public class GroupDescriptor
extends Task {
    private File file;

    public void setFile(String path) {
        this.file = new File(path);
        if (!this.file.equals(this.file.getAbsoluteFile())) {
            this.file = new File(this.getProject().getBaseDir(), path);
        }
    }

    public void execute() throws BuildException {
        Utils.setProject(this.getProject());
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<registry xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"registry.xsd\">\n");
        xml.append("    <components>\n");
        String uid = this.get("group.uid");
        String offset = this.get("group.offset");
        String expand = this.get("group.expand");
        String visible = this.get("group.visible");
        xml.append("        <group uid=\"" + uid + "\" " + "offset=\"" + offset + "\" " + "expand=\"" + expand + "\" " + "built=\"" + new Date().getTime() + "\" " + "visible=\"" + visible + "\">\n");
        String locales = this.get("group.locales.list").trim();
        String displayName = this.get("group.display.name.default");
        xml.append("            <display-name>\n");
        xml.append("                <default><![CDATA[" + Utils.toAscii(displayName) + "]]></default>\n");
        if (!locales.equals("")) {
            for (String locale : locales.split(" ")) {
                displayName = this.get("group.display.name." + locale);
                if (displayName == null) continue;
                xml.append("                <localized locale=\"" + locale + "\"><![CDATA[" + Utils.toAscii(displayName) + "]]></localized>\n");
            }
        }
        xml.append("            </display-name>\n");
        String description = this.get("group.description.default");
        xml.append("            <description>\n");
        xml.append("                <default><![CDATA[" + Utils.toAscii(description) + "]]></default>\n");
        if (!locales.equals("")) {
            for (String locale : locales.split(" ")) {
                description = this.get("group.description." + locale);
                if (description == null) continue;
                xml.append("                <localized locale=\"" + locale + "\"><![CDATA[" + Utils.toAscii(description) + "]]></localized>\n");
            }
        }
        xml.append("            </description>\n");
        String size = this.get("group.icon.size");
        String md5 = this.get("group.icon.md5");
        String uri = this.get("group.icon.correct.uri");
        xml.append("            <icon size=\"" + size + "\" " + "md5=\"" + md5 + "\">\n");
        xml.append("                <default-uri>" + uri.replace(" ", "%20") + "</default-uri>\n");
        xml.append("            </icon>\n");
        int length = Integer.parseInt(this.get("group.properties.length"));
        if (length > 0) {
            xml.append("            <properties>\n");
            for (int i = 1; i <= length; ++i) {
                String name = this.get("group.properties." + i + ".name");
                String value = this.get("group.properties." + i + ".value");
                xml.append("                <property name=\"" + name + "\">" + value + "</property>\n");
            }
            xml.append("            </properties>\n");
        }
        xml.append("        </group>\n");
        xml.append("    </components>\n");
        xml.append("</registry>\n");
        try {
            Utils.write(this.file, xml);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String get(String name) {
        return Utils.resolveProperty(this.getProject().getProperty(name));
    }
}

