/*
 * Decompiled with CFR 0.152.
 */
package org.clang.tools.services.impl;

import java.util.Map;
import org.clang.basic.LangOptions;
import org.clang.frontend.CompilerInvocation;
import org.clang.frontend.InputKind;
import org.clang.frontend.LangStandard;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.PreprocessorOptions;
import org.clang.lex.frontend.IncludeDirGroup;
import org.clang.tools.services.ClankCompilationDataBase;
import org.clang.tools.services.impl.PreprocessorInitializer;
import org.clang.tools.services.support.ClangUtilities;
import org.clank.java.std;
import org.clank.support.NativePointer;
import org.llvm.adt.StringRef;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.raw_ostream;

public class AdvancedPreprocessorInitializer
extends PreprocessorInitializer {
    private final ClankCompilationDataBase.Entry compileEntry;
    private final boolean TRACE = false;
    private final Map<String, MemoryBuffer> remappedBuffers;
    private static final String FRAMEWORK_POSTIFX = "/Frameworks";

    public AdvancedPreprocessorInitializer(String TokenCache, ClankCompilationDataBase.Entry entry, String triple, raw_ostream llvm_err, Map<String, MemoryBuffer> remappedBuffers) {
        super(TokenCache, llvm_err, triple, entry.getFileSystem());
        this.compileEntry = entry;
        this.remappedBuffers = remappedBuffers;
    }

    @Override
    protected LangOptions createLangOptions() {
        LangOptions opts = super.createLangOptions();
        opts.Digraphs = true;
        opts.Trigraphs = true;
        opts.LineComment = true;
        CompilerInvocation.setLangDefaults((LangOptions)opts, (InputKind)this.compileEntry.getLanguage(), (LangStandard.Kind)this.compileEntry.getLangStandard());
        return opts;
    }

    @Override
    protected HeaderSearchOptions createHeaderSearchOptions() {
        StringRef strPath;
        HeaderSearchOptions options = super.createHeaderSearchOptions();
        CharSequence sysRoot = this.compileEntry.getSysRoot();
        if (sysRoot != null && sysRoot.length() > 0) {
            options.Sysroot = new std.string(sysRoot);
        }
        for (ClankCompilationDataBase.IncludePath Path : this.compileEntry.getUserIncludePaths()) {
            strPath = new StringRef(NativePointer.create_char$ptr_utf8((CharSequence)Path.getPath()));
            options.AddPath(strPath, IncludeDirGroup.Angled, Path.isFramework(), Path.ignoreSysRoot());
        }
        for (ClankCompilationDataBase.IncludePath Path : this.compileEntry.getPredefinedSystemIncludePaths()) {
            strPath = new StringRef(NativePointer.create_char$ptr_utf8((CharSequence)Path.getPath()));
            options.AddPath(strPath, IncludeDirGroup.System, Path.isFramework(), Path.ignoreSysRoot());
            options.AddSystemHeaderPrefix(strPath, true);
        }
        CharSequence absPathLookupPrefix = this.compileEntry.getAbsPathLookupPrefix();
        options.AbsPathLookupPrefix = absPathLookupPrefix != null && absPathLookupPrefix.length() > 0 ? new std.string(this.compileEntry.getAbsPathLookupPrefix()) : std.string.EMPTY;
        return options;
    }

    @Override
    protected PreprocessorOptions createPreprocessorOptions() {
        PreprocessorOptions out = super.createPreprocessorOptions();
        for (CharSequence charSequence : this.compileEntry.getIncludeFiles()) {
            out.Includes.push_back(charSequence);
        }
        for (String string2 : this.compileEntry.getSystemMacroDefines()) {
            out.addMacroDef(new StringRef(string2));
        }
        for (String string3 : this.compileEntry.getUserMacroDefines()) {
            out.addMacroDef(new StringRef(string3));
        }
        if (this.remappedBuffers != null && !this.remappedBuffers.isEmpty()) {
            out.RetainRemappedFileBuffers = true;
            for (Map.Entry entry : this.remappedBuffers.entrySet()) {
                out.addRemappedFile(ClangUtilities.createPathStringRef((CharSequence)entry.getKey()), (MemoryBuffer)entry.getValue());
            }
        }
        return out;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }
}

