/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.BasicClangGlobals;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;

public class ParseHelper {
    public char.ptr Begin;
    public char.ptr End;
    public char.ptr C;
    public char.ptr P;
    private char.ptr PEnd;

    public ParseHelper(StringRef S) {
        this.Begin = Native.$tryClone((char.ptr)S.begin());
        this.End = Native.$tryClone((char.ptr)S.end());
        this.C = Native.$tryClone((char.ptr)this.Begin);
        this.P = Native.$tryClone((char.ptr)this.Begin);
        this.PEnd = null;
    }

    public boolean Next(StringRef S) {
        this.P = Native.$tryClone((char.ptr)this.C);
        this.PEnd = Native.$tryClone((char.ptr)((char.ptr)this.C.$add(S.size())));
        if (this.PEnd.$greater((Object)this.End)) {
            return false;
        }
        return std.memcmp((char.ptr)this.P, (char.ptr)S.data(), (int)S.size()) == 0;
    }

    public boolean Next(uint.ref N) {
        int TMP = 0;
        this.P = Native.$tryClone((char.ptr)this.C);
        while (this.P.$less((Object)this.End) && this.P.$at(0) >= NativePointer.$((char)'0') && this.P.$at(0) <= NativePointer.$((char)'9')) {
            TMP *= 10;
            TMP += this.P.$at(0) - NativePointer.$((char)'0');
            this.P.$preInc();
        }
        if (this.P.$eq((Object)this.C)) {
            return false;
        }
        this.PEnd = Native.$tryClone((char.ptr)this.P);
        N.$set(TMP);
        return true;
    }

    public boolean Search(StringRef S) {
        return this.Search(S, false);
    }

    public boolean Search(StringRef S, boolean EnsureStartOfWord) {
        do {
            this.P = Native.$tryClone((char.ptr)((char.ptr)std.search((char.iterator)this.C, (char.iterator)this.End, (char.iterator)S.begin(), (char.iterator)S.end())));
            this.PEnd = Native.$tryClone((char.ptr)((char.ptr)this.P.$add(S.size())));
            if (this.P.$eq((Object)this.End)) break;
            if (EnsureStartOfWord && !this.P.$eq((Object)this.Begin) && !BasicClangGlobals.isWhitespace((byte)this.P.$at(-1)) && (!this.P.$greater((Object)this.Begin.$add(1)) || this.P.$at(-1) != NativePointer.$((char)'/') && this.P.$at(-1) != NativePointer.$((char)'*') || this.P.$at(-2) != NativePointer.$((char)'/'))) continue;
            return true;
        } while (this.Advance());
        return false;
    }

    public boolean SearchClosingBrace(StringRef OpenBrace, StringRef CloseBrace) {
        int Depth = 1;
        this.P = Native.$tryClone((char.ptr)this.C);
        while (this.P.$less((Object)this.End)) {
            StringRef S = new StringRef(Native.$tryClone((char.ptr)this.P), this.End.$sub((abstract_iterator)this.P));
            if (S.startswith(OpenBrace)) {
                ++Depth;
                this.P.$inc(OpenBrace.size());
                continue;
            }
            if (S.startswith(CloseBrace)) {
                if (--Depth == 0) {
                    this.PEnd = Native.$tryClone((char.ptr)((char.ptr)this.P.$add(CloseBrace.size())));
                    return true;
                }
                this.P.$inc(CloseBrace.size());
                continue;
            }
            this.P.$preInc();
        }
        return false;
    }

    public boolean Advance() {
        this.C = Native.$tryClone((char.ptr)this.PEnd);
        return this.C.$less((Object)this.End);
    }

    public void SkipWhitespace() {
        while (this.C.$less((Object)this.End) && BasicClangGlobals.isWhitespace((byte)this.C.$star())) {
            this.C.$preInc();
        }
    }

    public boolean Done() {
        return !this.C.$less((Object)this.End);
    }

    public String toString() {
        return "Begin=" + this.Begin + ", End=" + this.End + ", C=" + this.C + ", P=" + this.P + ", PEnd=" + this.PEnd;
    }
}

