/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.git.remote.cli.GitBlameResult;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitCherryPickResult;
import org.netbeans.modules.git.remote.cli.GitClassFactoryImpl;
import org.netbeans.modules.git.remote.cli.GitClientCallback;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitMergeResult;
import org.netbeans.modules.git.remote.cli.GitPullResult;
import org.netbeans.modules.git.remote.cli.GitPushResult;
import org.netbeans.modules.git.remote.cli.GitRebaseResult;
import org.netbeans.modules.git.remote.cli.GitRefUpdateResult;
import org.netbeans.modules.git.remote.cli.GitRemoteConfig;
import org.netbeans.modules.git.remote.cli.GitRepository;
import org.netbeans.modules.git.remote.cli.GitRepositoryState;
import org.netbeans.modules.git.remote.cli.GitRevertResult;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitStatus;
import org.netbeans.modules.git.remote.cli.GitSubmoduleStatus;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.cli.GitTransportUpdate;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.cli.SearchCriteria;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.AddCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.BlameCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CatCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CheckoutIndexCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CheckoutRevisionCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CherryPickCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CleanCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CompareCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ConflictCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CopyCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CreateBranchCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.CreateTagCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.DeleteBranchCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.DeleteTagCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ExportCommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ExportDiffCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.FetchCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GetCommonAncestorCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GetPreviousCommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GetRemotesCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.IgnoreCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.InitRepositoryCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListBranchCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListModifiedIndexEntriesCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListRemoteBranchesCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListRemoteTagsCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListTagCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.LogCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.MergeCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.PullCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.PushCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.RebaseCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.RemoveCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.RemoveRemoteCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.RenameCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ResetCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ResolveCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.RevertCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.SetRemoteCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.SetUpstreamBranchCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StashApplyCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StashDropCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StashListCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StashSaveCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.StatusCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.SubmoduleInitializeCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.SubmoduleStatusCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.SubmoduleUpdateCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.UnignoreCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.UpdateRefCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.cli.progress.RevisionInfoListener;
import org.netbeans.modules.git.remote.cli.progress.StatusListener;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitClient {
    private final DelegateListener delegateListener;
    private GitClassFactory gitFactory;
    public static final String WORKING_TREE = "WORKING_TREE";
    public static final String INDEX = "INDEX";
    private final JGitRepository gitRepository;
    private final Set<NotificationListener> listeners;
    private final Set<ProgressMonitor> pmListeners;

    GitClient(JGitRepository gitRepository) throws GitException {
        this.gitRepository = gitRepository;
        this.listeners = new HashSet<NotificationListener>();
        this.pmListeners = new HashSet<ProgressMonitor>();
        this.delegateListener = new DelegateListener();
        gitRepository.increaseClientUsage();
    }

    public void add(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        AddCommand cmd = new AddCommand(this.gitRepository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener) {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
            if (listener instanceof ProgressMonitor) {
                this.pmListeners.add((ProgressMonitor)((Object)listener));
            }
        }
    }

    public GitBlameResult blame(VCSFileProxy file, String revision, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        BlameCommand cmd = new BlameCommand(this.gitRepository, this.getClassFactory(), file, revision, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public boolean catFile(VCSFileProxy file, String revision, OutputStream out, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        CatCommand cmd = new CatCommand(this.gitRepository, this.getClassFactory(), file, revision, out, monitor);
        cmd.execute();
        return cmd.foundInRevision();
    }

    public boolean catIndexEntry(VCSFileProxy file, int stage, OutputStream out, ProgressMonitor monitor) throws GitException {
        CatCommand cmd = new CatCommand(this.gitRepository, this.getClassFactory(), file, stage, out, monitor);
        cmd.execute();
        return cmd.foundInRevision();
    }

    public void checkout(VCSFileProxy[] roots, String revision, boolean recursively, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        GitCommand cmd;
        if (revision != null) {
            cmd = new ResetCommand(this.gitRepository, this.getClassFactory(), revision, roots, recursively, monitor, this.delegateListener);
            cmd.execute();
        }
        if (!monitor.isCanceled()) {
            cmd = new CheckoutIndexCommand(this.gitRepository, this.getClassFactory(), roots, recursively, monitor, this.delegateListener);
            cmd.execute();
        }
    }

    public void checkoutRevision(String revision, boolean failOnConflict, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        CheckoutRevisionCommand cmd = new CheckoutRevisionCommand(this.gitRepository, this.getClassFactory(), revision, failOnConflict, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitCherryPickResult cherryPick(CherryPickOperation operation, String[] revisions, ProgressMonitor monitor) throws GitException {
        CherryPickCommand cmd = new CherryPickCommand(this.gitRepository, this.getClassFactory(), revisions, operation, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getResult();
    }

    public void clean(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        CleanCommand cmd = new CleanCommand(this.gitRepository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitRevisionInfo commit(VCSFileProxy[] roots, String commitMessage, GitUser author, GitUser commiter, ProgressMonitor monitor) throws GitException {
        return this.commit(roots, commitMessage, author, commiter, false, monitor);
    }

    public GitRevisionInfo commit(VCSFileProxy[] roots, String commitMessage, GitUser author, GitUser commiter, boolean amend, ProgressMonitor monitor) throws GitException {
        CommitCommand cmd = new CommitCommand(this.gitRepository, this.getClassFactory(), roots, commitMessage, author, commiter, amend, monitor);
        cmd.execute();
        return cmd.revision;
    }

    public void copyAfter(VCSFileProxy source, VCSFileProxy target, ProgressMonitor monitor) throws GitException {
        CopyCommand cmd = new CopyCommand(this.gitRepository, this.getClassFactory(), source, target, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitBranch createBranch(String branchName, String revision, ProgressMonitor monitor) throws GitException {
        CreateBranchCommand cmd = new CreateBranchCommand(this.gitRepository, this.getClassFactory(), branchName, revision, monitor);
        cmd.execute();
        return cmd.getBranch();
    }

    public GitTag createTag(String tagName, String taggedObject, String message, boolean signed, boolean forceUpdate, ProgressMonitor monitor) throws GitException {
        CreateTagCommand cmd = new CreateTagCommand(this.gitRepository, this.getClassFactory(), tagName, taggedObject, message, signed, forceUpdate, monitor);
        cmd.execute();
        return cmd.getTag();
    }

    public void deleteBranch(String branchName, boolean forceDeleteUnmerged, ProgressMonitor monitor) throws GitException.NotMergedException, GitException {
        DeleteBranchCommand cmd = new DeleteBranchCommand(this.gitRepository, this.getClassFactory(), branchName, forceDeleteUnmerged, monitor);
        cmd.execute();
    }

    public void deleteTag(String tagName, ProgressMonitor monitor) throws GitException {
        DeleteTagCommand cmd = new DeleteTagCommand(this.gitRepository, this.getClassFactory(), tagName, monitor);
        cmd.execute();
    }

    public void exportCommit(String commit, OutputStream out, ProgressMonitor monitor) throws GitException {
        ExportCommitCommand cmd = new ExportCommitCommand(this.gitRepository, this.getClassFactory(), commit, out, monitor, this.delegateListener);
        cmd.execute();
    }

    public void exportDiff(VCSFileProxy[] roots, DiffMode mode, OutputStream out, ProgressMonitor monitor) throws GitException {
        switch (mode) {
            case HEAD_VS_INDEX: {
                this.exportDiff(roots, "HEAD", INDEX, out, monitor);
                break;
            }
            case HEAD_VS_WORKINGTREE: {
                this.exportDiff(roots, "HEAD", WORKING_TREE, out, monitor);
                break;
            }
            case INDEX_VS_WORKINGTREE: {
                this.exportDiff(roots, INDEX, WORKING_TREE, out, monitor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown diff mode: " + (Object)((Object)mode));
            }
        }
    }

    public void exportDiff(VCSFileProxy[] roots, String commitBase, String commitOther, OutputStream out, ProgressMonitor monitor) throws GitException {
        ExportDiffCommand cmd = new ExportDiffCommand(this.gitRepository, this.getClassFactory(), roots, commitBase, commitOther, out, monitor, this.delegateListener);
        cmd.execute();
    }

    public Map<String, GitTransportUpdate> fetch(String remote, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        FetchCommand cmd = new FetchCommand(this.gitRepository, this.getClassFactory(), remote, monitor);
        cmd.execute();
        return cmd.getUpdates();
    }

    public Map<String, GitTransportUpdate> fetch(String remote, List<String> fetchRefSpecifications, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        FetchCommand cmd = new FetchCommand(this.gitRepository, this.getClassFactory(), remote, fetchRefSpecifications, monitor);
        cmd.execute();
        return cmd.getUpdates();
    }

    public Map<String, GitBranch> getBranches(boolean all, ProgressMonitor monitor) throws GitException {
        ListBranchCommand cmd = new ListBranchCommand(this.gitRepository, this.getClassFactory(), all, monitor);
        cmd.execute();
        return cmd.getBranches();
    }

    public Map<String, GitTag> getTags(ProgressMonitor monitor, boolean allTags) throws GitException {
        ListTagCommand cmd = new ListTagCommand(this.gitRepository, this.getClassFactory(), allTags, monitor, null);
        cmd.execute();
        return cmd.getTags();
    }

    public GitRevisionInfo getCommonAncestor(String[] revisions, ProgressMonitor monitor) throws GitException {
        GetCommonAncestorCommand cmd = new GetCommonAncestorCommand(this.gitRepository, this.getClassFactory(), revisions, monitor);
        cmd.execute();
        return cmd.getRevision();
    }

    public GitRevisionInfo getPreviousRevision(VCSFileProxy file, String revision, ProgressMonitor monitor) throws GitException {
        GetPreviousCommitCommand cmd = new GetPreviousCommitCommand(this.gitRepository, this.getClassFactory(), file, revision, monitor);
        cmd.execute();
        return cmd.getRevision();
    }

    public Map<VCSFileProxy, GitStatus> getConflicts(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        ConflictCommand cmd = new ConflictCommand(this.gitRepository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getStatuses();
    }

    public Map<VCSFileProxy, GitStatus> getStatus(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        return this.getStatus(roots, "HEAD", monitor);
    }

    public Map<VCSFileProxy, GitStatus> getStatus(VCSFileProxy[] roots, String revision, ProgressMonitor monitor) throws GitException {
        StatusCommand cmd = new StatusCommand(this.gitRepository, revision == null ? "HEAD" : revision, roots, this.getClassFactory(), monitor, this.delegateListener);
        cmd.execute();
        return cmd.getStatuses();
    }

    public Map<VCSFileProxy, GitRevisionInfo.GitFileInfo> getStatus(VCSFileProxy[] roots, String revisionFirst, String revisionSecond, ProgressMonitor monitor) throws GitException {
        CompareCommand cmd = new CompareCommand(this.gitRepository, revisionFirst, revisionSecond, roots, this.getClassFactory(), monitor);
        cmd.execute();
        return cmd.getFileDifferences();
    }

    public Map<VCSFileProxy, GitSubmoduleStatus> getSubmoduleStatus(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        SubmoduleStatusCommand cmd = new SubmoduleStatusCommand(this.gitRepository, this.getClassFactory(), roots, monitor);
        cmd.execute();
        return cmd.getStatuses();
    }

    public GitRemoteConfig getRemote(String remoteName, ProgressMonitor monitor) throws GitException {
        return this.getRemotes(monitor).get(remoteName);
    }

    public Map<String, GitRemoteConfig> getRemotes(ProgressMonitor monitor) throws GitException {
        GetRemotesCommand cmd = new GetRemotesCommand(this.gitRepository, this.getClassFactory(), monitor);
        cmd.execute();
        return cmd.getRemotes();
    }

    public GitRepositoryState getRepositoryState(ProgressMonitor monitor) throws GitException {
        JGitConfig config = this.gitRepository.getConfig();
        boolean bare = config.getBoolean("core", null, "bare", false);
        if (bare) {
            return GitRepositoryState.BARE;
        }
        if (VCSFileProxy.createFileProxy((VCSFileProxy)this.gitRepository.getLocation(), (String)".git/rebase-apply").exists()) {
            return GitRepositoryState.REBASING;
        }
        if (VCSFileProxy.createFileProxy((VCSFileProxy)this.gitRepository.getLocation(), (String)".git/rebase-merge").exists()) {
            return GitRepositoryState.REBASING;
        }
        if (VCSFileProxy.createFileProxy((VCSFileProxy)this.gitRepository.getLocation(), (String)".git/MERGE_HEAD").exists()) {
            return GitRepositoryState.MERGING;
        }
        if (VCSFileProxy.createFileProxy((VCSFileProxy)this.gitRepository.getLocation(), (String)".git/CHERRY_PICK_HEAD").exists()) {
            return GitRepositoryState.CHERRY_PICKING;
        }
        return GitRepositoryState.SAFE;
    }

    public GitUser getUser() throws GitException {
        return this.getClassFactory().createUser("user", "user@git.com");
    }

    public VCSFileProxy[] ignore(VCSFileProxy[] files, ProgressMonitor monitor) throws GitException {
        IgnoreCommand cmd = new IgnoreCommand(this.gitRepository, this.getClassFactory(), files, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getModifiedIgnoreFiles();
    }

    public void init(ProgressMonitor monitor) throws GitException {
        InitRepositoryCommand cmd = new InitRepositoryCommand(this.gitRepository, this.getClassFactory(), false, monitor);
        cmd.execute();
    }

    public void initBare(ProgressMonitor monitor) throws GitException {
        InitRepositoryCommand cmd = new InitRepositoryCommand(this.gitRepository, this.getClassFactory(), true, monitor);
        cmd.execute();
    }

    public Map<VCSFileProxy, GitSubmoduleStatus> initializeSubmodules(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        SubmoduleInitializeCommand cmd = new SubmoduleInitializeCommand(this.gitRepository, this.getClassFactory(), roots, monitor);
        cmd.execute();
        return cmd.getStatuses();
    }

    public VCSFileProxy[] listModifiedIndexEntries(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        ListModifiedIndexEntriesCommand cmd = new ListModifiedIndexEntriesCommand(this.gitRepository, this.getClassFactory(), roots, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getFiles();
    }

    public Map<String, GitBranch> listRemoteBranches(String remoteRepositoryUrl, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        ListRemoteBranchesCommand cmd = new ListRemoteBranchesCommand(this.gitRepository, this.getClassFactory(), remoteRepositoryUrl, monitor);
        cmd.execute();
        return cmd.getBranches();
    }

    public Map<String, String> listRemoteTags(String remoteRepositoryUrl, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        ListRemoteTagsCommand cmd = new ListRemoteTagsCommand(this.gitRepository, this.getClassFactory(), remoteRepositoryUrl, monitor);
        cmd.execute();
        return cmd.getTags();
    }

    public GitRevisionInfo log(String revision, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        LogCommand cmd = new LogCommand(this.gitRepository, this.getClassFactory(), revision, monitor, this.delegateListener);
        cmd.execute();
        GitRevisionInfo[] revisions = cmd.getRevisions();
        return revisions.length == 0 ? null : revisions[0];
    }

    public GitRevisionInfo[] log(SearchCriteria searchCriteria, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        return this.log(searchCriteria, false, monitor);
    }

    public GitRevisionInfo[] log(SearchCriteria searchCriteria, boolean fetchBranchInfo, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        LogCommand cmd = new LogCommand(this.gitRepository, this.getClassFactory(), searchCriteria, fetchBranchInfo, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getRevisions();
    }

    public GitMergeResult merge(String revision, ProgressMonitor monitor) throws GitException.CheckoutConflictException, GitException {
        return this.merge(revision, null, monitor);
    }

    public GitMergeResult merge(String revision, GitRepository.FastForwardOption fastForward, ProgressMonitor monitor) throws GitException.CheckoutConflictException, GitException {
        MergeCommand cmd = new MergeCommand(this.gitRepository, this.getClassFactory(), revision, fastForward, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public GitPullResult pull(String remote, List<String> fetchRefSpecifications, String branchToMerge, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException.CheckoutConflictException, GitException.MissingObjectException, GitException {
        PullCommand cmd = new PullCommand(this.gitRepository, this.getClassFactory(), remote, fetchRefSpecifications, branchToMerge, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public GitPushResult push(String remote, List<String> pushRefSpecifications, List<String> fetchRefSpecifications, ProgressMonitor monitor) throws GitException.AuthorizationException, GitException {
        PushCommand cmd = new PushCommand(this.gitRepository, this.getClassFactory(), remote, pushRefSpecifications, fetchRefSpecifications, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public GitRebaseResult rebase(RebaseOperationType operation, String revision, ProgressMonitor monitor) throws GitException {
        RebaseCommand cmd = new RebaseCommand(this.gitRepository, this.getClassFactory(), revision, operation, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public void release() {
        this.gitRepository.decreaseClientUsage();
    }

    public void remove(VCSFileProxy[] roots, boolean cached, ProgressMonitor monitor) throws GitException {
        RemoveCommand cmd = new RemoveCommand(this.gitRepository, this.getClassFactory(), roots, cached, monitor, this.delegateListener);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener) {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            this.pmListeners.remove(listener);
        }
    }

    public void removeRemote(String remote, ProgressMonitor monitor) throws GitException {
        RemoveRemoteCommand cmd = new RemoveRemoteCommand(this.gitRepository, this.getClassFactory(), remote, monitor);
        cmd.execute();
    }

    public void rename(VCSFileProxy source, VCSFileProxy target, boolean after, ProgressMonitor monitor) throws GitException {
        RenameCommand cmd = new RenameCommand(this.gitRepository, this.getClassFactory(), source, target, after, monitor, this.delegateListener);
        cmd.execute();
    }

    public void reset(VCSFileProxy[] roots, String revision, boolean recursively, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        ResetCommand cmd = new ResetCommand(this.gitRepository, this.getClassFactory(), revision, roots, recursively, monitor, this.delegateListener);
        cmd.execute();
    }

    public void reset(String revision, ResetType resetType, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        ResetCommand cmd = new ResetCommand(this.gitRepository, this.getClassFactory(), revision, resetType, monitor, this.delegateListener);
        cmd.execute();
    }

    public GitRevertResult revert(String revision, String commitMessage, boolean commit, ProgressMonitor monitor) throws GitException.MissingObjectException, GitException.CheckoutConflictException, GitException {
        RevertCommand cmd = new RevertCommand(this.gitRepository, this.getClassFactory(), revision, commitMessage, commit, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public void setCallback(GitClientCallback callback) {
    }

    public void setRemote(GitRemoteConfig remoteConfig, ProgressMonitor monitor) throws GitException {
        SetRemoteCommand cmd = new SetRemoteCommand(this.gitRepository, this.getClassFactory(), remoteConfig, monitor);
        cmd.execute();
    }

    public GitBranch setUpstreamBranch(String localBranchName, String remoteBranch, ProgressMonitor monitor) throws GitException {
        SetUpstreamBranchCommand cmd = new SetUpstreamBranchCommand(this.gitRepository, this.getClassFactory(), localBranchName, remoteBranch, monitor);
        cmd.execute();
        return cmd.getTrackingBranch();
    }

    public void stashApply(int stashIndex, boolean dropStash, ProgressMonitor monitor) throws GitException {
        StashApplyCommand cmd = new StashApplyCommand(this.gitRepository, this.getClassFactory(), stashIndex, monitor);
        cmd.execute();
        if (dropStash) {
            this.stashDrop(stashIndex, monitor);
        }
    }

    public void stashDropAll(ProgressMonitor monitor) throws GitException {
        StashDropCommand cmd = new StashDropCommand(this.gitRepository, this.getClassFactory(), -1, true, monitor);
        cmd.execute();
    }

    public void stashDrop(int stashIndex, ProgressMonitor monitor) throws GitException {
        StashDropCommand cmd = new StashDropCommand(this.gitRepository, this.getClassFactory(), stashIndex, false, monitor);
        cmd.execute();
    }

    public GitRevisionInfo[] stashList(ProgressMonitor monitor) throws GitException {
        StashListCommand cmd = new StashListCommand(this.gitRepository, this.getClassFactory(), monitor, this.delegateListener);
        cmd.execute();
        return cmd.getRevisions();
    }

    public GitRevisionInfo stashSave(String message, boolean includeUntracked, ProgressMonitor monitor) throws GitException {
        StashSaveCommand cmd = new StashSaveCommand(this.gitRepository, this.getClassFactory(), message, includeUntracked, monitor);
        cmd.execute();
        return cmd.getStashedCommit();
    }

    public VCSFileProxy[] unignore(VCSFileProxy[] files, ProgressMonitor monitor) throws GitException {
        UnignoreCommand cmd = new UnignoreCommand(this.gitRepository, this.getClassFactory(), files, monitor, this.delegateListener);
        cmd.execute();
        return cmd.getModifiedIgnoreFiles();
    }

    public GitRefUpdateResult updateReference(String referenceName, String newId, ProgressMonitor monitor) throws GitException {
        UpdateRefCommand cmd = new UpdateRefCommand(this.gitRepository, this.getClassFactory(), referenceName, newId, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    public Map<VCSFileProxy, GitSubmoduleStatus> updateSubmodules(VCSFileProxy[] roots, ProgressMonitor monitor) throws GitException {
        SubmoduleUpdateCommand cmd = new SubmoduleUpdateCommand(this.gitRepository, this.getClassFactory(), roots, monitor);
        cmd.execute();
        return cmd.getStatuses();
    }

    public GitRevisionInfo resolve(String name, ProgressMonitor monitor) throws GitException {
        ResolveCommand cmd = new ResolveCommand(this.gitRepository, this.getClassFactory(), name, monitor);
        cmd.execute();
        return cmd.getResult();
    }

    private GitClassFactory getClassFactory() {
        if (this.gitFactory == null) {
            this.gitFactory = GitClassFactoryImpl.getInstance();
        }
        return this.gitFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFile(VCSFileProxy file, String relativePathToRoot) {
        LinkedList<NotificationListener> lists;
        if (this.isCancelled()) {
            return;
        }
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof FileListener)) continue;
            ((FileListener)list).notifyFile(file, relativePathToRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatus(GitStatus status) {
        LinkedList<NotificationListener> lists;
        if (this.isCancelled()) {
            return;
        }
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof StatusListener)) continue;
            ((StatusListener)list).notifyStatus(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            for (ProgressMonitor pmListener : this.pmListeners) {
                if (!pmListener.isCanceled()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRevisionInfo(GitRevisionInfo info) {
        LinkedList<NotificationListener> lists;
        if (this.isCancelled()) {
            return;
        }
        Set<NotificationListener> set = this.listeners;
        synchronized (set) {
            lists = new LinkedList<NotificationListener>(this.listeners);
        }
        for (NotificationListener list : lists) {
            if (!(list instanceof RevisionInfoListener)) continue;
            ((RevisionInfoListener)list).notifyRevisionInfo(info);
        }
    }

    private class DelegateListener
    implements StatusListener,
    FileListener,
    RevisionInfoListener {
        private DelegateListener() {
        }

        @Override
        public void notifyStatus(GitStatus status) {
            GitClient.this.notifyStatus(status);
        }

        @Override
        public void notifyFile(VCSFileProxy file, String relativePathToRoot) {
            GitClient.this.notifyFile(file, relativePathToRoot);
        }

        @Override
        public void notifyRevisionInfo(GitRevisionInfo revisionInfo) {
            GitClient.this.notifyRevisionInfo(revisionInfo);
        }
    }

    public static enum CherryPickOperation {
        BEGIN,
        CONTINUE{

            public String toString() {
                return "--continue";
            }
        }
        ,
        QUIT{

            public String toString() {
                return "--quit";
            }
        }
        ,
        ABORT{

            public String toString() {
                return "--abort";
            }
        };

    }

    public static enum RebaseOperationType {
        BEGIN,
        CONTINUE{

            public String toString() {
                return "--continue";
            }
        }
        ,
        SKIP{

            public String toString() {
                return "--skip";
            }
        }
        ,
        ABORT{

            public String toString() {
                return "--abort";
            }
        };

    }

    public static enum DiffMode {
        HEAD_VS_INDEX,
        HEAD_VS_WORKINGTREE,
        INDEX_VS_WORKINGTREE;

    }

    public static enum ResetType {
        SOFT{

            public String toString() {
                return "--soft";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "--mixed";
            }
        }
        ,
        HARD{

            public String toString() {
                return "--hard";
            }
        };

    }
}

