/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.git.remote.cli.GitBlameResult;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class BlameCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final String revision;
    private final VCSFileProxy file;
    private final ProgressMonitor monitor;
    private GitBlameResult result;

    public BlameCommand(JGitRepository repository, GitClassFactory gitFactory, VCSFileProxy file, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.file = file;
        this.revision = revision;
        this.monitor = monitor;
    }

    public GitBlameResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "blame");
        this.addArgument(0, "--porcelain");
        if (this.revision != null) {
            this.addArgument(0, this.revision);
        }
        this.addArgument(0, "--");
        this.addFiles(0, this.file);
    }

    @Override
    protected void run() throws GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap<String, GitBlameResult.GitBlameContent> content = new LinkedHashMap<String, GitBlameResult.GitBlameContent>();
                final AtomicBoolean failed = new AtomicBoolean(false);
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        BlameCommand.this.parseBlameOutput(output, content);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        failed.set(true);
                    }
                }.runCLI();
                if (!failed.get()) {
                    this.result = this.getClassFactory().createBlameResult(this.file, content, this.getRepository());
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }

    private void parseBlameOutput(String output, LinkedHashMap<String, GitBlameResult.GitBlameContent> content) {
        State state = State.revision;
        GitBlameResult.GitBlameContent current = null;
        int currLine = -1;
        GitBlameResult.LineInfo currLineInfo = null;
        for (String line : output.split("\n")) {
            if (state == State.revision) {
                String[] s = line.split(" ");
                String rev = s[0];
                current = content.get(rev);
                if (current == null) {
                    current = new GitBlameResult.GitBlameContent();
                    current.revision = rev;
                    content.put(rev, current);
                    state = State.header;
                } else {
                    state = State.line;
                }
                currLine = Integer.parseInt(s[2]);
                currLineInfo = new GitBlameResult.LineInfo();
                currLineInfo.line = Integer.parseInt(s[1]);
                continue;
            }
            if (state == State.header) {
                if (line.startsWith("author ")) {
                    current.author = line.substring(7).trim();
                    continue;
                }
                if (line.startsWith("author-mail ")) {
                    current.author_mail = line.substring(12).trim();
                    continue;
                }
                if (line.startsWith("author-time ")) {
                    current.author_time = line.substring(12).trim();
                    continue;
                }
                if (line.startsWith("author-tz ")) {
                    current.author_tz = line.substring(10).trim();
                    continue;
                }
                if (line.startsWith("committer ")) {
                    current.committer = line.substring(10).trim();
                    continue;
                }
                if (line.startsWith("committer-mail ")) {
                    current.committer_mail = line.substring(15).trim();
                    continue;
                }
                if (line.startsWith("committer-time ")) {
                    current.committer_time = line.substring(15).trim();
                    continue;
                }
                if (line.startsWith("committer-tz ")) {
                    current.committer_tz = line.substring(13).trim();
                    continue;
                }
                if (line.startsWith("summary ")) {
                    current.summary = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("previous ")) {
                    current.previous = line.substring(9).trim();
                    continue;
                }
                if (line.startsWith("boundary")) continue;
                if (line.startsWith("filename ")) {
                    current.filename = line.substring(9).trim();
                    state = State.line;
                    continue;
                }
            }
            if (state != State.line) continue;
            currLineInfo.lineContent = line.substring(1);
            current.lines.put(currLine, currLineInfo);
            state = State.revision;
        }
    }

    private static enum State {
        revision,
        header,
        line;

    }
}

