/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitObjectType;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.SearchCriteria;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListBranchCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.cli.progress.RevisionInfoListener;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class LogCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final ProgressMonitor monitor;
    private final RevisionInfoListener listener;
    private final List<GitRevisionInfo> revisions;
    private final String revision;
    private final SearchCriteria criteria;
    private final boolean fetchBranchInfo;
    private final GitCommand.Revision revisionPlaseHolder;
    private static final Logger LOG = Logger.getLogger(LogCommand.class.getName());

    public LogCommand(JGitRepository repository, GitClassFactory gitFactory, SearchCriteria criteria, boolean fetchBranchInfo, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.criteria = criteria;
        this.fetchBranchInfo = fetchBranchInfo;
        this.revision = null;
        this.revisions = new LinkedList<GitRevisionInfo>();
        this.revisionPlaseHolder = fetchBranchInfo ? new GitCommand.Revision() : null;
    }

    public LogCommand(JGitRepository repository, GitClassFactory gitFactory, String revision, ProgressMonitor monitor, RevisionInfoListener listener) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.listener = listener;
        this.criteria = null;
        this.fetchBranchInfo = false;
        this.revision = revision;
        this.revisions = new LinkedList<GitRevisionInfo>();
        this.revisionPlaseHolder = null;
    }

    public GitRevisionInfo[] getRevisions() {
        return this.revisions.toArray(new GitRevisionInfo[this.revisions.size()]);
    }

    @Override
    protected void prepare() throws GitException {
        if (this.fetchBranchInfo) {
            this.setCommandsNumber(2);
        }
        super.prepare();
        this.addArgument(0, "log");
        this.addArgument(0, "--raw");
        this.addArgument(0, "--pretty=raw");
        if (this.criteria == null || !this.criteria.isFollow() || this.criteria.getFiles() == null || this.criteria.getFiles().length == 1) {
            // empty if block
        }
        if (this.criteria != null && !this.criteria.isIncludeMerges()) {
            this.addArgument(0, "--no-merges");
        } else {
            this.addArgument(0, "-m");
        }
        if (this.revision != null) {
            this.addArgument(0, "--no-walk");
            this.addArgument(0, this.revision);
        } else if (this.criteria != null && this.criteria.getRevisionTo() != null && this.criteria.getRevisionFrom() != null) {
            if (this.criteria.getRevisionFrom().equals(this.criteria.getRevisionTo())) {
                this.addArgument(0, this.criteria.getRevisionFrom());
            } else if (this.criteria.isAddSelfFrom()) {
                this.addArgument(0, this.criteria.getRevisionFrom() + "^.." + this.criteria.getRevisionTo());
            } else {
                this.addArgument(0, this.criteria.getRevisionFrom() + ".." + this.criteria.getRevisionTo());
            }
        } else if (this.criteria != null && this.criteria.getRevisionTo() != null) {
            this.addArgument(0, this.criteria.getRevisionTo());
        } else if (this.criteria != null && this.criteria.getRevisionFrom() != null) {
            if (this.criteria.isAddSelfFrom()) {
                this.addArgument(0, this.criteria.getRevisionFrom() + "^..");
            } else {
                this.addArgument(0, this.criteria.getRevisionFrom() + "..");
            }
        } else {
            this.addArgument(0, "--all");
        }
        if (this.criteria != null && this.criteria.getUsername() != null) {
            this.addArgument(0, "--author=" + this.criteria.getUsername());
        }
        if (this.criteria != null && this.criteria.getMessage() != null) {
            String pattern = this.criteria.getMessage();
            if (pattern.indexOf(10) >= 0) {
                pattern = pattern.substring(0, pattern.indexOf(10));
            }
            if (!pattern.startsWith("^") && !pattern.startsWith(".*")) {
                pattern = ".*" + pattern;
            }
            if (!pattern.endsWith("$") && !pattern.endsWith(".*")) {
                pattern = pattern + ".*";
            }
            this.addArgument(0, "--grep=" + pattern);
        }
        if (this.criteria != null && this.criteria.getFrom() != null && this.criteria.getTo() != null) {
            this.addArgument(0, "--since=" + this.criteria.getFrom().getTime() / 1000L);
            this.addArgument(0, "--until=" + this.criteria.getTo().getTime() / 1000L);
        } else if (this.criteria != null && this.criteria.getFrom() != null) {
            this.addArgument(0, "--since=" + this.criteria.getFrom().getTime() / 1000L);
        } else if (this.criteria != null && this.criteria.getTo() != null) {
            this.addArgument(0, "--until=" + this.criteria.getTo().getTime() / 1000L);
        }
        if (this.criteria != null && this.criteria.getLimit() > 0) {
            this.addArgument(0, "-" + this.criteria.getLimit());
        }
        if (this.criteria != null && this.criteria.getFiles().length > 0) {
            this.addArgument(0, "--full-diff");
            this.addArgument(0, "--");
            this.addFiles(0, this.criteria.getFiles());
        }
        if (this.fetchBranchInfo) {
            this.addArgument(1, "branch");
            this.addArgument(1, "-v");
            this.addArgument(1, "-v");
            this.addArgument(1, "-a");
            this.addArgument(1, "--contains");
            this.addArgument(1, this.revisionPlaseHolder);
        }
    }

    @Override
    protected void run() throws GitException {
        block6: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final LinkedHashMap statuses = new LinkedHashMap();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        LogCommand.parseLog(output, statuses);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        for (String msg : error.split("\n")) {
                            if (msg.startsWith("fatal: Invalid object")) {
                                throw new GitException.MissingObjectException("HEAD", GitObjectType.COMMIT);
                            }
                            if (!msg.startsWith("fatal: ambiguous argument")) continue;
                            throw new GitException.MissingObjectException(LogCommand.this.revision, GitObjectType.COMMIT);
                        }
                        super.errorParser(error);
                    }
                }.runCLI();
                for (Map.Entry entry : statuses.entrySet()) {
                    if (this.fetchBranchInfo) {
                        this.revisionPlaseHolder.setContent((String)entry.getKey());
                        final LinkedHashMap<String, GitBranch> branches = new LinkedHashMap<String, GitBranch>();
                        new GitCommand.Runner(canceled, 1){

                            @Override
                            public void outputParser(String output) throws GitException {
                                ListBranchCommand.parseBranches(output, LogCommand.this.getClassFactory(), branches);
                            }
                        }.runCLI();
                        this.revisions.add(this.getClassFactory().createRevisionInfo((GitRevisionInfo.GitRevCommit)entry.getValue(), branches, this.getRepository()));
                        continue;
                    }
                    this.revisions.add(this.getClassFactory().createRevisionInfo((GitRevisionInfo.GitRevCommit)entry.getValue(), this.getRepository()));
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block6;
                throw new GitException(t);
            }
        }
    }

    static void parseLog(String output, LinkedHashMap<String, GitRevisionInfo.GitRevCommit> statuses) {
        GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
        StringBuilder buf = new StringBuilder();
        for (String line : output.split("\n")) {
            Object s;
            if (line.startsWith("Reflog:") || line.startsWith("Reflog message:")) continue;
            if (line.startsWith("committer")) {
                s = line.substring(9).trim();
                int i = s.indexOf(62);
                if (i <= 0) continue;
                status.commiterAndMail = s.substring(0, i + 1);
                status.commiterTime = s.substring(i + 1).trim();
                continue;
            }
            if (line.startsWith("commit")) {
                String revCode = line.substring(6).trim();
                int i = revCode.indexOf(40);
                if (i > 0) {
                    revCode = revCode.substring(0, i - 1).trim();
                }
                if (status.revisionCode != null) {
                    status.message = buf.toString();
                    buf.setLength(0);
                    statuses.put(status.revisionCode, status);
                    status = statuses.containsKey(revCode) ? statuses.get(revCode) : new GitRevisionInfo.GitRevCommit();
                }
                status.revisionCode = revCode;
                continue;
            }
            if (line.startsWith("tree")) {
                status.treeCode = line.substring(4).trim();
                continue;
            }
            if (line.startsWith("parent")) {
                status.parents.add(line.substring(6).trim());
                continue;
            }
            if (line.startsWith("author")) {
                s = line.substring(6).trim();
                int i = s.indexOf(62);
                if (i <= 0) continue;
                status.autorAndMail = s.substring(0, i + 1);
                status.autorTime = s.substring(i + 1).trim();
                continue;
            }
            if (line.startsWith(" ")) {
                buf.append(line.trim());
                buf.append('\n');
                continue;
            }
            if (!line.startsWith(":") || ((String[])(s = line.split("\\s"))).length <= 2) continue;
            String file = s[((String[])s).length - 1];
            String st = s[((String[])s).length - 2];
            GitRevisionInfo.GitFileInfo.Status gitSt = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
            if ("A".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.ADDED;
            } else if ("M".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.MODIFIED;
            } else if ("R".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.RENAMED;
            } else if ("C".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.COPIED;
            } else if ("D".equals(st)) {
                gitSt = GitRevisionInfo.GitFileInfo.Status.REMOVED;
            }
            status.commitedFiles.put(file, gitSt);
        }
        if (status.revisionCode != null) {
            status.message = buf.toString();
            statuses.put(status.revisionCode, status);
        }
    }
}

