/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.content.project.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public class ClassifierContainer
extends ProjectComponent {
    private final Map<CharSequence, CsmUID<CsmClassifier>> classifiers;
    private final Map<CharSequence, CsmUID<CsmClassifier>> shortClassifiers;
    private final Map<CharSequence, CsmUID<CsmClassifier>> typedefs;
    private final Map<CharSequence, Set<CsmUID<CsmInheritance>>> inheritances;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private static final ClassifierContainer EMPTY = new ClassifierContainer(){

        @Override
        public boolean putClassifier(CsmClassifier decl) {
            return false;
        }

        @Override
        public void put() {
        }
    };

    public static ClassifierContainer empty() {
        return EMPTY;
    }

    public ClassifierContainer(ProjectBase project) {
        super(new ClassifierContainerKey(project.getUnitId()));
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.shortClassifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
        this.put();
    }

    public ClassifierContainer(RepositoryDataInput input) throws IOException {
        super(input);
        int collSize = input.readInt();
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>(collSize);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.classifiers, input, QualifiedNameCache.getManager(), collSize);
        collSize = input.readInt();
        this.shortClassifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>(collSize);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.shortClassifiers, input, QualifiedNameCache.getManager(), collSize);
        collSize = input.readInt();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>(collSize);
        UIDObjectFactory.getDefaultFactory().readStringToUIDMap(this.typedefs, input, QualifiedNameCache.getManager(), collSize);
        collSize = input.readInt();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
        UIDObjectFactory.getDefaultFactory().readStringToUIDMapSet(this.inheritances, input, NameCache.getManager(), collSize);
    }

    private ClassifierContainer() {
        super((Key)null);
        this.classifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.shortClassifiers = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.typedefs = new HashMap<CharSequence, CsmUID<CsmClassifier>>();
        this.inheritances = new HashMap<CharSequence, Set<CsmUID<CsmInheritance>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getClassifier(CharSequence qualifiedName) {
        CsmUID<CsmClassifier> uid;
        qualifiedName = CharSequences.create((CharSequence)qualifiedName);
        try {
            this.declarationsLock.readLock().lock();
            uid = this.classifiers.get(qualifiedName);
            if (uid == null) {
                uid = this.shortClassifiers.get(qualifiedName);
            }
            if (uid == null) {
                uid = this.typedefs.get(qualifiedName);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        CsmClassifier result = UIDCsmConverter.UIDtoDeclaration(uid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInheritance> getInheritances(CharSequence name) {
        ArrayList inh;
        block4: {
            name = CharSequences.create((CharSequence)name);
            try {
                this.declarationsLock.readLock().lock();
                inh = (ArrayList)((Object)this.inheritances.get(name));
                if (inh != null) {
                    inh = new ArrayList(inh);
                    break block4;
                }
                List<CsmInheritance> list = Collections.emptyList();
                return list;
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
        }
        return UIDCsmConverter.UIDsToInheritances(inh);
    }

    public Map<CharSequence, CsmClassifier> getTestClassifiers() {
        return this.convertTestMap(this.classifiers);
    }

    public Map<CharSequence, CsmClassifier> getTestShortClassifiers() {
        return this.convertTestMap(this.shortClassifiers);
    }

    public Map<CharSequence, CsmClassifier> getTestTypedefs() {
        return this.convertTestMap(this.typedefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CharSequence, CsmClassifier> convertTestMap(Map<CharSequence, CsmUID<CsmClassifier>> map) {
        TreeMap<CharSequence, CsmClassifier> res = new TreeMap<CharSequence, CsmClassifier>();
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, CsmUID<CsmClassifier>> entry : map.entrySet()) {
                res.put(entry.getKey(), UIDCsmConverter.UIDtoDeclaration(entry.getValue()));
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putClassifier(CsmClassifier decl) {
        CharSequence qn2;
        Map<CharSequence, CsmUID<CsmClassifier>> shortNamesMap;
        Map<CharSequence, CsmUID<CsmClassifier>> map;
        boolean changed = false;
        CsmUID<CsmClassifier> uid = UIDCsmConverter.declarationToUID(decl);
        if (this.isTypedef((CsmDeclaration)decl) || this.isTypeAlias((CsmDeclaration)decl)) {
            map = this.typedefs;
            shortNamesMap = null;
        } else {
            CsmClass cls;
            Collection base;
            map = this.classifiers;
            shortNamesMap = this.shortClassifiers;
            if (CsmKindUtilities.isClass((CsmObject)decl) && !(base = (cls = (CsmClass)decl).getBaseClasses()).isEmpty()) {
                try {
                    this.declarationsLock.writeLock().lock();
                    for (CsmInheritance inh : base) {
                        CharSequence id = this.inheritanceName(inh);
                        Set<CsmUID<CsmInheritance>> set = this.inheritances.get(id);
                        if (set == null) {
                            set = new HashSet<CsmUID<CsmInheritance>>();
                            this.inheritances.put(id, set);
                        }
                        set.add(UIDCsmConverter.inheritanceToUID(inh));
                        changed = true;
                    }
                }
                finally {
                    this.declarationsLock.writeLock().unlock();
                }
            }
        }
        CharSequence qn = decl.getQualifiedName();
        changed |= this.putClassifier(map, qn, uid);
        if (shortNamesMap != null && (qn2 = this.getQualifiedNameWithoutScopeStructNameForC((CsmDeclaration)decl)) != null && qn.length() != qn2.length()) {
            changed |= this.putClassifier(shortNamesMap, qn2, uid);
        }
        if (changed) {
            this.put();
        }
        return changed;
    }

    private CharSequence inheritanceName(CsmInheritance inh) {
        CharSequence id = inh instanceof TypeImpl ? ((TypeImpl)inh.getAncestorType()).getOwnText() : inh.getAncestorType().getClassifierText();
        int i = CharSequenceUtils.lastIndexOf((CharSequence)id, (CharSequence)"::");
        if (i >= 0) {
            id = id.subSequence(i + 2, id.length());
        }
        return NameCache.getManager().getString(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putClassifier(Map<CharSequence, CsmUID<CsmClassifier>> map, CharSequence qn, CsmUID<CsmClassifier> uid) {
        boolean changed = false;
        try {
            this.declarationsLock.writeLock().lock();
            CsmUID<CsmClassifier> old = map.get(qn);
            if (old == null || !UIDUtilities.isForwardClass(uid) && UIDUtilities.isForwardClass(old)) {
                assert (uid != null);
                map.put(qn, uid);
                assert (UIDCsmConverter.UIDtoDeclaration(uid) != null);
                changed = true;
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassifier(CsmDeclaration decl) {
        CharSequence qn2;
        Map<CharSequence, CsmUID<CsmClassifier>> shortNamesMap;
        Map<CharSequence, CsmUID<CsmClassifier>> map;
        CsmUID uid = UIDs.get((Object)decl);
        boolean changed = false;
        if (this.isTypedef(decl) || this.isTypeAlias(decl)) {
            map = this.typedefs;
            shortNamesMap = null;
        } else {
            CsmClass cls;
            Collection base;
            map = this.classifiers;
            shortNamesMap = this.shortClassifiers;
            if (CsmKindUtilities.isClass((CsmObject)decl) && !(base = (cls = (CsmClass)decl).getBaseClasses()).isEmpty()) {
                try {
                    this.declarationsLock.writeLock().lock();
                    for (CsmInheritance inh : base) {
                        CharSequence id = this.inheritanceName(inh);
                        Set<CsmUID<CsmInheritance>> set = this.inheritances.get(id);
                        if (set == null) continue;
                        set.remove(UIDCsmConverter.inheritanceToUID(inh));
                        changed = true;
                    }
                }
                finally {
                    this.declarationsLock.writeLock().unlock();
                }
            }
        }
        CharSequence qn = decl.getQualifiedName();
        changed |= this.removeClassifier(map, qn, uid);
        if (shortNamesMap != null && (qn2 = this.getQualifiedNameWithoutScopeStructNameForC(decl)) != null && qn.length() != qn2.length()) {
            changed |= this.removeClassifier(shortNamesMap, qn2, uid);
        }
        if (changed) {
            this.put();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeClassifier(Map<CharSequence, CsmUID<CsmClassifier>> map, CharSequence qn, CsmUID<?> uid) {
        CsmUID<CsmClassifier> removed;
        try {
            this.declarationsLock.writeLock().lock();
            removed = map.get(qn);
            if (removed != null && removed.equals(uid)) {
                map.remove(qn);
            } else {
                removed = null;
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        assert (removed == null || UIDCsmConverter.UIDtoCsmObject(removed) != null) : " no object for UID " + removed;
        return removed != null;
    }

    private CharSequence getQualifiedNameWithoutScopeStructNameForC(CsmDeclaration decl) {
        CsmDeclaration.Kind kind = decl.getKind();
        if (kind != CsmDeclaration.Kind.STRUCT && kind != CsmDeclaration.Kind.UNION || CsmKindUtilities.isTemplate((CsmObject)decl)) {
            return null;
        }
        CharSequence qualifiedNamePostfix = decl instanceof OffsetableDeclarationBase ? ((OffsetableDeclarationBase)decl).getQualifiedNamePostfix() : decl.getName();
        CsmScope scope = decl.getScope();
        while (CsmKindUtilities.isClass((CsmObject)scope)) {
            CsmClass cls = (CsmClass)scope;
            kind = cls.getKind();
            if (kind != CsmDeclaration.Kind.STRUCT && kind != CsmDeclaration.Kind.UNION || CsmKindUtilities.isTemplate((CsmObject)decl)) {
                return null;
            }
            scope = cls.getScope();
        }
        if (CsmKindUtilities.isNamespace((Object)scope) && !((CsmNamespace)scope).isGlobal()) {
            return null;
        }
        CharSequence qualifiedName = QualifiedNameCache.getManager().getString(qualifiedNamePostfix);
        return qualifiedName;
    }

    private boolean isTypedef(CsmDeclaration decl) {
        return CsmKindUtilities.isTypedef((CsmObject)decl);
    }

    private boolean isTypeAlias(CsmDeclaration decl) {
        return CsmKindUtilities.isTypeAlias((CsmObject)decl);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.classifiers, output, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.shortClassifiers, output, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMap(this.typedefs, output, false);
            UIDObjectFactory.getDefaultFactory().writeStringToUIDMapSet(this.inheritances, output);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }
}

