/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeAlias;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImplSpecialization;
import org.netbeans.modules.cnd.modelimpl.csm.ConstructorDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ConstructorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.DestructorDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DestructorImpl;
import org.netbeans.modules.cnd.modelimpl.csm.EnumForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FieldImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardEnum;
import org.netbeans.modules.cnd.modelimpl.csm.FriendClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodDDImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MethodImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeAliasImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypedefImpl;
import org.netbeans.modules.cnd.modelimpl.csm.UsingDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.SelectImpl;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.CharSequences;

public class ClassImpl
extends ClassEnumBase<CsmClass>
implements CsmClass,
CsmTemplate,
SelectImpl.FilterableMembers,
DeclarationsContainer {
    private final CsmDeclaration.Kind kind;
    private final List<CsmUID<CsmMember>> members;
    private final List<CsmUID<CsmFriend>> friends;
    private final ArrayList<CsmUID<CsmInheritance>> inheritances;
    private TemplateDescriptor templateDescriptor = null;
    private int leftBracketPos;
    private static final int CLASS_KIND = 1;
    private static final int UNION_KIND = 2;
    private static final int STRUCT_KIND = 3;

    protected ClassImpl(NameHolder name, AST ast, CsmFile file) {
        this(name, ast, file, ClassImpl.getStartOffset(ast), ClassImpl.getEndOffset(ast));
    }

    protected ClassImpl(NameHolder name, AST ast, CsmFile file, int start, int end) {
        super(name, file, start, end);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = this.findKind(ast);
    }

    protected ClassImpl(NameHolder name, CsmDeclaration.Kind kind, int leftBracketPos, CsmFile file, int startOffset, int endOffset) {
        super(name, file, startOffset, endOffset);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = kind;
        this.leftBracketPos = leftBracketPos;
    }

    private ClassImpl(CsmFile file, CsmScope scope, CharSequence name, CsmDeclaration.Kind kind, int startOffset, int endOffset) {
        super(name, name, file, startOffset, endOffset);
        this.members = new ArrayList<CsmUID<CsmMember>>();
        this.friends = new ArrayList<CsmUID<CsmFriend>>(0);
        this.inheritances = new ArrayList(0);
        this.kind = kind;
        this.initScope(scope);
    }

    public static ClassImpl create(CsmFile file, CsmScope scope, CharSequence name, CsmDeclaration.Kind kind, int startOffset, int endOffset, boolean register) {
        ClassImpl classImpl = new ClassImpl(file, scope, name, kind, startOffset, endOffset);
        ClassImpl.temporaryRepositoryRegistration(register, classImpl);
        if (register) {
            classImpl.register(classImpl.getScope(), false);
        }
        return classImpl;
    }

    public void init(CsmScope scope, AST ast, CsmFile file, FileContent fileContent, String language, boolean register, DeclarationsContainer container) throws AstRendererException {
        this.initScope(scope);
        ClassImpl.temporaryRepositoryRegistration(register, this);
        this.initClassDefinition(scope);
        this.render(ast, file, fileContent, language, !register, container);
        if (register) {
            this.register(this.getScope(), false);
        }
    }

    public void init3(CsmScope scope, boolean register) {
        this.initScope(scope);
        ClassImpl.temporaryRepositoryRegistration(register, this);
        this.initClassDefinition(scope);
        if (register) {
            this.register(this.getScope(), false);
        }
    }

    private void initClassDefinition(CsmScope scope) {
        MemberForwardDeclaration mfd = this.findMemberForwardDeclaration(scope);
        if (mfd instanceof ClassMemberForwardDeclaration && CsmKindUtilities.isClass((CsmObject)this)) {
            ClassMemberForwardDeclaration fd = (ClassMemberForwardDeclaration)mfd;
            fd.setCsmClass(this);
            CsmClass containingClass = fd.getContainingClass();
            if (containingClass != null) {
                this.initScope((CsmScope)containingClass);
            }
        }
    }

    public final void render(AST ast, CsmFile file, FileContent fileContent, String language, boolean localClass, DeclarationsContainer container) {
        new ClassAstRenderer(file, language, fileContent, CsmVisibility.PRIVATE, localClass, container).render(ast);
        this.leftBracketPos = this.initLeftBracketPos(ast);
    }

    public final void fixFakeRender(String language, FileContent fileContent, CsmVisibility visibility, AST ast, boolean localClass) {
        new ClassAstRenderer(fileContent.getFile(), language, fileContent, visibility, localClass, null).render(ast);
    }

    protected static ClassImpl findExistingClassImplInContainer(DeclarationsContainer container, AST ast) {
        ClassImpl out = null;
        if (container != null) {
            int end;
            CharSequence name = CharSequences.create((CharSequence)AstUtil.findId(ast, 17, true));
            name = name == null ? CharSequences.empty() : name;
            int start = ClassImpl.getStartOffset(ast);
            CsmOffsetableDeclaration existing = container.findExistingDeclaration(start, end = ClassImpl.getEndOffset(ast), name);
            if (existing instanceof ClassImpl) {
                out = (ClassImpl)existing;
            }
        }
        return out;
    }

    public static ClassImpl create(AST ast, CsmScope scope, CsmFile file, String language, FileContent fileContent, boolean register, DeclarationsContainer container) throws AstRendererException {
        ClassImpl impl = ClassImpl.findExistingClassImplInContainer(container, ast);
        if (impl != null && !ClassImpl.class.equals(impl.getClass())) {
            impl = null;
        }
        NameHolder nameHolder = null;
        if (impl == null) {
            nameHolder = NameHolder.createClassName(ast);
            impl = new ClassImpl(nameHolder, ast, file);
        }
        if (scope != null && scope instanceof ClassImpl) {
            ClassImpl scopeCls = (ClassImpl)scope;
            if (impl.getStartOffset() == scopeCls.getStartOffset() && impl.getEndOffset() == scopeCls.getEndOffset() && impl.getKind().equals((Object)scopeCls.getKind()) && impl.getName().equals(scopeCls.getName())) {
                return null;
            }
        }
        impl.init(scope, ast, file, fileContent, language, register, container);
        if (nameHolder != null) {
            nameHolder.addReference(fileContent, impl);
        }
        return impl;
    }

    protected void setTemplateDescriptor(TemplateDescriptor td) {
        this.templateDescriptor = td;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return this.kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmMember> getMembers() {
        Collection<CsmMember> out;
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            out = UIDCsmConverter.UIDsToDeclarations(this.members);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter filter) {
        ArrayList uids = new ArrayList();
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            uids.addAll(this.members);
        }
        return UIDCsmConverter.UIDsToDeclarations(uids, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> getFriends() {
        Collection<CsmFriend> out;
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            out = UIDCsmConverter.UIDsToDeclarations(this.friends);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmInheritance> getBaseClasses() {
        Collection<CsmInheritance> out;
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            out = UIDCsmConverter.UIDsToInheritances(this.inheritances);
        }
        return out;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, int end, CharSequence name) {
        CsmUID out = null;
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.members, start, end, name);
        }
        if (out == null) {
            list = this.friends;
            synchronized (list) {
                out = UIDUtilities.findExistingUIDInList(this.friends, start, end, name);
            }
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, CharSequence name, CsmDeclaration.Kind kind) {
        CsmUID out = null;
        if (kind != CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION && kind != CsmDeclaration.Kind.FUNCTION_FRIEND && kind != CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
            List<CsmUID<CsmMember>> list = this.members;
            synchronized (list) {
                out = UIDUtilities.findExistingUIDInList(this.members, start, name, kind);
            }
        }
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.friends, start, name, kind);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMember(CsmMember member, boolean global) {
        if (global) {
            RepositoryUtils.put(member);
        }
        CsmUID<CsmMember> uid = UIDCsmConverter.declarationToUID(member);
        assert (uid != null);
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInheritance(CsmInheritance inheritance, boolean global) {
        if (global) {
            RepositoryUtils.put(inheritance);
        }
        CsmUID<CsmInheritance> uid = UIDCsmConverter.inheritanceToUID(inheritance);
        assert (uid != null);
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.inheritances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFriend(CsmFriend friend, boolean global) {
        if (global) {
            RepositoryUtils.put(friend);
        }
        CsmUID<CsmFriend> uid = UIDCsmConverter.declarationToUID(friend);
        assert (uid != null);
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.friends);
        }
    }

    private int initLeftBracketPos(AST node) {
        AST lcurly = AstUtil.findChildOfType(node, 16);
        return lcurly instanceof CsmAST ? ((CsmAST)lcurly).getOffset() : this.getStartOffset();
    }

    public int getLeftBracketOffset() {
        return this.leftBracketPos;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.getMembers();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._clearMembers();
        this._clearFriends();
        this._clearInheritances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearMembers() {
        Collection<CsmMember> members2dispose = this.getMembers();
        Utils.disposeAll(members2dispose);
        List<CsmUID<CsmMember>> list = this.members;
        synchronized (list) {
            RepositoryUtils.remove(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearInheritances() {
        Collection<CsmInheritance> inheritances2dispose = this.getBaseClasses();
        Utils.disposeAll(inheritances2dispose);
        ArrayList<CsmUID<CsmInheritance>> arrayList = this.inheritances;
        synchronized (arrayList) {
            RepositoryUtils.remove(this.inheritances);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearFriends() {
        Collection<CsmFriend> friends2dispose = this.getFriends();
        Utils.disposeAll(friends2dispose);
        List<CsmUID<CsmFriend>> list = this.friends;
        synchronized (list) {
            RepositoryUtils.remove(this.friends);
        }
    }

    private CsmDeclaration.Kind findKind(AST ast) {
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 159: {
                    return CsmDeclaration.Kind.CLASS;
                }
                case 161: {
                    return CsmDeclaration.Kind.UNION;
                }
                case 160: {
                    return CsmDeclaration.Kind.STRUCT;
                }
            }
        }
        return CsmDeclaration.Kind.CLASS;
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)this.getName(), (CharSequence)this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.kind != null);
        ClassImpl.writeKind(this.kind, output);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
        output.writeInt(this.leftBracketPos);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUIDCollection(this.members, output, true);
        factory.writeUIDCollection(this.friends, output, true);
        factory.writeUIDCollection(this.inheritances, output, true);
    }

    public ClassImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.kind = ClassImpl.readKind(input);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
        this.leftBracketPos = input.readInt();
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        int collSize = input.readInt();
        this.members = collSize <= 0 ? new ArrayList<CsmUID<CsmMember>>(0) : new ArrayList<CsmUID<CsmMember>>(collSize);
        factory.readUIDCollection(this.members, input, collSize);
        collSize = input.readInt();
        this.friends = collSize <= 0 ? new ArrayList<CsmUID<CsmFriend>>(0) : new ArrayList<CsmUID<CsmFriend>>(collSize);
        factory.readUIDCollection(this.friends, input, collSize);
        collSize = input.readInt();
        this.inheritances = collSize <= 0 ? new ArrayList(0) : new ArrayList(collSize);
        factory.readUIDCollection(this.inheritances, input, collSize);
    }

    private static void writeKind(CsmDeclaration.Kind kind, RepositoryDataOutput output) throws IOException {
        int kindHandler;
        if (kind == CsmDeclaration.Kind.CLASS) {
            kindHandler = 1;
        } else if (kind == CsmDeclaration.Kind.UNION) {
            kindHandler = 2;
        } else {
            assert (kind == CsmDeclaration.Kind.STRUCT);
            kindHandler = 3;
        }
        output.writeByte(kindHandler);
    }

    private static CsmDeclaration.Kind readKind(RepositoryDataInput input) throws IOException {
        CsmDeclaration.Kind kind;
        byte kindHandler = input.readByte();
        switch (kindHandler) {
            case 1: {
                kind = CsmDeclaration.Kind.CLASS;
                break;
            }
            case 2: {
                kind = CsmDeclaration.Kind.UNION;
                break;
            }
            case 3: {
                kind = CsmDeclaration.Kind.STRUCT;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal handler " + kindHandler);
            }
        }
        return kind;
    }

    public static final class EnumMemberForwardDeclaration
    extends EnumForwardDeclarationImpl
    implements CsmMember,
    CsmClassifier,
    MemberForwardDeclaration {
        private final CsmVisibility visibility;
        private CsmUID<CsmEnum> enumDefinition;
        private final CsmUID<CsmClass> containerUID;
        private CsmClass containerRef;

        private EnumMemberForwardDeclaration(CsmFile file, CsmClass containingClass, AST ast, CsmVisibility curentVisibility, boolean register) {
            super(ast, file, register);
            this.visibility = curentVisibility;
            this.containerUID = UIDCsmConverter.declarationToUID(containingClass);
        }

        public static EnumMemberForwardDeclaration create(CsmFile file, CsmClass containingClass, AST ast, CsmVisibility curentVisibility, boolean register) {
            EnumMemberForwardDeclaration res = new EnumMemberForwardDeclaration(file, containingClass, ast, curentVisibility, register);
            EnumMemberForwardDeclaration.postObjectCreateRegistration(register, res);
            return res;
        }

        @Override
        protected final boolean registerInProject() {
            CsmProject project = this.getContainingFile().getProject();
            if (project instanceof ProjectBase) {
                return ((ProjectBase)project).registerDeclaration(this);
            }
            return false;
        }

        private void unregisterInProject() {
            CsmProject project = this.getContainingFile().getProject();
            if (project instanceof ProjectBase) {
                ((ProjectBase)project).unregisterDeclaration(this);
                this.cleanUID();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.onDispose();
            CsmScope scope = this.getScope();
            if (scope instanceof MutableDeclarationsContainer) {
                ((MutableDeclarationsContainer)scope).removeDeclaration(this);
            }
            this.unregisterInProject();
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        private synchronized void onDispose() {
            if (this.containerRef == null) {
                this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
        }

        public synchronized CsmClass getContainingClass() {
            CsmClass out = this.containerRef;
            if (out == null) {
                out = this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
            return out;
        }

        @Override
        public CsmScope getScope() {
            return this.getContainingClass();
        }

        @Override
        public CsmEnum getCsmEnum() {
            CsmEnum enm = UIDCsmConverter.UIDtoDeclaration(this.enumDefinition);
            if (enm != null && enm.isValid() && !ForwardEnum.isForwardEnum((CsmObject)enm)) {
                return enm;
            }
            enm = super.getCsmEnum();
            this.setCsmEnum(enm);
            return enm;
        }

        @Override
        protected ForwardEnum createForwardEnumIfNeed(AST ast, CsmScope scope, boolean registerInProject) {
            ForwardEnum enm = super.createForwardEnumIfNeed(ast, scope, registerInProject);
            this.enumDefinition = UIDCsmConverter.declarationToUID(enm);
            if (enm != null) {
                RepositoryUtils.put(this);
            }
            return enm;
        }

        public void setCsmEnum(CsmEnum cls) {
            this.enumDefinition = UIDCsmConverter.declarationToUID(cls);
        }

        @Override
        public CharSequence getQualifiedName() {
            CsmClass cls = this.getContainingClass();
            if (cls == null) {
                cls = this.getContainingClass();
            }
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)cls.getQualifiedName(), (CharSequence)"::", (CharSequence)this.getName()));
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, output);
            assert (this.containerUID != null);
            UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, output);
            UIDObjectFactory.getDefaultFactory().writeUID(this.enumDefinition, output);
        }

        public EnumMemberForwardDeclaration(RepositoryDataInput input) throws IOException {
            super(input);
            this.visibility = PersistentUtils.readVisibility(input);
            assert (this.visibility != null);
            this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(input);
            assert (this.containerUID != null);
            this.enumDefinition = UIDObjectFactory.getDefaultFactory().readUID(input);
        }
    }

    public static final class ClassMemberForwardDeclaration
    extends ClassForwardDeclarationImpl
    implements CsmMember,
    CsmClassifier,
    MemberForwardDeclaration {
        private final CsmVisibility visibility;
        private CsmUID<CsmClass> classDefinition;
        private final CsmUID<CsmClass> containerUID;
        private CsmClass containerRef;

        private ClassMemberForwardDeclaration(CsmFile file, CsmClass containingClass, AST ast, CsmVisibility curentVisibility, boolean register) {
            super(ast, file, register);
            this.visibility = curentVisibility;
            this.containerUID = UIDCsmConverter.declarationToUID(containingClass);
        }

        private ClassMemberForwardDeclaration(CharSequence name, TemplateDescriptor templateDescriptor, CsmClass containingClass, CsmVisibility curentVisibility, CsmFile file, int startOffset, int endOffset) {
            super(name, templateDescriptor, file, startOffset, endOffset);
            this.visibility = curentVisibility;
            this.containerUID = UIDCsmConverter.declarationToUID(containingClass);
        }

        public static ClassMemberForwardDeclaration create(CsmFile file, CsmClass containingClass, AST ast, CsmVisibility curentVisibility, boolean register) {
            ClassMemberForwardDeclaration res = new ClassMemberForwardDeclaration(file, containingClass, ast, curentVisibility, register);
            ClassMemberForwardDeclaration.postObjectCreateRegistration(register, res);
            return res;
        }

        @Override
        protected final boolean registerInProject() {
            CsmProject project = this.getContainingFile().getProject();
            if (project instanceof ProjectBase) {
                return ((ProjectBase)project).registerDeclaration(this);
            }
            return false;
        }

        private void unregisterInProject() {
            CsmProject project = this.getContainingFile().getProject();
            if (project instanceof ProjectBase) {
                ((ProjectBase)project).unregisterDeclaration(this);
                this.cleanUID();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this.onDispose();
            CsmScope scope = this.getScope();
            if (scope instanceof MutableDeclarationsContainer) {
                ((MutableDeclarationsContainer)scope).removeDeclaration(this);
            }
            this.unregisterInProject();
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        private synchronized void onDispose() {
            if (this.containerRef == null) {
                this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
        }

        public synchronized CsmClass getContainingClass() {
            CsmClass out = this.containerRef;
            if (out == null) {
                out = this.containerRef = UIDCsmConverter.UIDtoClass(this.containerUID);
            }
            return out;
        }

        @Override
        public CsmScope getScope() {
            return this.getContainingClass();
        }

        @Override
        public CsmClass getCsmClass() {
            CsmClass cls = UIDCsmConverter.UIDtoClass(this.classDefinition);
            if (cls != null && cls.isValid() && !ForwardClass.isForwardClass((CsmObject)cls)) {
                return cls;
            }
            cls = super.getCsmClass();
            this.setCsmClass(cls);
            return cls;
        }

        @Override
        protected ForwardClass createForwardClassIfNeed(AST ast, CsmScope scope, boolean registerInProject) {
            ForwardClass cls = super.createForwardClassIfNeed(ast, scope, registerInProject);
            this.classDefinition = UIDCsmConverter.declarationToUID(cls);
            if (cls != null) {
                RepositoryUtils.put(this);
            }
            return cls;
        }

        public void setCsmClass(CsmClass cls) {
            this.classDefinition = UIDCsmConverter.declarationToUID(cls);
        }

        @Override
        public CharSequence getQualifiedName() {
            CsmClass cls = this.getContainingClass();
            if (cls == null) {
                cls = this.getContainingClass();
            }
            return CharSequences.create((CharSequence)CharSequenceUtils.concatenate((CharSequence)cls.getQualifiedName(), (CharSequence)"::", (CharSequence)this.getName()));
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, output);
            assert (this.containerUID != null);
            UIDObjectFactory.getDefaultFactory().writeUID(this.containerUID, output);
            UIDObjectFactory.getDefaultFactory().writeUID(this.classDefinition, output);
        }

        public ClassMemberForwardDeclaration(RepositoryDataInput input) throws IOException {
            super(input);
            this.visibility = PersistentUtils.readVisibility(input);
            assert (this.visibility != null);
            this.containerUID = UIDObjectFactory.getDefaultFactory().readUID(input);
            assert (this.containerUID != null);
            this.classDefinition = UIDObjectFactory.getDefaultFactory().readUID(input);
        }

        public static class ClassMemberForwardDeclarationBuilder
        extends ClassForwardDeclarationImpl.ClassForwardDeclarationBuilder
        implements MemberBuilder {
            private CsmVisibility visibility = CsmVisibility.PUBLIC;

            public ClassMemberForwardDeclarationBuilder() {
            }

            public ClassMemberForwardDeclarationBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
                super(builder);
            }

            @Override
            public void setVisibility(CsmVisibility visibility) {
                this.visibility = visibility;
            }

            @Override
            public ClassMemberForwardDeclaration create(CsmParserProvider.ParserErrorDelegate delegate) {
                TemplateDescriptor td = null;
                if (this.getTemplateDescriptorBuilder() != null) {
                    this.getTemplateDescriptorBuilder().setScope(this.getScope());
                    td = this.getTemplateDescriptorBuilder().create();
                }
                ClassMemberForwardDeclaration fc = new ClassMemberForwardDeclaration(this.getName(), td, (CsmClass)this.getScope(), this.visibility, this.getFile(), this.getStartOffset(), this.getEndOffset());
                ClassMemberForwardDeclaration.postObjectCreateRegistration(this.isGlobal(), fc);
                return fc;
            }
        }
    }

    public static interface MemberForwardDeclaration {
    }

    public static final class MemberTypeAliasImpl
    extends TypeAliasImpl
    implements CsmMember {
        private final CsmVisibility visibility;

        public static MemberTypeAliasImpl create(CsmFile file, CsmClass containingClass, AST ast, CsmType type, CharSequence name, CsmVisibility curentVisibility, boolean global) {
            MemberTypeAliasImpl memberTypedef = new MemberTypeAliasImpl(file, containingClass, ast, type, name, curentVisibility);
            if (!global) {
                Utils.setSelfUID(memberTypedef);
            }
            return memberTypedef;
        }

        private MemberTypeAliasImpl(CsmFile file, CsmClass containingClass, AST ast, CsmType type, CharSequence name, CsmVisibility curentVisibility) {
            super(ast, file, (CsmObject)containingClass, type, name);
            this.visibility = curentVisibility;
        }

        private MemberTypeAliasImpl(CsmType type, CharSequence name, CsmVisibility visibility, CsmClass containingClass, CsmFile file, int startOffset, int endOffset) {
            super(type, name, (CsmObject)containingClass, file, startOffset, endOffset);
            this.visibility = visibility;
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        public CsmClass getContainingClass() {
            return (CsmClass)this.getScope();
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, output);
        }

        public MemberTypeAliasImpl(RepositoryDataInput input) throws IOException {
            super(input);
            this.visibility = PersistentUtils.readVisibility(input);
            assert (this.visibility != null);
        }
    }

    public static final class MemberTypedef
    extends TypedefImpl
    implements CsmMember {
        private final CsmVisibility visibility;

        private MemberTypedef(CsmFile file, CsmClass containingClass, AST ast, CsmType type, CharSequence name, CsmVisibility curentVisibility) {
            super(ast, file, (CsmObject)containingClass, type, name);
            this.visibility = curentVisibility;
        }

        public static MemberTypedef create(CsmFile file, CsmClass containingClass, AST ast, CsmType type, CharSequence name, CsmVisibility curentVisibility, boolean global) {
            MemberTypedef memberTypedef = new MemberTypedef(file, containingClass, ast, type, name, curentVisibility);
            if (!global) {
                Utils.setSelfUID(memberTypedef);
            }
            return memberTypedef;
        }

        private MemberTypedef(CsmType type, CharSequence name, CsmVisibility visibility, CsmClass containingClass, CsmFile file, int startOffset, int endOffset) {
            super(type, name, (CsmObject)containingClass, file, startOffset, endOffset);
            this.visibility = visibility;
        }

        public boolean isStatic() {
            return false;
        }

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        public CsmClass getContainingClass() {
            return (CsmClass)this.getScope();
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
            assert (this.visibility != null);
            PersistentUtils.writeVisibility(this.visibility, output);
        }

        public MemberTypedef(RepositoryDataInput input) throws IOException {
            super(input);
            this.visibility = PersistentUtils.readVisibility(input);
            assert (this.visibility != null);
        }

        public static class MemberTypedefBuilder
        extends TypedefImpl.TypedefBuilder
        implements CsmObjectBuilder,
        MemberBuilder {
            private CsmVisibility visibility = CsmVisibility.PUBLIC;

            public MemberTypedefBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
                super(builder);
            }

            @Override
            public void setVisibility(CsmVisibility visibility) {
                this.visibility = visibility;
            }

            @Override
            public MemberTypedef create(CsmParserProvider.ParserErrorDelegate delegate) {
                CsmClass cls = (CsmClass)this.getScope();
                CsmType type = null;
                if (this.getTypeBuilder() != null) {
                    this.getTypeBuilder().setScope(this.getScope());
                    type = this.getTypeBuilder().create();
                }
                if (type == null) {
                    type = TypeFactory.createSimpleType((CsmClassifier)BuiltinTypes.getBuiltIn("int"), this.getFile(), this.getStartOffset(), this.getStartOffset());
                }
                MemberTypedef td = new MemberTypedef(type, this.getName(), this.visibility, cls, this.getFile(), this.getStartOffset(), this.getEndOffset());
                if (!this.isGlobal()) {
                    Utils.setSelfUID(td);
                }
                return td;
            }
        }
    }

    private class ClassAstRenderer
    extends AstRenderer {
        private final DeclarationsContainer container;
        private final boolean renderingLocalContext;
        private CsmVisibility curentVisibility;

        public ClassAstRenderer(CsmFile containingFile, String language, FileContent fileContent, CsmVisibility curentVisibility, boolean renderingLocalContext, DeclarationsContainer parentContainer) {
            super((FileImpl)containingFile, fileContent, language, null);
            this.renderingLocalContext = renderingLocalContext;
            this.curentVisibility = curentVisibility;
            this.container = parentContainer;
        }

        @Override
        protected boolean isRenderingLocalContext() {
            return this.renderingLocalContext;
        }

        protected VariableImpl<CsmField> createVariable(AST offsetAst, CsmFile file, CsmType type, NameHolder name, boolean _static, boolean _extern, MutableDeclarationsContainer container1, MutableDeclarationsContainer container2, CsmScope scope) {
            type = TemplateUtils.checkTemplateType(type, ClassImpl.this);
            FieldImpl field = FieldImpl.create(offsetAst, file, this.fileContent, type, name, ClassImpl.this, this.curentVisibility, _static, _extern, !this.isRenderingLocalContext());
            ClassImpl.this.addMember((CsmMember)field, !this.isRenderingLocalContext());
            return field;
        }

        @Override
        public void render(AST ast) {
            block26: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
                try {
                    switch (token.getType()) {
                        case 117: {
                            List<CsmTemplateParameter> params = TemplateUtils.getTemplateParameters(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                            CharSequence classSpecializationSuffix = TemplateUtils.getClassSpecializationSuffix(token, null);
                            CharSequence name = CharSequenceUtils.concatenate((CharSequence)"<", (CharSequence)classSpecializationSuffix, (CharSequence)">");
                            this.setTemplateDescriptor(params, name, classSpecializationSuffix.length() > 0);
                            break;
                        }
                        case 611: {
                            ClassImpl.this.addInheritance(InheritanceImpl.create(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 159: {
                            break;
                        }
                        case 161: {
                            this.curentVisibility = CsmVisibility.PUBLIC;
                            break;
                        }
                        case 160: {
                            this.curentVisibility = CsmVisibility.PUBLIC;
                            break;
                        }
                        case 165: {
                            this.curentVisibility = CsmVisibility.PUBLIC;
                            break;
                        }
                        case 167: {
                            this.curentVisibility = CsmVisibility.PRIVATE;
                            break;
                        }
                        case 166: {
                            this.curentVisibility = CsmVisibility.PROTECTED;
                            break;
                        }
                        case 522: 
                        case 547: {
                            ClassImpl currentScope = ClassImpl.this;
                            DeclarationsContainer currentContainer = ClassImpl.this;
                            if (APTLanguageSupport.getInstance().isLanguageC(this.language)) {
                                if (!this.isRenderingLocalContext()) {
                                    currentScope = this.getContainingFile().getProject().getGlobalNamespace();
                                    currentContainer = this.getFileContent();
                                } else {
                                    currentScope = null;
                                    currentContainer = this.container;
                                }
                            }
                            ClassImpl innerClass = this.createClass(token, (CsmScope)currentScope, currentContainer);
                            this.processClassEnum(innerClass, token);
                            break;
                        }
                        case 523: {
                            EnumImpl innerEnum = this.createEnum(token, (CsmScope)ClassImpl.this, ClassImpl.this);
                            this.processClassEnum(innerEnum, token);
                            this.checkInnerIncludes(innerEnum, Collections.emptyList());
                            break;
                        }
                        case 524: {
                            Object fd = this.renderEnumForwardDeclaration(token);
                            if (fd == null) break;
                            ClassImpl.this.addMember((CsmMember)fd, !this.isRenderingLocalContext());
                            ((EnumForwardDeclarationImpl)fd).init(token, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                            break;
                        }
                        case 553: 
                        case 554: {
                            ClassImpl.this.addMember((CsmMember)ConstructorDDImpl.createConstructor(token, this.getContainingFile(), this.fileContent, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 526: 
                        case 527: {
                            ClassImpl.this.addMember((CsmMember)ConstructorImpl.createConstructor(token, this.getContainingFile(), this.fileContent, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 550: 
                        case 551: {
                            ClassImpl.this.addMember((CsmMember)DestructorDDImpl.createDestructor(token, this.getContainingFile(), this.fileContent, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 552: {
                            ClassImpl.this.addMember((CsmMember)DestructorImpl.createDestructor(token, this.getContainingFile(), this.fileContent, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 562: {
                            AST child = token.getFirstChild();
                            if (this.hasFriendPrefix(child)) {
                                ClassImpl.this.addFriend(this.renderFriendClass(token), !this.isRenderingLocalContext());
                                break;
                            }
                            if (this.renderVariable(token, null, null, (CsmScope)ClassImpl.this.getContainingNamespaceImpl(), false)) break;
                            AstRenderer.Pair typedefs = this.renderTypedef(token, (FileImpl)this.getContainingFile(), this.fileContent, (CsmScope)ClassImpl.this, null);
                            if (!typedefs.getTypesefs().isEmpty()) {
                                for (CsmTypedef typedef : typedefs.getTypesefs()) {
                                    if (!this.isRenderingLocalContext()) {
                                        ((FileImpl)this.getContainingFile()).getProjectImpl(true).registerDeclaration((CsmOffsetableDeclaration)typedef);
                                    }
                                    ClassImpl.this.addMember((CsmMember)typedef, !this.isRenderingLocalContext());
                                    if (typedefs.getEnclosingClassifier() == null) continue;
                                    typedefs.getEnclosingClassifier().addEnclosingTypedef(typedef);
                                }
                                if (typedefs.getEnclosingClassifier() == null || ForwardClass.isForwardClass(typedefs.getEnclosingClassifier())) break;
                                ClassImpl.this.addMember(typedefs.getEnclosingClassifier(), !this.isRenderingLocalContext());
                                break;
                            }
                            if (this.renderBitField(token)) break;
                            Object fd = this.renderClassForwardDeclaration(token);
                            if (fd == null) continue block26;
                            ClassImpl.this.addMember((CsmMember)fd, !this.isRenderingLocalContext());
                            ((ClassForwardDeclarationImpl)fd).init(token, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                            break;
                        }
                        case 570: {
                            UsingDeclarationImpl using = UsingDeclarationImpl.create(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext(), this.curentVisibility);
                            ClassImpl.this.addMember(using, !this.isRenderingLocalContext());
                            break;
                        }
                        case 560: {
                            AST child = token.getFirstChild();
                            if (this.hasFriendPrefix(child)) {
                                ClassImpl.this.addFriend(this.renderFriendClass(token), !this.isRenderingLocalContext());
                                break;
                            }
                            Object fd = this.renderClassForwardDeclaration(token);
                            if (fd == null) continue block26;
                            ClassImpl.this.addMember((CsmMember)fd, !this.isRenderingLocalContext());
                            ((ClassForwardDeclarationImpl)fd).init(token, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
                            break;
                        }
                        case 528: 
                        case 531: 
                        case 533: 
                        case 555: 
                        case 556: {
                            FunctionImpl friend;
                            FunctionImpl func;
                            FunctionImpl impl;
                            CsmScope scope;
                            AST child = token.getFirstChild();
                            if (child == null) break;
                            if (this.hasFriendPrefix(child)) {
                                scope = this.getFriendScope();
                                if (this.isMemberDefinition(token)) {
                                    func = impl = FriendFunctionImplEx.create(token, this.getContainingFile(), this.fileContent, ClassImpl.this, scope, !this.isRenderingLocalContext());
                                    friend = impl;
                                } else {
                                    friend = impl = FriendFunctionImpl.create(token, this.getContainingFile(), this.fileContent, ClassImpl.this, scope, !this.isRenderingLocalContext());
                                    func = impl;
                                    if (!this.isRenderingLocalContext()) {
                                        if (scope instanceof NamespaceImpl) {
                                            ((NamespaceImpl)scope).addDeclaration(func);
                                        } else {
                                            ((NamespaceImpl)this.getContainingFile().getProject().getGlobalNamespace()).addDeclaration(func);
                                        }
                                    }
                                }
                                ClassImpl.this.addFriend((CsmFriend)friend, !this.isRenderingLocalContext());
                                break;
                            }
                            ClassImpl.this.addMember((CsmMember)MethodImpl.create(token, this.getContainingFile(), this.fileContent, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 530: 
                        case 532: 
                        case 534: 
                        case 557: 
                        case 558: {
                            FunctionImpl friend;
                            FunctionImpl func;
                            FunctionImpl impl;
                            CsmScope scope;
                            AST child = token.getFirstChild();
                            if (this.hasFriendPrefix(child)) {
                                scope = this.getFriendScope();
                                if (this.isMemberDefinition(token)) {
                                    func = impl = FriendFunctionDefinitionImpl.create(token, this.getContainingFile(), this.fileContent, ClassImpl.this, null, !this.isRenderingLocalContext());
                                    friend = impl;
                                } else {
                                    friend = impl = FriendFunctionDDImpl.create(token, this.getContainingFile(), this.fileContent, ClassImpl.this, scope, !this.isRenderingLocalContext());
                                    func = impl;
                                    if (!this.isRenderingLocalContext()) {
                                        if (scope instanceof NamespaceImpl) {
                                            ((NamespaceImpl)scope).addDeclaration(func);
                                        } else {
                                            ((NamespaceImpl)this.getContainingFile().getProject().getGlobalNamespace()).addDeclaration(func);
                                        }
                                    }
                                }
                                ClassImpl.this.addFriend((CsmFriend)friend, !this.isRenderingLocalContext());
                                break;
                            }
                            ClassImpl.this.addMember((CsmMember)MethodDDImpl.create(token, this.getContainingFile(), this.fileContent, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext()), !this.isRenderingLocalContext());
                            break;
                        }
                        case 563: {
                            UsingDeclarationImpl using = UsingDeclarationImpl.create(token, this.getContainingFile(), (CsmScope)ClassImpl.this, !this.isRenderingLocalContext(), this.curentVisibility);
                            ClassImpl.this.addMember(using, !this.isRenderingLocalContext());
                            break;
                        }
                        case 17: {
                            break;
                        }
                    }
                    continue;
                }
                catch (AstRendererException e) {
                    DiagnosticExceptoins.register(e);
                }
            }
            this.checkInnerIncludes(ClassImpl.this, ClassImpl.this.getMembers());
        }

        private void processClassEnum(ClassEnumBase innerClassEnum, AST innerClassAST) {
            if (innerClassEnum != null) {
                AstRenderer.Pair typedefs = this.renderTypedef(innerClassAST, innerClassEnum, ClassImpl.this);
                if (!typedefs.getTypesefs().isEmpty()) {
                    for (CsmTypedef typedef : typedefs.getTypesefs()) {
                        if (!this.isRenderingLocalContext()) {
                            ((FileImpl)this.getContainingFile()).getProjectImpl(true).registerDeclaration((CsmOffsetableDeclaration)typedef);
                        }
                        ClassImpl.this.addMember((CsmMember)typedef, !this.isRenderingLocalContext());
                        if (typedefs.getEnclosingClassifier() == null) continue;
                        typedefs.getEnclosingClassifier().addEnclosingTypedef(typedef);
                    }
                    if (typedefs.getEnclosingClassifier() != null && !ForwardClass.isForwardClass(typedefs.getEnclosingClassifier())) {
                        ClassImpl.this.addMember(typedefs.getEnclosingClassifier(), !this.isRenderingLocalContext());
                    }
                }
                this.renderVariableInClassifier(innerClassAST, innerClassEnum, null, null);
            }
        }

        private CsmScope getFriendScope() {
            CsmScope newScope;
            CsmScope scope = ClassImpl.this.getScope();
            while (CsmKindUtilities.isClass((CsmObject)scope) && (newScope = ((CsmClass)scope).getScope()) != null) {
                scope = newScope;
            }
            return scope;
        }

        @Override
        protected EnumImpl createEnum(AST token, CsmScope scope, DeclarationsContainer container) {
            EnumImpl innerEnum = EnumImpl.create(token, scope, this.getContainingFile(), this.fileContent, !this.isRenderingLocalContext());
            innerEnum.setVisibility(this.curentVisibility);
            ClassImpl.this.addMember(innerEnum, !this.isRenderingLocalContext());
            return innerEnum;
        }

        @Override
        protected ClassImpl createClass(AST token, CsmScope innerScope, DeclarationsContainer container) throws AstRendererException {
            ClassImpl innerClass;
            ClassImpl classImpl = TemplateUtils.isPartialClassSpecialization(token) ? ClassImplSpecialization.create(token, innerScope, this.getContainingFile(), this.language, this.getFileContent(), !this.isRenderingLocalContext(), container) : (innerClass = ClassImpl.create(token, innerScope, this.getContainingFile(), this.language, this.getFileContent(), !this.isRenderingLocalContext(), container));
            if (innerClass != null) {
                innerClass.setVisibility(this.curentVisibility);
                if (innerScope == ClassImpl.this) {
                    ClassImpl.this.addMember(innerClass, !this.isRenderingLocalContext());
                } else {
                    assert (APTLanguageSupport.getInstance().isLanguageC(this.language));
                    if (container instanceof MutableDeclarationsContainer) {
                        ((MutableDeclarationsContainer)container).addDeclaration(innerClass);
                    }
                }
            }
            return innerClass;
        }

        private void setTemplateDescriptor(List<CsmTemplateParameter> params, CharSequence name, boolean specialization) {
            ClassImpl.this.templateDescriptor = new TemplateDescriptor(params, name, specialization, !this.isRenderingLocalContext());
        }

        private boolean hasFriendPrefix(AST child) {
            AST nextSibling;
            if (child == null) {
                return false;
            }
            if (child.getType() == 128) {
                return true;
            }
            return child.getType() == 117 && (nextSibling = child.getNextSibling()) != null && nextSibling.getType() == 128;
        }

        private CsmFriend renderFriendClass(AST ast) throws AstRendererException {
            AST firstChild = ast.getFirstChild();
            AST child = firstChild;
            if (child.getType() == 128) {
                child = child.getNextSibling();
            }
            if (child != null && child.getType() == 131) {
                child = child.getNextSibling();
            }
            if (child != null && child.getType() == 117) {
                child = child.getNextSibling();
            }
            CsmClassForwardDeclaration cfd = null;
            AST qid = null;
            if (child != null && (child.getType() == 160 || child.getType() == 159)) {
                AST templStart;
                qid = AstUtil.findChildOfType(ast, 574);
                CharSequence[] nameParts = AstRenderer.getNameTokens(qid);
                if (nameParts != null && nameParts.length == 1 && (templStart = TemplateUtils.getTemplateStart(ast.getFirstChild())) == null) {
                    CsmScope scope = ClassImpl.this.getScope();
                    while (!CsmKindUtilities.isNamespace((Object)scope) && CsmKindUtilities.isScopeElement((CsmObject)scope)) {
                        scope = ((CsmScopeElement)scope).getScope();
                    }
                    if (!CsmKindUtilities.isNamespace((Object)scope)) {
                        scope = this.getContainingFile().getProject().getGlobalNamespace();
                    }
                    cfd = super.createForwardClassDeclaration(ast, null, (FileImpl)this.getContainingFile(), scope);
                    if (!this.isRenderingLocalContext()) {
                        RepositoryUtils.put(cfd);
                        ((NamespaceImpl)scope).addDeclaration((CsmOffsetableDeclaration)cfd);
                    }
                }
            } else {
                qid = child != null && child.getType() == 539 ? child : AstUtil.findChildOfType(ast, 574);
            }
            return FriendClassImpl.create(firstChild, qid, cfd, (FileImpl)this.getContainingFile(), ClassImpl.this, !this.isRenderingLocalContext());
        }

        private ClassMemberForwardDeclaration renderClassForwardDeclaration(AST token) {
            AST typeAST = token.getFirstChild();
            if (typeAST == null) {
                return null;
            }
            if (typeAST.getType() == 117) {
                typeAST = typeAST.getNextSibling();
            }
            if (typeAST == null || typeAST.getType() != 160 && typeAST.getType() != 159) {
                return null;
            }
            AST idAST = typeAST.getNextSibling();
            if (idAST == null || idAST.getType() != 574) {
                return null;
            }
            return ClassMemberForwardDeclaration.create(this.getContainingFile(), ClassImpl.this, token, this.curentVisibility, !this.isRenderingLocalContext());
        }

        private EnumMemberForwardDeclaration renderEnumForwardDeclaration(AST token) {
            AST typeAST = token.getFirstChild();
            if (typeAST == null) {
                return null;
            }
            if (typeAST.getType() == 117) {
                typeAST = typeAST.getNextSibling();
            }
            if (typeAST == null || typeAST.getType() != 119) {
                return null;
            }
            AST idAST = typeAST.getNextSibling();
            if (idAST != null && (idAST.getType() == 160 || idAST.getType() == 159)) {
                idAST = idAST.getNextSibling();
            }
            if (idAST == null || idAST.getType() != 574 && idAST.getType() != 91) {
                return null;
            }
            if (!EnumMemberForwardDeclaration.isCorrectOpaqueEnumDeclaration(token)) {
                return null;
            }
            return EnumMemberForwardDeclaration.create(this.getContainingFile(), ClassImpl.this, token, this.curentVisibility, !this.isRenderingLocalContext());
        }

        private boolean renderBitField(AST token) {
            AST typeAST = token.getFirstChild();
            if (typeAST == null) {
                return false;
            }
            if ((typeAST = ClassAstRenderer.getFirstSiblingSkipQualifiers(typeAST)) == null) {
                return false;
            }
            if (typeAST.getType() != 536) {
                if (typeAST.getType() == 119) {
                    typeAST = typeAST.getNextSibling();
                }
                if (typeAST == null || typeAST.getType() != 574 && typeAST.getType() != 539) {
                    return false;
                }
            }
            TypeImpl type = TypeFactory.createType(typeAST, this.getContainingFile(), null, 0);
            if ((typeAST = ClassAstRenderer.getFirstSiblingSkipQualifiers(typeAST.getNextSibling())) == null) {
                return false;
            }
            boolean bitFieldAdded = this.renderBitFieldImpl(token, typeAST, type, null);
            return bitFieldAdded;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean renderBitFieldImpl(AST startOffsetAST, AST idAST, CsmType type, ClassEnumBase<?> classifier) {
            boolean cont = true;
            boolean added = false;
            AST start = startOffsetAST;
            AST prev = idAST;
            while (cont) {
                AST expAST;
                void var10_10;
                AST colonAST;
                boolean unnamed = false;
                if (idAST == null) break;
                if (idAST.getType() == 91) {
                    colonAST = idAST.getNextSibling();
                } else {
                    if (idAST.getType() != 7) break;
                    colonAST = idAST;
                    unnamed = true;
                }
                if (var10_10 == null || var10_10.getType() != 7 || (expAST = var10_10.getNextSibling()) == null || expAST.getType() != 599) break;
                prev = expAST.getNextSibling();
                if (prev != null && prev.getType() == 8) {
                    start = idAST;
                } else {
                    cont = false;
                    if (added) {
                        start = idAST;
                    }
                }
                if (!unnamed) {
                    NameHolder nameHolder = NameHolder.createSimpleName(idAST);
                    FieldImpl field = FieldImpl.create(start, this.getContainingFile(), this.fileContent, type, nameHolder, ClassImpl.this, this.curentVisibility, !this.isRenderingLocalContext());
                    ClassImpl.this.addMember((CsmMember)field, !this.isRenderingLocalContext());
                    if (classifier != null) {
                        classifier.addEnclosingVariable(field);
                    }
                }
                added = true;
                if (!cont) continue;
                idAST = prev.getNextSibling();
            }
            return added;
        }

        @Override
        protected CsmTypedef createTypedef(AST ast, FileImpl file, CsmObject container, CsmType type, CharSequence name) {
            type = TemplateUtils.checkTemplateType(type, ClassImpl.this);
            return MemberTypedef.create(this.getContainingFile(), ClassImpl.this, ast, type, name, this.curentVisibility, !this.isRenderingLocalContext());
        }

        @Override
        protected CsmTypeAlias createTypeAlias(AST ast, FileImpl file, CsmObject container, CsmType type, CharSequence name) {
            type = TemplateUtils.checkTemplateType(type, ClassImpl.this);
            return MemberTypeAliasImpl.create(this.getContainingFile(), ClassImpl.this, ast, type, name, this.curentVisibility, !this.isRenderingLocalContext());
        }

        @Override
        protected CsmClassForwardDeclaration createForwardClassDeclaration(AST ast, MutableDeclarationsContainer container, FileImpl file, CsmScope scope) {
            ClassMemberForwardDeclaration fd = ClassMemberForwardDeclaration.create(this.getContainingFile(), ClassImpl.this, ast, this.curentVisibility, !this.isRenderingLocalContext());
            ClassImpl.this.addMember(fd, !this.isRenderingLocalContext());
            fd.init(ast, (CsmScope)ClassImpl.this, !this.isRenderingLocalContext());
            return fd;
        }
    }

    public static class ClassBuilder
    extends OffsetableDeclarationBase.SimpleDeclarationBuilder
    implements MemberBuilder {
        private CsmDeclaration.Kind kind = CsmDeclaration.Kind.CLASS;
        private List<MemberBuilder> memberBuilders = new ArrayList<MemberBuilder>();
        private List<OffsetableDeclarationBase.SimpleDeclarationBuilder> friendBuilders = new ArrayList<OffsetableDeclarationBase.SimpleDeclarationBuilder>();
        private List<InheritanceImpl.InheritanceBuilder> inheritanceBuilders = new ArrayList<InheritanceImpl.InheritanceBuilder>();
        private ClassImpl instance;
        private CsmVisibility visibility = CsmVisibility.PUBLIC;
        private CsmVisibility currentMemberVisibility = CsmVisibility.PUBLIC;
        private int leftBracketPos;

        public ClassBuilder() {
        }

        protected ClassBuilder(ClassBuilder builder) {
            super(builder);
            this.kind = builder.kind;
            this.memberBuilders = builder.memberBuilders;
            this.inheritanceBuilders = builder.inheritanceBuilders;
        }

        @Override
        public void setVisibility(CsmVisibility visibility) {
            this.visibility = visibility;
        }

        public void setCurrentMemberVisibility(CsmVisibility visibility) {
            this.currentMemberVisibility = visibility;
        }

        public CsmVisibility getCurrentMemberVisibility() {
            return this.currentMemberVisibility;
        }

        public void setKind(CsmDeclaration.Kind kind) {
            this.kind = kind;
            switch (kind) {
                case CLASS: {
                    this.setCurrentMemberVisibility(CsmVisibility.PRIVATE);
                    break;
                }
                case STRUCT: 
                case UNION: {
                    this.setCurrentMemberVisibility(CsmVisibility.PUBLIC);
                }
            }
        }

        public void setLeftBracketPos(int leftBracketPos) {
            this.leftBracketPos = leftBracketPos;
        }

        public CsmDeclaration.Kind getKind() {
            return this.kind;
        }

        public void addMemberBuilder(MemberBuilder builder) {
            this.memberBuilders.add(builder);
        }

        public void addFriendBuilder(OffsetableDeclarationBase.SimpleDeclarationBuilder builder) {
            this.friendBuilders.add(builder);
        }

        public List<MemberBuilder> getMemberBuilders() {
            return this.memberBuilders;
        }

        public List<OffsetableDeclarationBase.SimpleDeclarationBuilder> getFriendBuilders() {
            return this.friendBuilders;
        }

        public void addInheritanceBuilder(InheritanceImpl.InheritanceBuilder i) {
            this.inheritanceBuilders.add(i);
        }

        public List<InheritanceImpl.InheritanceBuilder> getInheritanceBuilders() {
            return this.inheritanceBuilders;
        }

        private ClassImpl getClassDefinitionInstance() {
            CsmOffsetableDeclaration decl;
            if (this.instance != null) {
                return this.instance;
            }
            MutableDeclarationsContainer container = null;
            if (this.getParent() == null) {
                container = this.getFileContent();
            } else if (this.getParent() instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                container = ((NamespaceDefinitionImpl.NamespaceBuilder)this.getParent()).getNamespaceDefinitionInstance();
            }
            if (container != null && this.getName() != null && (decl = container.findExistingDeclaration(this.getStartOffset(), this.getName(), this.getKind())) != null && ClassImpl.class.equals(decl.getClass())) {
                this.instance = (ClassImpl)decl;
            }
            return this.instance;
        }

        @Override
        public ClassImpl create(CsmParserProvider.ParserErrorDelegate delegate) {
            ClassImpl cls = this.getClassDefinitionInstance();
            CsmScope s = this.getScope();
            if (cls == null && s != null && this.getName() != null && this.getEndOffset() != 0) {
                InheritanceImpl inst;
                this.instance = cls = new ClassImpl(this.getNameHolder(), this.getKind(), this.leftBracketPos, this.getFile(), this.getStartOffset(), this.getEndOffset());
                cls.setVisibility(this.visibility);
                cls.init3(s, this.isGlobal());
                if (this.getTemplateDescriptorBuilder() != null) {
                    cls.setTemplateDescriptor(this.getTemplateDescriptor());
                }
                for (InheritanceImpl.InheritanceBuilder inheritanceBuilder : this.getInheritanceBuilders()) {
                    inheritanceBuilder.setScope((CsmScope)cls);
                    inst = inheritanceBuilder.create();
                    cls.addInheritance(inst, this.isGlobal());
                }
                for (MemberBuilder memberBuilder : this.getMemberBuilders()) {
                    memberBuilder.setScope((CsmScope)cls);
                    inst = memberBuilder.create(delegate);
                    if (inst != null) {
                        cls.addMember((CsmMember)inst, this.isGlobal());
                        continue;
                    }
                    CsmParserProvider.registerParserError(delegate, "Skip unrecognized member for builder '" + memberBuilder, this.getFile(), ClassBuilder.getStartOffsetImpl(memberBuilder, this));
                }
                for (OffsetableDeclarationBase.SimpleDeclarationBuilder simpleDeclarationBuilder : this.getFriendBuilders()) {
                    simpleDeclarationBuilder.setScope((CsmScope)cls);
                    inst = (CsmFriend)simpleDeclarationBuilder.create();
                    if (inst == null) continue;
                    cls.addFriend((CsmFriend)inst, this.isGlobal());
                }
                this.getNameHolder().addReference(this.getFileContent(), cls);
                this.addDeclaration(cls);
            }
            return cls;
        }

        @Override
        public String toString() {
            return "ClassBuilder{kind=" + this.kind + ", memberBuilders=" + this.memberBuilders + ", friendBuilders=" + this.friendBuilders + ", inheritanceBuilders=" + this.inheritanceBuilders + ", instance=" + this.instance + super.toString() + '}';
        }

        public static int getStartOffsetImpl(MemberBuilder child, OffsetableBase.OffsetableBuilder parent) {
            int startOffset = -1;
            if (child instanceof OffsetableBase.OffsetableBuilder) {
                startOffset = ((OffsetableBase.OffsetableBuilder)((Object)child)).getStartOffset();
            }
            if (startOffset < 0) {
                startOffset = parent.getStartOffset();
            }
            return startOffset;
        }
    }

    public static interface MemberBuilder {
        public CsmMember create(CsmParserProvider.ParserErrorDelegate var1);

        public void setScope(CsmScope var1);

        public void setVisibility(CsmVisibility var1);
    }
}

