/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.util.WeakList;

public class ParseFinishNotificator {
    private static final ParseFinishNotificator instance = new ParseFinishNotificator();
    private final WeakList<CsmProject> waitingProjects = new WeakList();

    private ParseFinishNotificator() {
    }

    public static ParseFinishNotificator instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onParseFinish(CsmProject project) {
        ParseFinishNotificator parseFinishNotificator = instance;
        synchronized (parseFinishNotificator) {
            ParseFinishNotificator.instance.waitingProjects.remove(project);
            if (ParseFinishNotificator.areProjectAndLibsParsed(project)) {
                if (project instanceof ProjectBase) {
                    ((ProjectBase)project).onLibParseFinish();
                }
                for (CsmProject lib : ParseFinishNotificator.instance.waitingProjects) {
                    if (!ParseFinishNotificator.isProjectsLib(lib, project) || !ParseFinishNotificator.areProjectAndLibsParsed(lib) || !(lib instanceof ProjectBase)) continue;
                    ParseFinishNotificator.instance.waitingProjects.remove(lib);
                    ((ProjectBase)lib).onLibParseFinish();
                }
            } else if (project.isStable(null)) {
                ParseFinishNotificator.instance.waitingProjects.add(project);
            }
        }
    }

    private static boolean isProjectsLib(CsmProject project, CsmProject lib) {
        if (project.equals(lib)) {
            return false;
        }
        HashSet<CsmProject> visited = new HashSet<CsmProject>();
        visited.add(project);
        return ParseFinishNotificator.isProjectInLibs(lib, project.getLibraries(), visited);
    }

    private static boolean isProjectInLibs(CsmProject project, Collection<CsmProject> libs, Collection<CsmProject> visited) {
        if (libs != null) {
            for (CsmProject lib : libs) {
                if (visited.contains(lib)) continue;
                visited.add(lib);
                if (!project.equals(lib) && !ParseFinishNotificator.isProjectInLibs(project, lib.getLibraries(), visited)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean areProjectAndLibsParsed(CsmProject project) {
        if (!project.isStable(null)) {
            return false;
        }
        HashSet<CsmProject> visited = new HashSet<CsmProject>();
        visited.add(project);
        return ParseFinishNotificator.areProjectLibsParsed(project.getLibraries(), visited);
    }

    private static boolean areProjectLibsParsed(Collection<CsmProject> libs, Collection<CsmProject> visited) {
        if (libs != null) {
            for (CsmProject lib : libs) {
                if (visited.contains(lib)) continue;
                visited.add(lib);
                if (lib.isStable(null) && ParseFinishNotificator.areProjectLibsParsed(lib.getLibraries(), visited)) continue;
                return false;
            }
        }
        return true;
    }
}

