/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

public class ParseStatistics {
    private static final ParseStatistics instance = new ParseStatistics();
    private Map<CsmUID<CsmProject>, Map<CsmUID<CsmFile>, Entry>> projectMaps = null;
    private boolean enabled = false;

    public static ParseStatistics getInstance() {
        return instance;
    }

    private ParseStatistics() {
        if (TraceFlags.PARSE_STATISTICS) {
            this.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEnabled(boolean on) {
        if (on != this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                this.enabled = on;
                this.projectMaps = on ? new HashMap<CsmUID<CsmProject>, Map<CsmUID<CsmFile>, Entry>>() : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileParsed(FileImpl file) {
        if (this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                ++this.getEntry((FileImpl)file).cnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParseCount(FileImpl file) {
        if (this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                return this.getEntry((FileImpl)file).cnt;
            }
        }
        return 0;
    }

    private Entry getEntry(FileImpl file) {
        Map<CsmUID<CsmFile>, Entry> map = this.getProjectMap(file.getProjectUID());
        Entry entry = map.get(file.getUID());
        if (entry == null) {
            entry = new Entry();
            map.put(file.getUID(), entry);
        }
        return entry;
    }

    private Map<CsmUID<CsmFile>, Entry> getProjectMap(CsmUID<CsmProject> projectUID) {
        Map<CsmUID<CsmFile>, Entry> map = this.projectMaps.get(projectUID);
        if (map == null) {
            map = new HashMap<CsmUID<CsmFile>, Entry>();
            this.projectMaps.put(projectUID, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                this.projectMaps.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(CsmProject project) {
        if (this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                this.projectMaps.remove(UIDs.get((Object)project));
            }
        }
    }

    public void printResults(CsmProject project) {
        this.printResults(project, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printResults(CsmProject project, PrintWriter out) {
        if (this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                this.printResults((CsmUID<CsmProject>)UIDs.get((Object)project), out);
            }
        } else {
            out.printf("Statistics is disabled", new Object[0]);
        }
        out.flush();
    }

    public void printResults() {
        this.printResults(new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printResults(PrintWriter out) {
        out.printf("%nPARSING STATISTICS%n", new Object[0]);
        if (this.enabled) {
            ParseStatistics parseStatistics = this;
            synchronized (parseStatistics) {
                for (CsmUID<CsmProject> projectUID : this.projectMaps.keySet()) {
                    this.printResults(projectUID, out);
                }
            }
        } else {
            out.printf("Statistics is disabled", new Object[0]);
        }
        out.flush();
    }

    private void printResults(CsmUID<CsmProject> projectUID, PrintWriter out) {
        ArrayList<Map.Entry<CsmUID<CsmFile>, Entry>> entries = new ArrayList<Map.Entry<CsmUID<CsmFile>, Entry>>(this.getProjectMap(projectUID).entrySet());
        if (entries.isEmpty()) {
            return;
        }
        out.printf("%nPARSING STATISTICS FOR %s%n", UIDUtilities.getProjectName(projectUID));
        Collections.sort(entries, new Comparator<Map.Entry<CsmUID<CsmFile>, Entry>>(){

            @Override
            public int compare(Map.Entry<CsmUID<CsmFile>, Entry> e1, Map.Entry<CsmUID<CsmFile>, Entry> e2) {
                return e1.getValue().cnt - e2.getValue().cnt;
            }
        });
        int sum = 0;
        for (Map.Entry entry : entries) {
            int cnt = ((Entry)entry.getValue()).cnt;
            out.printf("\t%6d %s%n", cnt, UIDUtilities.getFileName((CsmUID<CsmFile>)((CsmUID)entry.getKey())));
            sum += cnt;
        }
        float avg = entries.isEmpty() ? 0.0f : (float)sum / (float)entries.size();
        out.printf("\t%6.1f avg", Float.valueOf(avg));
        out.printf("%nEND OF PARSING STATISTICS FOR %s%n", UIDUtilities.getProjectName(projectUID));
    }

    private static class Entry {
        public int cnt = 0;

        private Entry() {
        }
    }
}

