/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.editor.CsmDocGeneratorProvider;

public class CsmDocGeneratorProviderImpl
extends CsmDocGeneratorProvider {
    private static final boolean TRACE = false;
    private static final int GAP = "\n/**\n *\n */\n".length();

    public CsmDocGeneratorProvider.Function getFunction(Document doc, int position) {
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)true);
        final CsmOffsetableDeclaration decl = this.getFunction(csmFile, position);
        if (decl instanceof CsmFunction) {
            return new CsmDocGeneratorProvider.Function(){

                public String getName() {
                    return ((CsmFunction)decl).getName().toString();
                }

                public String getSignature() {
                    return ((CsmFunction)decl).getSignature().toString();
                }

                public String getReturnType() {
                    if (CsmKindUtilities.isConstructor((CsmObject)decl) || CsmKindUtilities.isDestructor((CsmObject)decl)) {
                        return null;
                    }
                    return ((CsmFunction)decl).getReturnType().getCanonicalText().toString();
                }

                public List<CsmDocGeneratorProvider.Parameter> getParametes() {
                    ArrayList<CsmDocGeneratorProvider.Parameter> list = new ArrayList<CsmDocGeneratorProvider.Parameter>();
                    for (final CsmParameter par : ((CsmFunction)decl).getParameters()) {
                        list.add(new CsmDocGeneratorProvider.Parameter(){

                            public String getType() {
                                return par.getType().getCanonicalText().toString();
                            }

                            public String getName() {
                                return par.getName().toString();
                            }
                        });
                    }
                    return list;
                }
            };
        }
        return null;
    }

    public CsmOffsetableDeclaration getFunction(CsmFile file, int position) {
        if (file != null) {
            CsmOffsetableDeclaration best = null;
            for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
                if (decl.getStartOffset() <= position && position <= decl.getEndOffset()) {
                    return this.getInternalDeclaration(decl, position);
                }
                if (decl.getStartOffset() <= position - GAP || best != null && best.getStartOffset() <= decl.getStartOffset()) continue;
                best = decl;
            }
            return best;
        }
        return null;
    }

    private CsmOffsetableDeclaration getInternalDeclaration(CsmOffsetableDeclaration parent, int position) {
        if (CsmKindUtilities.isClass((CsmObject)parent)) {
            CsmClass cls = (CsmClass)parent;
            CsmMember best = null;
            for (CsmMember decl : cls.getMembers()) {
                if (decl.getStartOffset() <= position && position <= decl.getEndOffset()) {
                    return this.getInternalDeclaration((CsmOffsetableDeclaration)decl, position);
                }
                if (decl.getStartOffset() <= position - GAP || best != null && best.getStartOffset() <= decl.getStartOffset()) continue;
                best = decl;
            }
            return best;
        }
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)parent)) {
            CsmNamespaceDefinition ns = (CsmNamespaceDefinition)parent;
            CsmOffsetableDeclaration best = null;
            for (CsmOffsetableDeclaration decl : ns.getDeclarations()) {
                if (decl.getStartOffset() < position && position < decl.getEndOffset()) {
                    return this.getInternalDeclaration(decl, position);
                }
                if (decl.getStartOffset() <= position - GAP || best != null && best.getStartOffset() <= decl.getStartOffset()) continue;
                best = decl;
            }
            return best;
        }
        if (CsmKindUtilities.isFunction((CsmObject)parent)) {
            return parent;
        }
        return null;
    }
}

