/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.apt.support.spi.APTFileSearchImplementation;
import org.netbeans.modules.cnd.apt.support.spi.APTProjectFileSearchProvider;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.FSPath;

public class FileSearchProviderImpl
implements APTProjectFileSearchProvider {
    public APTFileSearchImplementation getSearchImplementation(Key prjKey) {
        for (CsmProject project : ModelImpl.instance().projects()) {
            NativeProject nativeProject;
            Key aKey;
            Object platformProject = project.getPlatformProject();
            if (!(platformProject instanceof NativeProject) || !prjKey.equals(aKey = KeyUtilities.createProjectKey(nativeProject = (NativeProject)platformProject))) continue;
            return new APTFileSearchImplementationImpl(nativeProject);
        }
        return null;
    }

    private static final class APTFileSearchImplementationImpl
    implements APTFileSearchImplementation {
        private final NativeProject project;

        private APTFileSearchImplementationImpl(NativeProject project) {
            this.project = project;
        }

        public FSPath searchInclude(String include, CharSequence basePath) {
            Collection searchFile;
            NativeFileSearch provider = NativeProjectSupport.getNativeFileSearch((NativeProject)this.project);
            if (provider != null && (searchFile = provider.searchFile(this.project, include)).size() > 0) {
                include = this.trimUpFolder(include);
                ArrayList<FSPath> candidates = new ArrayList<FSPath>(1);
                for (FSPath p : searchFile) {
                    String path = p.getPath();
                    if (!(path = path.replace('\\', '/')).endsWith(include)) continue;
                    candidates.add(p);
                }
                if (candidates.size() == 1) {
                    return (FSPath)candidates.get(0);
                }
                if (candidates.size() > 1) {
                    int best = -1;
                    FSPath candidate = null;
                    String from = basePath.toString();
                    from = from.replace('\\', '/');
                    for (FSPath p : candidates) {
                        String path = p.getPath();
                        int dist = this.distance(from, path = path.replace('\\', '/'));
                        if (best >= dist) continue;
                        candidate = p;
                        best = dist;
                    }
                    return candidate;
                }
            }
            return null;
        }

        private int distance(String from, String to) {
            int res = 0;
            for (int i = 0; i < Math.min(from.length(), to.length()); ++i) {
                if (from.charAt(i) != to.charAt(i)) {
                    return res;
                }
                ++res;
            }
            return res;
        }

        private String trimUpFolder(String include) {
            while (include.startsWith("../")) {
                include = include.substring(3);
            }
            return include;
        }

        public String toString() {
            return "APTFileSearchImplementationImpl{project=" + this.project + '}';
        }
    }
}

