/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;

public final class IncludeHierarchyResolverImpl
extends CsmIncludeHierarchyResolver {
    public Collection<CsmFile> getFiles(CsmFile referencedFile) {
        CsmProject project = referencedFile.getProject();
        if (project instanceof ProjectBase) {
            return this.getReferences((ProjectBase)project, referencedFile);
        }
        return Collections.emptyList();
    }

    public Collection<CsmReference> getIncludes(CsmFile referencedFile) {
        CsmProject project = referencedFile.getProject();
        if (project instanceof ProjectBase) {
            ArrayList<CsmReference> res = new ArrayList<CsmReference>();
            for (CsmFile file : this.getReferences((ProjectBase)project, referencedFile)) {
                for (CsmInclude include : file.getIncludes()) {
                    if (!referencedFile.equals(include.getIncludeFile())) continue;
                    res.add(CsmReferenceSupport.createObjectReference((CsmObject)include.getIncludeFile(), (CsmOffsetable)include));
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    private Collection<CsmFile> getReferences(ProjectBase project, CsmFile referencedFile) {
        Set<CsmFile> res = CsmCorePackageAccessor.get().getGraph(project).getInLinks(referencedFile);
        for (ProjectBase dependent : project.getDependentProjects()) {
            res.addAll(CsmCorePackageAccessor.get().getGraph(dependent).getInLinks(referencedFile));
        }
        return res;
    }
}

