/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.IncludeKey;
import org.netbeans.modules.cnd.modelimpl.repository.InheritanceKey;
import org.netbeans.modules.cnd.modelimpl.repository.InstantiationKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyManager;
import org.netbeans.modules.cnd.modelimpl.repository.MacroKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableDeclarationKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableKey;
import org.netbeans.modules.cnd.modelimpl.repository.ParamListKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectKey;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class KeyUtilities {
    public static final String UID_INTERNAL_DATA_PREFIX = "###";
    public static final int NON_INITIALIZED = -2147483647;

    private KeyUtilities() {
    }

    public static Key createFileKey(FileImpl file) {
        return KeyManager.instance().getSharedKey(new FileKey(file));
    }

    public static Key createNamespaceKey(CsmNamespace ns) {
        return new NamespaceKey(ns);
    }

    public static UnitDescriptor createUnitDescriptor(FileSystem fs, CharSequence projectNativeRoot) {
        CharSequence uniqueName = ProjectBase.getRepositoryUnitName(fs, projectNativeRoot);
        return new UnitDescriptor(uniqueName, fs);
    }

    public static UnitDescriptor createUnitDescriptor(CharSequence projectQualifiedName, FileSystem fs) {
        return new UnitDescriptor(projectQualifiedName, fs);
    }

    public static UnitDescriptor createUnitDescriptor(NativeProject nativeProject) {
        CharSequence uniqueName = ProjectBase.getRepositoryUnitName(nativeProject.getFileSystem(), nativeProject);
        return new UnitDescriptor(uniqueName, nativeProject.getFileSystem());
    }

    public static Key createLibraryProjectKey(UnitDescriptor unitDescriptor, int storageID) {
        return new ProjectKey(KeyUtilities.getLibraryUnitId(unitDescriptor, storageID));
    }

    public static Key createProjectKey(UnitDescriptor unitDescriptor) {
        return new ProjectKey(KeyUtilities.getUnitId(unitDescriptor));
    }

    public static Key createProjectKey(NativeProject nativeProject) {
        UnitDescriptor unitDescriptor = KeyUtilities.createUnitDescriptor(nativeProject);
        return new ProjectKey(KeyUtilities.getUnitId(unitDescriptor));
    }

    public static Key createProjectKey(ProjectBase project) {
        return new ProjectKey(project.getUnitId());
    }

    public static Key createOffsetableDeclarationKey(OffsetableDeclarationBase<?> obj) {
        assert (obj != null);
        return OffsetableDeclarationKey.createOffsetableDeclarationKey(obj);
    }

    public static Key createUnnamedOffsetableDeclarationKey(OffsetableDeclarationBase<?> obj, int index) {
        assert (obj != null);
        return OffsetableDeclarationKey.createUnnamedOffsetableDeclarationKey(obj, index);
    }

    public static Key createMacroKey(CsmMacro macro) {
        assert (macro != null);
        return new MacroKey(macro);
    }

    public static Key createIncludeKey(CsmInclude incl) {
        assert (incl != null);
        return KeyManager.instance().getSharedKey(new IncludeKey(incl));
    }

    public static Key createInheritanceKey(CsmInheritance inh) {
        assert (inh != null);
        return KeyManager.instance().getSharedKey(InheritanceKey.createInheritanceKey(inh));
    }

    public static <T extends CsmNamedElement> Key createParamListKey(CsmParameterList<T> paramList) {
        assert (paramList != null);
        return new ParamListKey(paramList);
    }

    public static Key createInstantiationKey(CsmInstantiation inst) {
        assert (inst != null);
        return new InstantiationKey(inst);
    }

    public static int getUnitId(UnitDescriptor unitDescriptor) {
        return Repository.getUnitId((UnitDescriptor)unitDescriptor);
    }

    public static int getLibraryUnitId(UnitDescriptor unitDescriptor, int storageID) {
        return Repository.getUnitIdForStorage((UnitDescriptor)unitDescriptor, (int)storageID);
    }

    public static CharSequence getUnitName(int unitIndex) {
        return Repository.getUnitName((int)unitIndex);
    }

    public static CharSequence getUnitNameSafe(int unitIndex) {
        CharSequence unitName = Repository.getUnitName((int)unitIndex);
        return unitName == null ? "Unit-" + unitIndex : unitName;
    }

    public static int getFileIdByName(int unitId, CharSequence fileName) {
        return Repository.getFileIdByName((int)unitId, (CharSequence)fileName);
    }

    public static CharSequence getFileNameByIdSafe(int unitId, int fileId) {
        return Repository.getFileNameByIdSafe((int)unitId, (int)fileId);
    }

    public static CharSequence getFileNameById(int unitId, int fileId) {
        return Repository.getFileNameById((int)unitId, (int)fileId);
    }

    public static CsmDeclaration.Kind getKeyKind(Key key) {
        if (key instanceof OffsetableDeclarationKey) {
            return Utils.getCsmDeclarationKind(((OffsetableDeclarationKey)key).getKind());
        }
        return null;
    }

    public static CsmVisibility getKeyVisibility(Key key) {
        if (key instanceof InheritanceKey) {
            Utils.getCsmVisibility(((InheritanceKey)key).getKind());
        }
        return null;
    }

    public static char getKeyChar(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getKind();
        }
        return '\u0000';
    }

    public static CharSequence getKeyName(Key key) {
        return KeyUtilities.getKeyName(key, false);
    }

    public static CharSequence getKeyName(Key key, boolean internalName) {
        if (key instanceof OffsetableKey) {
            CharSequence name = ((OffsetableKey)key).getName();
            return internalName ? name : KeyUtilities.filterOutInternalData(name);
        }
        if (key instanceof FileKey) {
            FileKey fk = (FileKey)key;
            return KeyUtilities.getFileNameByIdSafe(fk.getUnitId(), fk.getProjectFileIndex());
        }
        if (key instanceof ProjectKey) {
            int unitId = key.getUnitId();
            return KeyUtilities.getUnitNameSafe(unitId);
        }
        return null;
    }

    public static int getProjectFileIndex(Key key) {
        if (key instanceof ProjectFileNameBasedKey) {
            return ((ProjectFileNameBasedKey)key).getProjectFileIndex();
        }
        return -1;
    }

    public static int getProjectIndex(Key key) {
        if (key instanceof ProjectFileNameBasedKey) {
            return ((ProjectFileNameBasedKey)key).getUnitId();
        }
        if (key instanceof ProjectKey) {
            return ((ProjectKey)key).getUnitId();
        }
        return -1;
    }

    public static int getKeyStartOffset(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getStartOffset();
        }
        return -1;
    }

    public static int getKeyEndOffset(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getEndOffset();
        }
        return -1;
    }

    public static void cacheKeyEndOffset(Key key, int endOffset) {
        if (key instanceof OffsetableKey) {
            ((OffsetableKey)key).cacheEndOffset(endOffset);
        }
    }

    private static final CharSequence filterOutInternalData(CharSequence name) {
        int indexOfSignature = CharSequences.indexOf((CharSequence)name, (CharSequence)UID_INTERNAL_DATA_PREFIX);
        return indexOfSignature >= 0 ? name.subSequence(0, indexOfSignature) : name;
    }
}

