/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.antlr.debug.misc.JTreeASTModel;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;

public class ASTFrameEx
extends JFrame {
    JTree tree;
    JTextArea text;

    private void displayText(String s) {
        this.text.setText(s);
    }

    private void appendText(String s) {
        this.text.setText(this.text.getText() + s);
    }

    public ASTFrameEx(String lab, AST r) {
        super(lab);
        JTreeASTModel model = new JTreeASTModel(r);
        this.tree = new JTree((TreeModel)model);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        MyTreeSelectionListener listener = new MyTreeSelectionListener();
        this.tree.addTreeSelectionListener(listener);
        JScrollPane treeScroller = new JScrollPane(this.tree);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.text = new JTextArea(){

            @Override
            public Insets getInsets() {
                return new Insets(6, 6, 6, 6);
            }
        };
        this.text.setEditable(false);
        this.text.setTabSize(4);
        JScrollPane textScroller = new JScrollPane(this.text);
        JSplitPane splitter = new JSplitPane(0);
        splitter.setLeftComponent(treeScroller);
        splitter.setRightComponent(textScroller);
        splitter.setDividerSize(2);
        splitter.setResizeWeight(0.6);
        content.add((Component)splitter, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Frame f = (Frame)e.getSource();
                f.setVisible(false);
                f.dispose();
            }
        });
        this.setSize(320, 480);
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath path = event.getPath();
            AST ast = (AST)path.getLastPathComponent();
            ASTFrameEx.this.displayText("name:\t" + ast.getText());
            ASTFrameEx.this.appendText("\ntype:\t" + TraceUtils.getTokenTypeName(ast));
            ASTFrameEx.this.appendText("\npos:\t" + ast.getLine() + ':' + ast.getColumn());
        }
    }
}

